/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class VCFStandardHeaderLines {
    private static final boolean REPAIR_BAD_DESCRIPTIONS = false;
    private static Standards<VCFFormatHeaderLine> formatStandards = new Standards();
    private static Standards<VCFInfoHeaderLine> infoStandards = new Standards();

    public static VCFHeader repairStandardHeaderLines(VCFHeader vCFHeader) {
        LinkedHashSet<VCFHeaderLine> linkedHashSet = new LinkedHashSet<VCFHeaderLine>(vCFHeader.getMetaDataInInputOrder().size());
        for (VCFHeaderLine vCFHeaderLine : vCFHeader.getMetaDataInInputOrder()) {
            if (vCFHeaderLine instanceof VCFFormatHeaderLine) {
                vCFHeaderLine = formatStandards.repair((VCFFormatHeaderLine)vCFHeaderLine);
            } else if (vCFHeaderLine instanceof VCFInfoHeaderLine) {
                vCFHeaderLine = infoStandards.repair((VCFInfoHeaderLine)vCFHeaderLine);
            }
            linkedHashSet.add(vCFHeaderLine);
        }
        return new VCFHeader(linkedHashSet, vCFHeader.getGenotypeSamples());
    }

    public static Set<String> addStandardFormatLines(Set<VCFHeaderLine> set, boolean bl, Collection<String> collection) {
        return formatStandards.addToHeader(set, collection, bl);
    }

    public static Set<String> addStandardFormatLines(Set<VCFHeaderLine> set, boolean bl, String ... stringArray) {
        return VCFStandardHeaderLines.addStandardFormatLines(set, bl, Arrays.asList(stringArray));
    }

    public static VCFFormatHeaderLine getFormatLine(String string, boolean bl) {
        return formatStandards.get(string, bl);
    }

    public static VCFFormatHeaderLine getFormatLine(String string) {
        return formatStandards.get(string, true);
    }

    private static void registerStandard(VCFFormatHeaderLine vCFFormatHeaderLine) {
        formatStandards.add(vCFFormatHeaderLine);
    }

    public static Set<String> addStandardInfoLines(Set<VCFHeaderLine> set, boolean bl, Collection<String> collection) {
        return infoStandards.addToHeader(set, collection, bl);
    }

    public static Set<String> addStandardInfoLines(Set<VCFHeaderLine> set, boolean bl, String ... stringArray) {
        return VCFStandardHeaderLines.addStandardInfoLines(set, bl, Arrays.asList(stringArray));
    }

    public static VCFInfoHeaderLine getInfoLine(String string, boolean bl) {
        return infoStandards.get(string, bl);
    }

    public static VCFInfoHeaderLine getInfoLine(String string) {
        return VCFStandardHeaderLines.getInfoLine(string, true);
    }

    private static void registerStandard(VCFInfoHeaderLine vCFInfoHeaderLine) {
        infoStandards.add(vCFInfoHeaderLine);
    }

    static {
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("GQ", 1, VCFHeaderLineType.Integer, "Genotype Quality"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Approximate read depth (reads with MQ=255 or with bad mates are filtered)"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("PL", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Normalized, Phred-scaled likelihoods for genotypes as defined in the VCF specification"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("AD", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Allelic depths for the ref and alt alleles in the order listed"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("FT", 1, VCFHeaderLineType.String, "Genotype-level filter"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("PQ", 1, VCFHeaderLineType.Float, "Read-backed phasing quality"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "Stop position of the interval"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("DB", 0, VCFHeaderLineType.Flag, "dbSNP Membership"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Approximate read depth; some reads may have been filtered"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("SB", 1, VCFHeaderLineType.Float, "Strand Bias"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("AF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele Frequency, for each ALT allele, in the same order as listed"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("AC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Allele count in genotypes, for each ALT allele, in the same order as listed"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("AN", 1, VCFHeaderLineType.Integer, "Total number of alleles in called genotypes"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("MQ0", 1, VCFHeaderLineType.Integer, "Total Mapping Quality Zero Reads"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("MQ", 1, VCFHeaderLineType.Float, "RMS Mapping Quality"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("SOMATIC", 0, VCFHeaderLineType.Flag, "Somatic event"));
    }

    private static class Standards<T extends VCFCompoundHeaderLine> {
        private final Map<String, T> standards = new HashMap<String, T>();

        private Standards() {
        }

        public T repair(T t) {
            T t2 = this.get(((VCFCompoundHeaderLine)t).getID(), false);
            if (t2 != null) {
                boolean bl;
                boolean bl2;
                boolean bl3 = ((VCFCompoundHeaderLine)t).getCountType() != ((VCFCompoundHeaderLine)t2).getCountType();
                boolean bl4 = ((VCFCompoundHeaderLine)t).isFixedCount() && !bl3 && ((VCFCompoundHeaderLine)t).getCount() != ((VCFCompoundHeaderLine)t2).getCount();
                boolean bl5 = ((VCFCompoundHeaderLine)t).getType() != ((VCFCompoundHeaderLine)t2).getType();
                boolean bl6 = bl2 = !((VCFCompoundHeaderLine)t).getDescription().equals(((VCFCompoundHeaderLine)t2).getDescription());
                boolean bl7 = bl3 || bl4 || bl5 ? true : (bl = false);
                if (bl) {
                    return t2;
                }
                return t;
            }
            return t;
        }

        public Set<String> addToHeader(Set<VCFHeaderLine> set, Collection<String> collection, boolean bl) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : collection) {
                T t = this.get(string, bl);
                if (t == null) {
                    hashSet.add(string);
                    continue;
                }
                set.add((VCFHeaderLine)t);
            }
            return hashSet;
        }

        public void add(T t) {
            if (this.standards.containsKey(((VCFCompoundHeaderLine)t).getID())) {
                throw new TribbleException("Attempting to add multiple standard header lines for ID " + ((VCFCompoundHeaderLine)t).getID());
            }
            this.standards.put(((VCFCompoundHeaderLine)t).getID(), t);
        }

        public T get(String string, boolean bl) {
            VCFCompoundHeaderLine vCFCompoundHeaderLine = (VCFCompoundHeaderLine)this.standards.get(string);
            if (bl && vCFCompoundHeaderLine == null) {
                throw new TribbleException("Couldn't find a standard VCF header line for field " + string);
            }
            return (T)vCFCompoundHeaderLine;
        }
    }
}

