/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFLineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class VCF4Parser
implements VCFLineParser {
    VCF4Parser() {
    }

    @Override
    public Map<String, String> parseLine(String string, List<String> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        int n = 0;
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (c == '\"') {
                bl = !bl;
            } else if (bl) {
                stringBuilder.append(c);
            } else {
                switch (c) {
                    case '<': {
                        if (n == 0) break;
                    }
                    case '>': {
                        if (n != string.length() - 1) break;
                        linkedHashMap.put(string2, stringBuilder.toString().trim());
                        break;
                    }
                    case '=': {
                        string2 = stringBuilder.toString().trim();
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    case ',': {
                        linkedHashMap.put(string2, stringBuilder.toString().trim());
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            ++n;
        }
        n = 0;
        if (list != null) {
            if (linkedHashMap.size() > list.size()) {
                throw new TribbleException.InvalidHeader("unexpected tag count " + linkedHashMap.size() + " in line " + string);
            }
            Object object = linkedHashMap.keySet().iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                if (!list.get(n).equals(string3)) {
                    throw new TribbleException.InvalidHeader("Unexpected tag " + string3 + " in line " + string);
                }
                ++n;
            }
        }
        return linkedHashMap;
    }
}

