/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.CommonInfo;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariantContext
implements Feature,
Serializable {
    public static final long serialVersionUID = 1L;
    private static final boolean WARN_ABOUT_BAD_END = true;
    private static final int MAX_ALLELE_SIZE_FOR_NON_SV = 150;
    private boolean fullyDecoded = false;
    protected CommonInfo commonInfo = null;
    public static final double NO_LOG10_PERROR = 1.0;
    public static final Set<String> PASSES_FILTERS = Collections.unmodifiableSet(new LinkedHashSet());
    protected final String contig;
    protected final long start;
    protected final long stop;
    private final String ID;
    protected Type type = null;
    protected final List<Allele> alleles;
    protected GenotypesContext genotypes = null;
    protected int[] genotypeCounts = null;
    public static final GenotypesContext NO_GENOTYPES = GenotypesContext.NO_GENOTYPES;
    private Allele REF = null;
    private Allele ALT = null;
    private Boolean monomorphic = null;
    private static final EnumSet<Validation> NO_VALIDATION = EnumSet.noneOf(Validation.class);

    public List<String> calcVCFGenotypeKeys(VCFHeader vCFHeader) {
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (Serializable serializable : this.getGenotypes()) {
            hashSet.addAll(((Genotype)serializable).getExtendedAttributes().keySet());
            if (((Genotype)serializable).isAvailable()) {
                bl = true;
            }
            if (((Genotype)serializable).hasGQ()) {
                bl2 = true;
            }
            if (((Genotype)serializable).hasDP()) {
                bl4 = true;
            }
            if (((Genotype)serializable).hasAD()) {
                bl5 = true;
            }
            if (((Genotype)serializable).hasPL()) {
                bl6 = true;
            }
            if (!((Genotype)serializable).isFiltered()) continue;
            bl3 = true;
        }
        if (bl2) {
            hashSet.add("GQ");
        }
        if (bl4) {
            hashSet.add("DP");
        }
        if (bl5) {
            hashSet.add("AD");
        }
        if (bl6) {
            hashSet.add("PL");
        }
        if (bl3) {
            hashSet.add("FT");
        }
        Object object = ParsingUtils.sortList(new ArrayList(hashSet));
        if (bl) {
            Serializable serializable;
            serializable = new ArrayList(object.size() + 1);
            serializable.add("GT");
            serializable.addAll(object);
            object = serializable;
        }
        if (object.isEmpty() && vCFHeader.hasGenotypingData()) {
            return Collections.singletonList("GT");
        }
        return object;
    }

    protected VariantContext(VariantContext variantContext) {
        this(variantContext.getSource(), variantContext.getID(), variantContext.getChr(), variantContext.getStart(), variantContext.getEnd(), variantContext.getAlleles(), variantContext.getGenotypes(), variantContext.getLog10PError(), variantContext.getFiltersMaybeNull(), variantContext.getAttributes(), variantContext.fullyDecoded, NO_VALIDATION);
    }

    protected VariantContext(String string, String string2, String string3, long l, long l2, Collection<Allele> collection, GenotypesContext genotypesContext, double d, Set<String> set, Map<String, Object> map, boolean bl, EnumSet<Validation> enumSet) {
        if (string3 == null) {
            throw new IllegalArgumentException("Contig cannot be null");
        }
        this.contig = string3;
        this.start = l;
        this.stop = l2;
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("ID field cannot be the null or the empty string");
        }
        this.ID = string2.equals(".") ? "." : string2;
        this.commonInfo = new CommonInfo(string, d, set, map);
        if (collection == null) {
            throw new IllegalArgumentException("Alleles cannot be null");
        }
        this.alleles = VariantContext.makeAlleles(collection);
        this.genotypes = genotypesContext == null || genotypesContext == NO_GENOTYPES ? NO_GENOTYPES : genotypesContext.immutable();
        int n = collection.size();
        for (Allele allele : collection) {
            if (allele.isReference()) {
                this.REF = allele;
                continue;
            }
            if (n != 2) continue;
            this.ALT = allele;
        }
        this.fullyDecoded = bl;
        if (!enumSet.isEmpty()) {
            this.validate(enumSet);
        }
    }

    public VariantContext subContextFromSamples(Set<String> set, boolean bl) {
        if (set.containsAll(this.getSampleNames()) && !bl) {
            return this;
        }
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(this);
        GenotypesContext genotypesContext = this.genotypes.subsetToSamples(set);
        if (bl) {
            Set<Allele> set2 = this.allelesOfGenotypes(genotypesContext);
            ArrayList<Allele> arrayList = new ArrayList<Allele>(set2.size());
            for (Allele allele : this.alleles) {
                if (!set2.contains(allele)) continue;
                arrayList.add(allele);
            }
            variantContextBuilder.alleles((Collection<Allele>)arrayList);
        } else {
            variantContextBuilder.alleles((Collection<Allele>)this.alleles);
        }
        return variantContextBuilder.genotypes(genotypesContext).make();
    }

    public VariantContext subContextFromSamples(Set<String> set) {
        return this.subContextFromSamples(set, true);
    }

    public VariantContext subContextFromSample(String string) {
        return this.subContextFromSamples(Collections.singleton(string));
    }

    private final Set<Allele> allelesOfGenotypes(Collection<Genotype> collection) {
        HashSet<Allele> hashSet = new HashSet<Allele>();
        boolean bl = false;
        for (Genotype genotype : collection) {
            for (Allele allele : genotype.getAlleles()) {
                boolean bl2 = bl = bl || allele.isReference();
                if (!allele.isCalled()) continue;
                hashSet.add(allele);
            }
        }
        if (!bl) {
            hashSet.add(this.getReference());
        }
        return hashSet;
    }

    public Type getType() {
        if (this.type == null) {
            this.determineType();
        }
        return this.type;
    }

    public boolean isSNP() {
        return this.getType() == Type.SNP;
    }

    public boolean isVariant() {
        return this.getType() != Type.NO_VARIATION;
    }

    public boolean isPointEvent() {
        return this.isSNP() || !this.isVariant();
    }

    public boolean isIndel() {
        return this.getType() == Type.INDEL;
    }

    public boolean isSimpleInsertion() {
        return this.isSimpleIndel() && this.getReference().length() == 1;
    }

    public boolean isSimpleDeletion() {
        return this.isSimpleIndel() && this.getAlternateAllele(0).length() == 1;
    }

    public boolean isSimpleIndel() {
        return this.getType() == Type.INDEL && this.isBiallelic() && this.getReference().length() > 0 && this.getAlternateAllele(0).length() > 0 && this.getReference().getBases()[0] == this.getAlternateAllele(0).getBases()[0] && (this.getReference().length() == 1 || this.getAlternateAllele(0).length() == 1);
    }

    public boolean isComplexIndel() {
        return this.isIndel() && !this.isSimpleDeletion() && !this.isSimpleInsertion();
    }

    public boolean isSymbolic() {
        return this.getType() == Type.SYMBOLIC;
    }

    public boolean isStructuralIndel() {
        List<Integer> list;
        if (this.getType() == Type.INDEL && (list = this.getIndelLengths()) != null) {
            for (Integer n : list) {
                if (n <= 150) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSymbolicOrSV() {
        return this.isSymbolic() || this.isStructuralIndel();
    }

    public boolean isMNP() {
        return this.getType() == Type.MNP;
    }

    public boolean isMixed() {
        return this.getType() == Type.MIXED;
    }

    public boolean hasID() {
        return this.getID() != ".";
    }

    public boolean emptyID() {
        return !this.hasID();
    }

    public String getID() {
        return this.ID;
    }

    public String getSource() {
        return this.commonInfo.getName();
    }

    public Set<String> getFiltersMaybeNull() {
        return this.commonInfo.getFiltersMaybeNull();
    }

    public Set<String> getFilters() {
        return this.commonInfo.getFilters();
    }

    public boolean isFiltered() {
        return this.commonInfo.isFiltered();
    }

    public boolean isNotFiltered() {
        return this.commonInfo.isNotFiltered();
    }

    public boolean filtersWereApplied() {
        return this.commonInfo.filtersWereApplied();
    }

    public boolean hasLog10PError() {
        return this.commonInfo.hasLog10PError();
    }

    public double getLog10PError() {
        return this.commonInfo.getLog10PError();
    }

    public double getPhredScaledQual() {
        return this.commonInfo.getPhredScaledQual();
    }

    public Map<String, Object> getAttributes() {
        return this.commonInfo.getAttributes();
    }

    public boolean hasAttribute(String string) {
        return this.commonInfo.hasAttribute(string);
    }

    public Object getAttribute(String string) {
        return this.commonInfo.getAttribute(string);
    }

    public Object getAttribute(String string, Object object) {
        return this.commonInfo.getAttribute(string, object);
    }

    public String getAttributeAsString(String string, String string2) {
        return this.commonInfo.getAttributeAsString(string, string2);
    }

    public int getAttributeAsInt(String string, int n) {
        return this.commonInfo.getAttributeAsInt(string, n);
    }

    public double getAttributeAsDouble(String string, double d) {
        return this.commonInfo.getAttributeAsDouble(string, d);
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        return this.commonInfo.getAttributeAsBoolean(string, bl);
    }

    public List<Object> getAttributeAsList(String string) {
        return this.commonInfo.getAttributeAsList(string);
    }

    public CommonInfo getCommonInfo() {
        return this.commonInfo;
    }

    public Allele getReference() {
        Allele allele = this.REF;
        if (allele == null) {
            throw new IllegalStateException("BUG: no reference allele found at " + this);
        }
        return allele;
    }

    public boolean isBiallelic() {
        return this.getNAlleles() == 2;
    }

    public int getNAlleles() {
        return this.alleles.size();
    }

    public int getMaxPloidy(int n) {
        return this.genotypes.getMaxPloidy(n);
    }

    public Allele getAllele(String string) {
        return this.getAllele(string.getBytes());
    }

    public Allele getAllele(byte[] byArray) {
        return Allele.getMatchingAllele(this.getAlleles(), byArray);
    }

    public boolean hasAllele(Allele allele) {
        return this.hasAllele(allele, false, true);
    }

    public boolean hasAllele(Allele allele, boolean bl) {
        return this.hasAllele(allele, bl, true);
    }

    public boolean hasAlternateAllele(Allele allele) {
        return this.hasAllele(allele, false, false);
    }

    public boolean hasAlternateAllele(Allele allele, boolean bl) {
        return this.hasAllele(allele, bl, false);
    }

    private boolean hasAllele(Allele allele, boolean bl, boolean bl2) {
        if (bl2 && allele == this.REF || allele == this.ALT) {
            return true;
        }
        List<Allele> list = bl2 ? this.getAlleles() : this.getAlternateAlleles();
        for (Allele allele2 : list) {
            if (!allele2.equals(allele, bl)) continue;
            return true;
        }
        return false;
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public List<Allele> getAlternateAlleles() {
        return this.alleles.subList(1, this.alleles.size());
    }

    public List<Integer> getIndelLengths() {
        if (this.getType() != Type.INDEL && this.getType() != Type.MIXED) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Allele allele : this.getAlternateAlleles()) {
            arrayList.add(allele.length() - this.getReference().length());
        }
        return arrayList;
    }

    public Allele getAlternateAllele(int n) {
        return this.alleles.get(n + 1);
    }

    public boolean hasSameAllelesAs(VariantContext variantContext) {
        return this.hasSameAlternateAllelesAs(variantContext) && variantContext.getReference().equals(this.getReference(), false);
    }

    public boolean hasSameAlternateAllelesAs(VariantContext variantContext) {
        List<Allele> list = this.getAlternateAlleles();
        List<Allele> list2 = variantContext.getAlternateAlleles();
        if (list.size() != list2.size()) {
            return false;
        }
        for (Allele allele : list) {
            if (list2.contains(allele)) continue;
            return false;
        }
        return true;
    }

    public int getNSamples() {
        return this.genotypes.size();
    }

    public boolean hasGenotypes() {
        return !this.genotypes.isEmpty();
    }

    public boolean hasGenotypes(Collection<String> collection) {
        return this.genotypes.containsSamples(collection);
    }

    public GenotypesContext getGenotypes() {
        return this.genotypes;
    }

    public Iterable<Genotype> getGenotypesOrderedByName() {
        return this.genotypes.iterateInSampleNameOrder();
    }

    public Iterable<Genotype> getGenotypesOrderedBy(Iterable<String> iterable) {
        return this.genotypes.iterateInSampleNameOrder(iterable);
    }

    public GenotypesContext getGenotypes(String string) {
        return this.getGenotypes(Collections.singleton(string));
    }

    protected GenotypesContext getGenotypes(Collection<String> collection) {
        return this.getGenotypes().subsetToSamples(new HashSet<String>(collection));
    }

    public GenotypesContext getGenotypes(Set<String> set) {
        return this.getGenotypes().subsetToSamples(set);
    }

    public Set<String> getSampleNames() {
        return this.getGenotypes().getSampleNames();
    }

    public List<String> getSampleNamesOrderedByName() {
        return this.getGenotypes().getSampleNamesOrderedByName();
    }

    public Genotype getGenotype(String string) {
        return this.getGenotypes().get(string);
    }

    public boolean hasGenotype(String string) {
        return this.getGenotypes().containsSample(string);
    }

    public Genotype getGenotype(int n) {
        return this.genotypes.size() > n ? this.genotypes.get(n) : null;
    }

    public int getCalledChrCount() {
        Set<String> set = Collections.emptySet();
        return this.getCalledChrCount(set);
    }

    public int getCalledChrCount(Set<String> set) {
        int n = 0;
        GenotypesContext genotypesContext = set.isEmpty() ? this.getGenotypes() : this.getGenotypes(set);
        for (Genotype genotype : genotypesContext) {
            for (Allele allele : genotype.getAlleles()) {
                n += allele.isNoCall() ? 0 : 1;
            }
        }
        return n;
    }

    public int getCalledChrCount(Allele allele) {
        return this.getCalledChrCount(allele, new HashSet<String>(0));
    }

    public int getCalledChrCount(Allele allele, Set<String> set) {
        int n = 0;
        GenotypesContext genotypesContext = set.isEmpty() ? this.getGenotypes() : this.getGenotypes(set);
        for (Genotype genotype : genotypesContext) {
            n += genotype.countAllele(allele);
        }
        return n;
    }

    public boolean isMonomorphicInSamples() {
        if (this.monomorphic == null) {
            this.monomorphic = !this.isVariant() || this.hasGenotypes() && this.getCalledChrCount(this.getReference()) == this.getCalledChrCount();
        }
        return this.monomorphic;
    }

    public boolean isPolymorphicInSamples() {
        return !this.isMonomorphicInSamples();
    }

    private void calculateGenotypeCounts() {
        if (this.genotypeCounts == null) {
            this.genotypeCounts = new int[GenotypeType.values().length];
            for (Genotype genotype : this.getGenotypes()) {
                int n = genotype.getType().ordinal();
                this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
            }
        }
    }

    public int getNoCallCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.NO_CALL.ordinal()];
    }

    public int getHomRefCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.HOM_REF.ordinal()];
    }

    public int getHetCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.HET.ordinal()];
    }

    public int getHomVarCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.HOM_VAR.ordinal()];
    }

    public int getMixedCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.MIXED.ordinal()];
    }

    public void extraStrictValidation(Allele allele, Allele allele2, Set<String> set) {
        this.validateReferenceBases(allele, allele2);
        this.validateRSIDs(set);
        this.validateAlternateAlleles();
        this.validateChromosomeCounts();
    }

    public void validateReferenceBases(Allele allele, Allele allele2) {
        if (allele != null && !allele.basesMatch(allele2)) {
            throw new TribbleException.InternalCodecException(String.format("the REF allele is incorrect for the record at position %s:%d, fasta says %s vs. VCF says %s", this.getContig(), this.getStart(), allele2.getBaseString(), allele.getBaseString()));
        }
    }

    public void validateRSIDs(Set<String> set) {
        if (set != null && this.hasID()) {
            for (String string : this.getID().split(";")) {
                if (!string.startsWith("rs") || set.contains(string)) continue;
                throw new TribbleException.InternalCodecException(String.format("the rsID %s for the record at position %s:%d is not in dbSNP", string, this.getContig(), this.getStart()));
            }
        }
    }

    public void validateAlternateAlleles() {
        if (!this.hasGenotypes()) {
            return;
        }
        ArrayList<Allele> arrayList = new ArrayList<Allele>();
        for (Allele object : this.getAlleles()) {
            if (object.isSymbolic()) continue;
            arrayList.add(object);
        }
        HashSet hashSet = new HashSet();
        hashSet.add(this.getReference());
        for (Genotype genotype : this.getGenotypes()) {
            if (!genotype.isCalled()) continue;
            for (Allele allele : genotype.getAlleles()) {
                if (allele.isSymbolic()) continue;
                hashSet.add(allele);
            }
        }
        if (hashSet.contains(Allele.NO_CALL)) {
            hashSet.remove(Allele.NO_CALL);
        }
        if (arrayList.size() != hashSet.size()) {
            throw new TribbleException.InternalCodecException(String.format("one or more of the ALT allele(s) for the record at position %s:%d are not observed at all in the sample genotypes", this.getContig(), this.getStart()));
        }
        int n = arrayList.size();
        hashSet.retainAll(arrayList);
        if (hashSet.size() != n) {
            throw new TribbleException.InternalCodecException(String.format("one or more of the ALT allele(s) for the record at position %s:%d are not observed at all in the sample genotypes", this.getContig(), this.getStart()));
        }
    }

    public void validateChromosomeCounts() {
        int n;
        int n2;
        if (!this.hasGenotypes()) {
            return;
        }
        if (this.hasAttribute("AN") && (n2 = Integer.valueOf(this.getAttribute("AN").toString()).intValue()) != (n = this.getCalledChrCount())) {
            throw new TribbleException.InternalCodecException(String.format("the Allele Number (AN) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getContig(), this.getStart(), n2, n));
        }
        if (this.hasAttribute("AC")) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (this.getAlternateAlleles().size() > 0) {
                for (Allele allele : this.getAlternateAlleles()) {
                    arrayList.add(this.getCalledChrCount(allele));
                }
            } else {
                arrayList.add(0);
            }
            if (this.getAttribute("AC") instanceof List) {
                List list = (List)this.getAttribute("AC");
                if (arrayList.size() != list.size()) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have the correct number of values for the record at position %s:%d, %d vs. %d", this.getContig(), this.getStart(), list.size(), arrayList.size()));
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n3 = Integer.valueOf(list.get(i).toString());
                    if (n3 == (Integer)arrayList.get(i)) continue;
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %s vs. %d", this.getContig(), this.getStart(), n3, arrayList.get(i)));
                }
            } else {
                if (arrayList.size() != 1) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have enough values for the record at position %s:%d", this.getContig(), this.getStart()));
                }
                int n4 = Integer.valueOf(this.getAttribute("AC").toString());
                if (n4 != (Integer)arrayList.get(0)) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getContig(), this.getStart(), n4, arrayList.get(0)));
                }
            }
        }
    }

    private boolean validate(EnumSet<Validation> enumSet) {
        this.validateStop();
        block4: for (Validation validation : enumSet) {
            switch (validation) {
                case ALLELES: {
                    this.validateAlleles();
                    continue block4;
                }
                case GENOTYPES: {
                    this.validateGenotypes();
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected validation mode " + (Object)((Object)validation));
        }
        return true;
    }

    private void validateStop() {
        if (this.hasAttribute("END")) {
            int n = this.getAttributeAsInt("END", -1);
            assert (n != -1);
            if (n != this.getEnd()) {
                String string = "Badly formed variant context at location " + this.getContig() + ":" + this.getStart() + "; getEnd() was " + this.getEnd() + " but this VariantContext contains an END key with value " + n;
                throw new TribbleException(string);
            }
        } else {
            long l = this.stop - this.start + 1L;
            if (!this.hasSymbolicAlleles() && l != (long)this.getReference().length()) {
                throw new IllegalStateException("BUG: GenomeLoc " + this.contig + ":" + this.start + "-" + this.stop + " has a size == " + l + " but the variation reference allele has length " + this.getReference().length() + " this = " + this);
            }
        }
    }

    private void validateAlleles() {
        boolean bl = false;
        for (Allele allele : this.alleles) {
            if (allele.isReference()) {
                if (bl) {
                    throw new IllegalArgumentException("BUG: Received two reference tagged alleles in VariantContext " + this.alleles + " this=" + this);
                }
                bl = true;
            }
            if (!allele.isNoCall()) continue;
            throw new IllegalArgumentException("BUG: Cannot add a no call allele to a variant context " + this.alleles + " this=" + this);
        }
        if (!bl) {
            throw new IllegalArgumentException("No reference allele found in VariantContext");
        }
    }

    private void validateGenotypes() {
        if (this.genotypes == null) {
            throw new IllegalStateException("Genotypes is null");
        }
        for (Genotype genotype : this.genotypes) {
            if (!genotype.isAvailable()) continue;
            for (Allele allele : genotype.getAlleles()) {
                if (this.hasAllele(allele) || !allele.isCalled()) continue;
                throw new IllegalStateException("Allele in genotype " + allele + " not in the variant context " + this.alleles);
            }
        }
    }

    private void determineType() {
        if (this.type == null) {
            switch (this.getNAlleles()) {
                case 0: {
                    throw new IllegalStateException("Unexpected error: requested type of VariantContext with no alleles!" + this);
                }
                case 1: {
                    this.type = Type.NO_VARIATION;
                    break;
                }
                default: {
                    this.determinePolymorphicType();
                }
            }
        }
    }

    private void determinePolymorphicType() {
        this.type = null;
        for (Allele allele : this.alleles) {
            if (allele == this.REF) continue;
            Type type = VariantContext.typeOfBiallelicVariant(this.REF, allele);
            if (this.type == null) {
                this.type = type;
                continue;
            }
            if (type == this.type) continue;
            this.type = Type.MIXED;
            return;
        }
    }

    private static Type typeOfBiallelicVariant(Allele allele, Allele allele2) {
        if (allele.isSymbolic()) {
            throw new IllegalStateException("Unexpected error: encountered a record with a symbolic reference allele");
        }
        if (allele2.isSymbolic()) {
            return Type.SYMBOLIC;
        }
        if (allele.length() == allele2.length()) {
            if (allele2.length() == 1) {
                return Type.SNP;
            }
            return Type.MNP;
        }
        return Type.INDEL;
    }

    public String toString() {
        return this.genotypes.isLazyWithData() ? this.toStringUnparsedGenotypes() : this.toStringDecodeGenotypes();
    }

    public String toStringDecodeGenotypes() {
        return String.format("[VC %s @ %s Q%s of type=%s alleles=%s attr=%s GT=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.hasLog10PError() ? String.format("%.2f", this.getPhredScaledQual()) : ".", this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes()), this.getGenotypes()});
    }

    private String toStringUnparsedGenotypes() {
        return String.format("[VC %s @ %s Q%s of type=%s alleles=%s attr=%s GT=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.hasLog10PError() ? String.format("%.2f", this.getPhredScaledQual()) : ".", this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes()), ((LazyGenotypesContext)this.genotypes).getUnparsedGenotypeData()});
    }

    public String toStringWithoutGenotypes() {
        return String.format("[VC %s @ %s Q%s of type=%s alleles=%s attr=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.hasLog10PError() ? String.format("%.2f", this.getPhredScaledQual()) : ".", this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes())});
    }

    private static List<Allele> makeAlleles(Collection<Allele> collection) {
        ArrayList<Allele> arrayList = new ArrayList<Allele>(collection.size());
        boolean bl = false;
        for (Allele allele : collection) {
            for (Allele allele2 : arrayList) {
                if (!allele.equals(allele2, true)) continue;
                throw new IllegalArgumentException("Duplicate allele added to VariantContext: " + allele);
            }
            if (allele.isReference()) {
                if (bl) {
                    throw new IllegalArgumentException("Alleles for a VariantContext must contain at most one reference allele: " + collection);
                }
                arrayList.add(0, allele);
                bl = true;
                continue;
            }
            arrayList.add(allele);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a VariantContext with an empty allele list");
        }
        if (((Allele)arrayList.get(0)).isNonReference()) {
            throw new IllegalArgumentException("Alleles for a VariantContext must contain at least one reference allele: " + collection);
        }
        return arrayList;
    }

    public VariantContext fullyDecode(VCFHeader vCFHeader, boolean bl) {
        if (this.isFullyDecoded()) {
            return this;
        }
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(this);
        this.fullyDecodeInfo(variantContextBuilder, vCFHeader, bl);
        this.fullyDecodeGenotypes(variantContextBuilder, vCFHeader);
        variantContextBuilder.fullyDecoded(true);
        return variantContextBuilder.make();
    }

    public boolean isFullyDecoded() {
        return this.fullyDecoded;
    }

    private final void fullyDecodeInfo(VariantContextBuilder variantContextBuilder, VCFHeader vCFHeader, boolean bl) {
        variantContextBuilder.attributes(this.fullyDecodeAttributes(this.getAttributes(), vCFHeader, bl));
    }

    private final Map<String, Object> fullyDecodeAttributes(Map<String, Object> map, VCFHeader vCFHeader, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int n;
            int n2;
            String string = entry.getKey();
            if (string.equals("FT")) continue;
            VCFCompoundHeaderLine vCFCompoundHeaderLine = VariantContextUtils.getMetaDataForField(vCFHeader, string);
            Object object = this.decodeValue(string, entry.getValue(), vCFCompoundHeaderLine);
            if (object != null && !bl && vCFCompoundHeaderLine.getCountType() != VCFHeaderLineCount.UNBOUNDED && vCFCompoundHeaderLine.getType() != VCFHeaderLineType.Flag && (n2 = object instanceof List ? ((List)object).size() : 1) != (n = vCFCompoundHeaderLine.getCount(this))) {
                throw new TribbleException.InvalidHeader("Discordant field size detected for field " + string + " at " + this.getContig() + ":" + this.getStart() + ".  Field had " + n2 + " values " + "but the header says this should have " + n + " values based on header record " + vCFCompoundHeaderLine);
            }
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private final Object decodeValue(String string, Object object, VCFCompoundHeaderLine vCFCompoundHeaderLine) {
        if (object instanceof String) {
            if (string.equals("PL")) {
                return GenotypeLikelihoods.fromPLField((String)object);
            }
            String string2 = (String)object;
            if (string2.indexOf(",") != -1) {
                String[] stringArray = string2.split(",");
                ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(this.decodeOne(string, stringArray[i], vCFCompoundHeaderLine));
                }
                return arrayList;
            }
            return this.decodeOne(string, string2, vCFCompoundHeaderLine);
        }
        if (object instanceof List && ((List)object).get(0) instanceof String) {
            List list = (List)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (String string3 : list) {
                arrayList.add(this.decodeOne(string, string3, vCFCompoundHeaderLine));
            }
            return arrayList;
        }
        return object;
    }

    private final Object decodeOne(String string, String string2, VCFCompoundHeaderLine vCFCompoundHeaderLine) {
        try {
            if (string2.equals(".")) {
                return null;
            }
            switch (vCFCompoundHeaderLine.getType()) {
                case Character: {
                    return string2;
                }
                case Flag: {
                    boolean bl;
                    boolean bl2 = bl = Boolean.valueOf(string2) != false || string2.equals("1");
                    if (!bl) {
                        throw new TribbleException("VariantContext FLAG fields " + string + " cannot contain false values" + " as seen at " + this.getContig() + ":" + this.getStart());
                    }
                    return bl;
                }
                case String: {
                    return string2;
                }
                case Integer: {
                    return Integer.valueOf(string2);
                }
                case Float: {
                    return Double.valueOf(string2);
                }
            }
            throw new TribbleException("Unexpected type for field" + string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TribbleException("Could not decode field " + string + " with value " + string2 + " of declared type " + (Object)((Object)vCFCompoundHeaderLine.getType()));
        }
    }

    private final void fullyDecodeGenotypes(VariantContextBuilder variantContextBuilder, VCFHeader vCFHeader) {
        GenotypesContext genotypesContext = new GenotypesContext();
        for (Genotype genotype : this.getGenotypes()) {
            genotypesContext.add(this.fullyDecodeGenotypes(genotype, vCFHeader));
        }
        variantContextBuilder.genotypesNoValidation(genotypesContext);
    }

    private final Genotype fullyDecodeGenotypes(Genotype genotype, VCFHeader vCFHeader) {
        Map<String, Object> map = this.fullyDecodeAttributes(genotype.getExtendedAttributes(), vCFHeader, true);
        return new GenotypeBuilder(genotype).attributes(map).make();
    }

    @Override
    @Deprecated
    public String getChr() {
        return this.getContig();
    }

    @Override
    public String getContig() {
        return this.contig;
    }

    @Override
    public int getStart() {
        return (int)this.start;
    }

    @Override
    public int getEnd() {
        return (int)this.stop;
    }

    public boolean hasSymbolicAlleles() {
        return VariantContext.hasSymbolicAlleles(this.getAlleles());
    }

    public static boolean hasSymbolicAlleles(List<Allele> list) {
        for (Allele allele : list) {
            if (!allele.isSymbolic()) continue;
            return true;
        }
        return false;
    }

    public Allele getAltAlleleWithHighestAlleleCount() {
        if (this.isBiallelic()) {
            return this.getAlternateAllele(0);
        }
        Allele allele = null;
        int n = 0;
        for (Allele allele2 : this.getAlternateAlleles()) {
            int n2 = this.getCalledChrCount(allele2);
            if (n2 < n) continue;
            n = n2;
            allele = allele2;
        }
        return allele;
    }

    public int getAlleleIndex(Allele allele) {
        return this.getAlleles().indexOf(allele);
    }

    public List<Integer> getAlleleIndices(Collection<Allele> collection) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (Allele allele : collection) {
            linkedList.add(this.getAlleleIndex(allele));
        }
        return linkedList;
    }

    public int[] getGLIndecesOfAlternateAllele(Allele allele) {
        int n = this.getAlleleIndex(allele);
        if (n == -1) {
            throw new IllegalArgumentException("Allele " + allele + " not in this VariantContex " + this);
        }
        return GenotypeLikelihoods.getPLIndecesOfAlleles(0, n);
    }

    public static enum Type {
        NO_VARIATION,
        SNP,
        MNP,
        INDEL,
        SYMBOLIC,
        MIXED;

    }

    public static enum Validation {
        ALLELES,
        GENOTYPES;

    }
}

