/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class BCF2Utils {
    public static final int MAX_ALLELES_IN_GENOTYPES = 127;
    public static final int OVERFLOW_ELEMENT_MARKER = 15;
    public static final int MAX_INLINE_ELEMENTS = 14;
    public static final BCF2Type[] INTEGER_TYPES_BY_SIZE = new BCF2Type[]{BCF2Type.INT8, BCF2Type.INT16, BCF2Type.INT32};
    public static final BCF2Type[] ID_TO_ENUM;

    private BCF2Utils() {
    }

    public static ArrayList<String> makeDictionary(VCFHeader vCFHeader) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        hashSet.add("PASS");
        arrayList.add("PASS");
        for (VCFHeaderLine vCFHeaderLine : vCFHeader.getMetaDataInInputOrder()) {
            VCFIDHeaderLine vCFIDHeaderLine;
            if (!vCFHeaderLine.shouldBeAddedToDictionary() || hashSet.contains((vCFIDHeaderLine = (VCFIDHeaderLine)((Object)vCFHeaderLine)).getID())) continue;
            arrayList.add(vCFIDHeaderLine.getID());
            hashSet.add(vCFIDHeaderLine.getID());
        }
        return arrayList;
    }

    public static byte encodeTypeDescriptor(int n, BCF2Type bCF2Type) {
        return (byte)((0xF & n) << 4 | bCF2Type.getID() & 0xF);
    }

    public static int decodeSize(byte by) {
        return (0xF0 & by) >> 4;
    }

    public static int decodeTypeID(byte by) {
        return by & 0xF;
    }

    public static BCF2Type decodeType(byte by) {
        return ID_TO_ENUM[BCF2Utils.decodeTypeID(by)];
    }

    public static boolean sizeIsOverflow(byte by) {
        return BCF2Utils.decodeSize(by) == 15;
    }

    public static byte readByte(InputStream inputStream) throws IOException {
        return (byte)(inputStream.read() & 0xFF);
    }

    public static String collapseStringList(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (string == null) continue;
            assert (string.indexOf(",") == -1);
            stringBuilder.append(",").append(string);
        }
        return stringBuilder.toString();
    }

    public static List<String> explodeStringList(String string) {
        assert (BCF2Utils.isCollapsedString(string));
        String[] stringArray = string.substring(1).split(",");
        return Arrays.asList(stringArray);
    }

    public static boolean isCollapsedString(String string) {
        return string.length() > 0 && string.charAt(0) == ',';
    }

    public static final File shadowBCF(File file) {
        String string = file.getAbsolutePath();
        if (string.contains(".vcf")) {
            return new File(string.replace(".vcf", ".bcf"));
        }
        File file2 = new File(string + ".bcf");
        if (file2.canRead()) {
            return file2;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.close();
            file2.delete();
            return file2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static BCF2Type determineIntegerType(int n) {
        for (BCF2Type bCF2Type : INTEGER_TYPES_BY_SIZE) {
            if (!bCF2Type.withinRange(n)) continue;
            return bCF2Type;
        }
        throw new TribbleException("Integer cannot be encoded in allowable range of even INT32: " + n);
    }

    public static BCF2Type determineIntegerType(int[] nArray) {
        BCF2Type bCF2Type;
        int n = 0;
        int n2 = 0;
        for (int n3 : nArray) {
            if (n3 > n) {
                n = n3;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        Object object = (Object)BCF2Utils.determineIntegerType(n);
        return ((Enum)object).compareTo(bCF2Type = BCF2Utils.determineIntegerType(n2)) >= 0 ? object : bCF2Type;
    }

    public static BCF2Type maxIntegerType(BCF2Type bCF2Type, BCF2Type bCF2Type2) {
        switch (bCF2Type) {
            case INT8: {
                return bCF2Type2;
            }
            case INT16: {
                return bCF2Type2 == BCF2Type.INT32 ? bCF2Type2 : bCF2Type;
            }
            case INT32: {
                return bCF2Type;
            }
        }
        throw new TribbleException("BUG: unexpected BCF2Type " + (Object)((Object)bCF2Type));
    }

    public static BCF2Type determineIntegerType(List<Integer> list) {
        BCF2Type bCF2Type = BCF2Type.INT8;
        block5: for (int n : list) {
            BCF2Type bCF2Type2 = BCF2Utils.determineIntegerType(n);
            switch (bCF2Type2) {
                case INT8: {
                    continue block5;
                }
                case INT16: {
                    bCF2Type = BCF2Type.INT16;
                    continue block5;
                }
                case INT32: {
                    return BCF2Type.INT32;
                }
            }
            throw new TribbleException("Unexpected integer type " + (Object)((Object)bCF2Type2));
        }
        return bCF2Type;
    }

    public static <T> List<T> toList(Class<T> clazz, Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(object, i));
            }
            return arrayList;
        }
        return Collections.singletonList(object);
    }

    public static boolean headerLinesAreOrderedConsistently(VCFHeader vCFHeader, VCFHeader vCFHeader2) {
        if (!BCF2Utils.nullAsEmpty(vCFHeader.getSampleNamesInOrder()).equals(BCF2Utils.nullAsEmpty(vCFHeader2.getSampleNamesInOrder()))) {
            return false;
        }
        Iterator<VCFIDHeaderLine> iterator = vCFHeader.getIDHeaderLines().iterator();
        Iterator<VCFIDHeaderLine> iterator2 = vCFHeader2.getIDHeaderLines().iterator();
        while (iterator2.hasNext()) {
            if (!iterator.hasNext()) {
                return false;
            }
            VCFIDHeaderLine vCFIDHeaderLine = iterator.next();
            VCFIDHeaderLine vCFIDHeaderLine2 = iterator2.next();
            if (vCFIDHeaderLine2.getClass().equals(vCFIDHeaderLine.getClass()) && vCFIDHeaderLine2.getID().equals(vCFIDHeaderLine.getID())) continue;
            return false;
        }
        return true;
    }

    private static <T> List<T> nullAsEmpty(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    static {
        int n = -1;
        for (BCF2Type bCF2Type : BCF2Type.values()) {
            n = Math.max(bCF2Type.getID(), n);
        }
        ID_TO_ENUM = new BCF2Type[n + 1];
        BCF2Type[] bCF2TypeArray = BCF2Type.values();
        int n2 = bCF2TypeArray.length;
        for (int i = 0; i < n2; ++i) {
            BCF2Type bCF2Type;
            BCF2Utils.ID_TO_ENUM[bCF2Type.getID()] = bCF2Type = bCF2TypeArray[i];
        }
    }
}

