/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import htsjdk.variant.bcf2.BCF2Decoder;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class BCF2GenotypeFieldDecoders {
    private static final boolean ENABLE_FASTPATH_GT = true;
    private static final int MIN_SAMPLES_FOR_FASTPATH_GENOTYPES = 0;
    private final HashMap<String, Decoder> genotypeFieldDecoder = new HashMap();
    private final Decoder defaultDecoder = new GenericDecoder();

    public BCF2GenotypeFieldDecoders(VCFHeader vCFHeader) {
        this.genotypeFieldDecoder.put("GT", new GTDecoder());
        this.genotypeFieldDecoder.put("FT", new FTDecoder());
        this.genotypeFieldDecoder.put("DP", new DPDecoder());
        this.genotypeFieldDecoder.put("AD", new ADDecoder());
        this.genotypeFieldDecoder.put("PL", new PLDecoder());
        this.genotypeFieldDecoder.put("GQ", new GQDecoder());
    }

    public Decoder getDecoder(String string) {
        Decoder decoder = this.genotypeFieldDecoder.get(string);
        return decoder == null ? this.defaultDecoder : decoder;
    }

    private class FTDecoder
    implements Decoder {
        private FTDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                Object object = bCF2Decoder.decodeTypedValue(by, n);
                assert (object == null || object instanceof String);
                genotypeBuilder.filter((String)object);
            }
        }
    }

    private class GenericDecoder
    implements Decoder {
        private GenericDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                Object object = bCF2Decoder.decodeTypedValue(by, n);
                if (object == null) continue;
                if (object instanceof List && ((List)object).size() == 1) {
                    object = ((List)object).get(0);
                }
                genotypeBuilder.attribute(string, object);
            }
        }
    }

    private class PLDecoder
    implements Decoder {
        private PLDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                genotypeBuilder.PL(bCF2Decoder.decodeIntArray(by, n));
            }
        }
    }

    private class ADDecoder
    implements Decoder {
        private ADDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                genotypeBuilder.AD(bCF2Decoder.decodeIntArray(by, n));
            }
        }
    }

    private class GQDecoder
    implements Decoder {
        private GQDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                genotypeBuilder.GQ(bCF2Decoder.decodeInt(by, -1));
            }
        }
    }

    private class DPDecoder
    implements Decoder {
        private DPDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                genotypeBuilder.DP(bCF2Decoder.decodeInt(by, -1));
            }
        }
    }

    private class GTDecoder
    implements Decoder {
        private GTDecoder() {
        }

        @Override
        public void decode(List<Allele> list, String string, BCF2Decoder bCF2Decoder, byte by, int n, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            if (list.size() == 2 && n == 2 && genotypeBuilderArray.length >= 0) {
                this.fastBiallelicDiploidDecode(list, bCF2Decoder, by, genotypeBuilderArray);
            } else {
                this.generalDecode(list, n, bCF2Decoder, by, genotypeBuilderArray);
            }
        }

        private final void fastBiallelicDiploidDecode(List<Allele> list, BCF2Decoder bCF2Decoder, byte by, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            BCF2Type bCF2Type = BCF2Utils.decodeType(by);
            Object[] objectArray = new Object[9];
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                int n;
                int n2 = bCF2Decoder.decodeInt(bCF2Type);
                int n3 = bCF2Decoder.decodeInt(bCF2Type);
                if (n2 == bCF2Type.getMissingBytes()) {
                    assert (n3 == bCF2Type.getMissingBytes());
                    genotypeBuilder.alleles(null);
                } else if (n3 == bCF2Type.getMissingBytes()) {
                    genotypeBuilder.alleles(Arrays.asList(this.getAlleleFromEncoded(list, n2)));
                } else {
                    n = (n2 >> 1) * 3 + (n3 >> 1);
                    assert (n < objectArray.length);
                    List<Allele> list2 = (List<Allele>)objectArray[n];
                    if (list2 == null) {
                        Allele allele = this.getAlleleFromEncoded(list, n2);
                        Allele allele2 = this.getAlleleFromEncoded(list, n3);
                        objectArray[n] = list2 = Arrays.asList(allele, allele2);
                    }
                    genotypeBuilder.alleles(list2);
                }
                n = (n2 & 1) == 1 ? 1 : 0;
                genotypeBuilder.phased(n != 0);
            }
        }

        private final void generalDecode(List<Allele> list, int n, BCF2Decoder bCF2Decoder, byte by, GenotypeBuilder[] genotypeBuilderArray) throws IOException {
            BCF2Type bCF2Type = BCF2Utils.decodeType(by);
            int[] nArray = new int[n];
            for (GenotypeBuilder genotypeBuilder : genotypeBuilderArray) {
                int[] nArray2 = bCF2Decoder.decodeIntArray(n, bCF2Type, nArray);
                if (nArray2 == null) {
                    genotypeBuilder.alleles(null);
                    continue;
                }
                assert (nArray2.length > 0);
                ArrayList<Allele> arrayList = new ArrayList<Allele>(nArray2.length);
                for (int n2 : nArray2) {
                    arrayList.add(this.getAlleleFromEncoded(list, n2));
                }
                genotypeBuilder.alleles(arrayList);
                boolean bl = (nArray2[0] & 1) == 1;
                genotypeBuilder.phased(bl);
            }
        }

        private final Allele getAlleleFromEncoded(List<Allele> list, int n) {
            int n2 = n >> 1;
            return n2 == 0 ? Allele.NO_CALL : list.get(n2 - 1);
        }
    }

    public static interface Decoder {
        public void decode(List<Allele> var1, String var2, BCF2Decoder var3, byte var4, int var5, GenotypeBuilder[] var6) throws IOException;
    }
}

