/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.TabixReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TabixUtils {
    public static final String STANDARD_INDEX_EXTENSION = ".tbi";

    public static boolean less64(long l, long l2) {
        return l < l2 ^ l < 0L ^ l2 < 0L;
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(file);
            byte[] byArray = new byte[32];
            blockCompressedInputStream.read(byArray, 0, 32);
            int n = TabixReader.readInt(blockCompressedInputStream);
            byArray = new byte[n];
            blockCompressedInputStream.read(byArray);
            ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>();
            int n2 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                byte[] byArray2 = new byte[i - n2];
                System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
                arrayList.add(new SAMSequenceRecord(new String(byArray2), byArray2.length));
                n2 = i + 1;
            }
            blockCompressedInputStream.close();
            return new SAMSequenceDictionary(arrayList);
        }
        catch (Exception exception) {
            throw new TribbleException("Unable to read tabix index: " + exception.getMessage());
        }
    }

    public static class TIntv {
        public int tid;
        public int beg;
        public int end;
    }

    public static class TIndex {
        public HashMap<Integer, TPair64[]> b;
        public long[] l;
    }

    public static class TPair64
    implements Comparable<TPair64> {
        public long u;
        public long v;

        public TPair64(long l, long l2) {
            this.u = l;
            this.v = l2;
        }

        public TPair64(TPair64 tPair64) {
            this.u = tPair64.u;
            this.v = tPair64.v;
        }

        @Override
        public int compareTo(TPair64 tPair64) {
            return this.u == tPair64.u ? 0 : (this.u < tPair64.u ^ this.u < 0L ^ tPair64.u < 0L ? -1 : 1);
        }
    }
}

