/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.samtools.BinningIndexBuilder;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TabixIndexCreator
implements IndexCreator {
    private final TabixFormat formatSpec;
    private final List<BinningIndexContent> indexContents = new ArrayList<BinningIndexContent>();
    private final List<String> sequenceNames = new ArrayList<String>();
    private final Set<String> sequenceNamesSeen = new HashSet<String>();
    private final SAMSequenceDictionary sequenceDictionary;
    private String currentSequenceName = null;
    private BinningIndexBuilder indexBuilder = null;
    private TabixFeature previousFeature = null;

    public TabixIndexCreator(SAMSequenceDictionary sAMSequenceDictionary, TabixFormat tabixFormat) {
        this.sequenceDictionary = sAMSequenceDictionary;
        this.formatSpec = tabixFormat.clone();
    }

    public TabixIndexCreator(TabixFormat tabixFormat) {
        this(null, tabixFormat);
    }

    @Override
    public void addFeature(Feature feature, long l) {
        int n;
        String string = feature.getChr();
        if (string.equals(this.currentSequenceName)) {
            n = this.sequenceNames.size() - 1;
        } else {
            n = this.sequenceNames.size();
            if (this.currentSequenceName != null && this.sequenceNamesSeen.contains(string)) {
                throw new IllegalArgumentException("Sequence " + feature + " added out sequence of order");
            }
        }
        TabixFeature tabixFeature = new TabixFeature(n, feature.getStart(), feature.getEnd(), l);
        if (this.previousFeature != null) {
            if (this.previousFeature.compareTo(tabixFeature) > 0) {
                throw new IllegalArgumentException(String.format("Features added out of order: previous (%s) > next (%s)", this.previousFeature, tabixFeature));
            }
            this.finalizeFeature(l);
        }
        this.previousFeature = tabixFeature;
        if (n == this.sequenceNames.size()) {
            this.advanceToReference(string);
        }
    }

    private void finalizeFeature(long l) {
        this.previousFeature.featureEndFilePosition = l;
        if (this.previousFeature.featureStartFilePosition >= this.previousFeature.featureEndFilePosition) {
            throw new IllegalArgumentException(String.format("Feature start position %d >= feature end position %d", this.previousFeature.featureStartFilePosition, this.previousFeature.featureEndFilePosition));
        }
        this.indexBuilder.processFeature(this.previousFeature);
    }

    private void advanceToReference(String string) {
        if (this.indexBuilder != null) {
            this.indexContents.add(this.indexBuilder.generateIndexContent());
        }
        int n = this.sequenceDictionary != null ? this.sequenceDictionary.getSequence(string).getSequenceLength() : 0;
        this.indexBuilder = new BinningIndexBuilder(this.sequenceNames.size(), n);
        this.sequenceNames.add(string);
        this.currentSequenceName = string;
        this.sequenceNamesSeen.add(string);
    }

    @Override
    public Index finalizeIndex(long l) {
        if (this.previousFeature != null) {
            this.finalizeFeature(l);
        }
        if (this.indexBuilder != null) {
            this.indexContents.add(this.indexBuilder.generateIndexContent());
        }
        BinningIndexContent[] binningIndexContentArray = this.indexContents.toArray(new BinningIndexContent[this.sequenceNames.size()]);
        return new TabixIndex(this.formatSpec, this.sequenceNames, binningIndexContentArray);
    }

    private static class TabixFeature
    implements BinningIndexBuilder.FeatureToBeIndexed,
    Comparable<TabixFeature> {
        private final int referenceIndex;
        private final int start;
        private final int end;
        private final long featureStartFilePosition;
        private long featureEndFilePosition = -1L;

        private TabixFeature(int n, int n2, int n3, long l) {
            this.referenceIndex = n;
            this.start = n2;
            this.end = n3;
            this.featureStartFilePosition = l;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public Integer getIndexingBin() {
            return null;
        }

        @Override
        public Chunk getChunk() {
            if (this.featureEndFilePosition == -1L) {
                throw new IllegalStateException("End position is not set");
            }
            return new Chunk(this.featureStartFilePosition, this.featureEndFilePosition);
        }

        @Override
        public int compareTo(TabixFeature tabixFeature) {
            int n = this.referenceIndex - tabixFeature.referenceIndex;
            if (n != 0) {
                return n;
            }
            return this.start - tabixFeature.start;
        }

        public String toString() {
            return "TabixFeature{referenceIndex=" + this.referenceIndex + ", start=" + this.start + ", end=" + this.end + ", featureStartFilePosition=" + this.featureStartFilePosition + ", featureEndFilePosition=" + this.featureEndFilePosition + '}';
        }
    }
}

