/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.BinaryCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;
    public static final String EMPTY_STRING = "";

    public static <T> String join(String string, Collection<T> collection) {
        if (collection.size() == 0) {
            return EMPTY_STRING;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : collection) {
            if (bl) {
                stringBuilder.append(string);
            }
            stringBuilder.append(t.toString());
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static <T> String join(String string, T ... TArray) {
        List<T> list = Arrays.asList(TArray);
        return StringUtil.join(string, list);
    }

    public static int split(String string, String[] stringArray, char c) {
        String string2;
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(c);
        if (n4 < 0) {
            stringArray[n2++] = string;
            return n2;
        }
        while (n4 >= 0 && n2 < n) {
            stringArray[n2++] = string.substring(n3, n4);
            n3 = n4 + 1;
            n4 = string.indexOf(c, n3);
        }
        if (n2 < n && (string2 = string.substring(n3)).length() > 0) {
            stringArray[n2++] = string2;
        }
        return n2;
    }

    public static int splitConcatenateExcessTokens(String string, String[] stringArray, char c) {
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(c);
        if (n4 < 0) {
            stringArray[n2++] = string;
            return n2;
        }
        while (n4 >= 0 && n2 < n - 1) {
            stringArray[n2++] = string.substring(n3, n4);
            n3 = n4 + 1;
            n4 = string.indexOf(c, n3);
        }
        String string2 = string.substring(n3);
        if (string2.length() > 0) {
            stringArray[n2++] = string2;
        }
        return n2;
    }

    public static byte toLowerCase(byte by) {
        if (by < 65 || by > 90) {
            return by;
        }
        return (byte)(by - -32);
    }

    public static byte toUpperCase(byte by) {
        if (by < 97 || by > 122) {
            return by;
        }
        return (byte)(by + -32);
    }

    public static void toUpperCase(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < 97 || byArray[i] > 122) continue;
            byArray[i] = (byte)(byArray[i] + -32);
        }
    }

    public static String assertCharactersNotInString(String string, char ... cArray) {
        for (char c : string.toCharArray()) {
            for (char c2 : cArray) {
                if (c != c2) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + c + "'.");
            }
        }
        return string;
    }

    public static String wordWrap(String string, int n) {
        String[] stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(StringUtil.wordWrapSingleLine(string2, n));
        }
        if (string.endsWith("\n")) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String wordWrapSingleLine(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            int n4 = n2;
            for (n3 = n2; n3 < string.length() && n3 - n2 < n; ++n3) {
                if (!Character.isWhitespace(string.charAt(n3))) continue;
                n4 = n3;
            }
            if (n3 - n2 < n) {
                n4 = n3;
            }
            while (n4 < string.length() && Character.isWhitespace(string.charAt(n4))) {
                ++n4;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            if (n4 == n2) {
                n4 = n3;
            }
            stringBuilder.append(string.substring(n2, n4));
            n2 = n4;
        }
        return stringBuilder.toString();
    }

    public static String intValuesToString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length);
        if (nArray.length > 0) {
            stringBuilder.append(String.valueOf(nArray[0]));
            for (int i = 1; i < nArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(String.valueOf(nArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public static String intValuesToString(short[] sArray) {
        StringBuilder stringBuilder = new StringBuilder(sArray.length);
        if (sArray.length > 0) {
            stringBuilder.append(String.valueOf(sArray[0]));
            for (int i = 1; i < sArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(String.valueOf(sArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public static String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return StringUtil.bytesToString(byArray, 0, byArray.length);
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        return new String(byArray, 0, n, n2);
    }

    public static byte[] stringToBytes(String string) {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        return byArray;
    }

    public static byte[] stringToBytes(String string, int n, int n2) {
        byte[] byArray = new byte[n2];
        string.getBytes(n, n + n2, byArray, 0);
        return byArray;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder stringBuilder = new StringBuilder();
        byte by = binaryCodec.readByte();
        while (by != 0) {
            stringBuilder.append((char)(by & 0xFF));
            by = binaryCodec.readByte();
        }
        return stringBuilder.toString();
    }

    public static void charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            byArray[n3 + i] = (byte)cArray[n + i];
        }
    }

    public static byte charToByte(char c) {
        return (byte)c;
    }

    public static char byteToChar(byte by) {
        return (char)(by & 0xFF);
    }

    public static String bytesToHexString(byte[] byArray) {
        char[] cArray = new char[2 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            cArray[2 * i] = StringUtil.toHexDigit(by >> 4 & 0xF);
            cArray[2 * i + 1] = StringUtil.toHexDigit(by & 0xF);
        }
        return new String(cArray);
    }

    public static byte[] hexStringToBytes(String string) throws NumberFormatException {
        if (string.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(StringUtil.fromHexDigit(string.charAt(i * 2)) << 4 | StringUtil.fromHexDigit(string.charAt(i * 2 + 1)));
        }
        return byArray;
    }

    public static char toHexDigit(int n) {
        return (char)(n < 10 ? 48 + n : 65 + n - 10);
    }

    public static int fromHexDigit(char c) throws NumberFormatException {
        int n = Character.digit(c, 16);
        if (n == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c);
        }
        return n;
    }

    public static String reverseString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.reverse();
        return stringBuilder.toString();
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeatCharNTimes(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return String.valueOf(cArray);
    }

    public static String asEmptyIfNull(Object object) {
        return object == null ? EMPTY_STRING : object.toString();
    }

    public static int levenshteinDistance(String string, String string2, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int[] nArray = new int[string2.length() + 1];
        int[] nArray2 = new int[string2.length() + 1];
        int[] nArray3 = new int[string2.length() + 1];
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        for (n6 = 0; n6 < byArray2.length; ++n6) {
            nArray2[n6] = n6 * n3;
        }
        for (n5 = 0; n5 < byArray.length; ++n5) {
            nArray3[0] = (n5 + 1) * n4;
            for (n6 = 0; n6 < byArray2.length; ++n6) {
                nArray3[n6 + 1] = nArray2[n6];
                if (byArray[n5] != byArray2[n6]) {
                    int n7 = n6 + 1;
                    nArray3[n7] = nArray3[n7] + n2;
                }
                if (n5 > 0 && n6 > 0 && byArray[n5 - 1] == byArray2[n6] && byArray[n5] == byArray2[n6 - 1] && nArray3[n6 + 1] > nArray[n6 - 1] + n) {
                    nArray3[n6 + 1] = nArray[n6 - 1] + n;
                }
                if (nArray3[n6 + 1] > nArray2[n6 + 1] + n4) {
                    nArray3[n6 + 1] = nArray2[n6 + 1] + n4;
                }
                if (nArray3[n6 + 1] <= nArray3[n6] + n3) continue;
                nArray3[n6 + 1] = nArray3[n6] + n3;
            }
            int[] nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray4;
        }
        n5 = nArray2[byArray2.length];
        return n5;
    }
}

