/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.util.RuntimeIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class BlockGunzipper {
    private final Inflater inflater = new Inflater(true);
    private final CRC32 crc32 = new CRC32();
    private boolean checkCrcs = false;

    public void setCheckCrcs(boolean bl) {
        this.checkCrcs = bl;
    }

    void unzipBlock(byte[] byArray, byte[] byArray2, int n) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2, 0, n);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer.get() != 31 || byteBuffer.get() != -117 || byteBuffer.get() != 8 || byteBuffer.get() != 4) {
                throw new SAMFormatException("Invalid GZIP header");
            }
            byteBuffer.position(byteBuffer.position() + 6);
            if (byteBuffer.getShort() != 6) {
                throw new SAMFormatException("Invalid GZIP header");
            }
            byteBuffer.position(byteBuffer.position() + 4);
            int n2 = (byteBuffer.getShort() & 0xFFFF) + 1;
            if (n2 != n) {
                throw new SAMFormatException("GZIP blocksize disagreement");
            }
            int n3 = n - 18 - 8;
            byteBuffer.position(byteBuffer.position() + n3);
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            this.inflater.reset();
            this.inflater.setInput(byArray2, 18, n3);
            int n6 = this.inflater.inflate(byArray, 0, n5);
            if (n6 != n5) {
                throw new SAMFormatException("Did not inflate expected amount");
            }
            if (this.checkCrcs) {
                this.crc32.reset();
                this.crc32.update(byArray, 0, n5);
                long l = this.crc32.getValue();
                if ((int)l != n4) {
                    throw new SAMFormatException("CRC mismatch");
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeIOException(dataFormatException);
        }
    }
}

