/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.FormatUtil;
import java.lang.reflect.Field;

public class MetricBase {
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        FormatUtil formatUtil = new FormatUtil();
        for (Field field : this.getClass().getFields()) {
            try {
                Object object2 = field.get(this);
                Object object3 = field.get(object);
                if (object2 == null) {
                    if (object3 == null) continue;
                    return false;
                }
                if (formatUtil.format(object2).equals(formatUtil.format(object3))) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAMException("Could not read field " + field.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        FormatUtil formatUtil = new FormatUtil();
        for (Field field : this.getClass().getFields()) {
            try {
                Object object = field.get(this);
                object = formatUtil.format(object);
                int n2 = object != null ? object.hashCode() : 0;
                n = 31 * n + n2;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAMException("Could not read field " + field.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        FormatUtil formatUtil = new FormatUtil();
        for (Field field : this.getClass().getFields()) {
            try {
                stringBuilder.append(field.getName());
                stringBuilder.append("\t");
                stringBuilder.append(formatUtil.format(field.get(this)));
                stringBuilder.append("\n");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAMException("Could not read field " + field.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return stringBuilder.toString();
    }
}

