/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

public class FastqRecord {
    private final String seqHeaderPrefix;
    private final String seqLine;
    private final String qualHeaderPrefix;
    private final String qualLine;

    public FastqRecord(String string, String string2, String string3, String string4) {
        this.seqHeaderPrefix = string != null && string.length() > 0 ? string : null;
        this.qualHeaderPrefix = string3 != null && string3.length() > 0 ? string3 : null;
        this.seqLine = string2;
        this.qualLine = string4;
    }

    public String getReadHeader() {
        return this.seqHeaderPrefix;
    }

    public String getReadString() {
        return this.seqLine;
    }

    public String getBaseQualityHeader() {
        return this.qualHeaderPrefix;
    }

    public String getBaseQualityString() {
        return this.qualLine;
    }

    public int length() {
        return this.seqLine == null ? 0 : this.seqLine.length();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.qualHeaderPrefix == null ? 0 : this.qualHeaderPrefix.hashCode());
        n = 31 * n + (this.qualLine == null ? 0 : this.qualLine.hashCode());
        n = 31 * n + (this.seqHeaderPrefix == null ? 0 : this.seqHeaderPrefix.hashCode());
        n = 31 * n + (this.seqLine == null ? 0 : this.seqLine.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FastqRecord fastqRecord = (FastqRecord)object;
        if (this.seqLine == null ? fastqRecord.seqLine != null : !this.seqLine.equals(fastqRecord.seqLine)) {
            return false;
        }
        if (this.qualHeaderPrefix == null ? fastqRecord.qualHeaderPrefix != null : !this.qualHeaderPrefix.equals(fastqRecord.qualHeaderPrefix)) {
            return false;
        }
        if (this.qualLine == null ? fastqRecord.qualLine != null : !this.qualLine.equals(fastqRecord.qualLine)) {
            return false;
        }
        return !(this.seqHeaderPrefix == null ? fastqRecord.seqHeaderPrefix != null : !this.seqHeaderPrefix.equals(fastqRecord.seqHeaderPrefix));
    }

    public String toString() {
        return "@" + (this.seqHeaderPrefix == null ? "" : this.seqHeaderPrefix) + '\n' + (this.seqLine == null ? "" : this.seqLine) + '\n' + "+" + (this.qualHeaderPrefix == null ? "" : this.qualHeaderPrefix) + '\n' + (this.qualLine == null ? "" : this.qualLine);
    }
}

