/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.example;

import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ExampleSamUsage {
    public static SeekableStream myIndexSeekableStream() {
        throw new UnsupportedOperationException();
    }

    public void openSamExamples() throws MalformedURLException {
        SamReader samReader = SamReaderFactory.makeDefault().open(new File("/my.bam"));
        SamReader samReader2 = SamReaderFactory.make().enable(SamReaderFactory.Option.DONT_MEMORY_MAP_INDEX).validationStringency(ValidationStringency.SILENT).samRecordFactory(DefaultSAMRecordFactory.getInstance()).open(new File("/my.bam"));
        SamReader samReader3 = SamReaderFactory.makeDefault().open(SamInputResource.of(new URL("http://broadinstitute.org/my.bam")).index(ExampleSamUsage.myIndexSeekableStream()));
        SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault().enable(SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS).validationStringency(ValidationStringency.LENIENT);
        SamInputResource samInputResource = SamInputResource.of(new File("/my.bam")).index(new URL("http://broadinstitute.org/my.bam.bai"));
        SamReader samReader4 = samReaderFactory.open(samInputResource);
        for (SAMRecord sAMRecord : samReader4) {
            System.err.print(sAMRecord);
        }
    }

    public void convertReadNamesToUpperCase(File file, File file2) throws IOException {
        SamReader samReader = SamReaderFactory.makeDefault().open(file);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samReader.getFileHeader(), true, file2);
        for (SAMRecord sAMRecord : samReader) {
            sAMRecord.setReadName(sAMRecord.getReadName().toUpperCase());
            sAMFileWriter.addAlignment(sAMRecord);
        }
        sAMFileWriter.close();
        samReader.close();
    }
}

