/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import htsjdk.samtools.cram.encoding.rans.Decoding;
import htsjdk.samtools.cram.encoding.rans.Encoding;
import java.nio.ByteBuffer;
import java.util.Arrays;

class Frequencies {
    Frequencies() {
    }

    static void readStats_o0(ByteBuffer byteBuffer, Decoding.AriDecoder ariDecoder, Decoding.RansDecSymbol[] ransDecSymbolArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byteBuffer.get() & 0xFF;
        do {
            if (ariDecoder.fc[n3] == null) {
                ariDecoder.fc[n3] = new Decoding.FC();
            }
            if ((ariDecoder.fc[n3].F = byteBuffer.get() & 0xFF) >= 128) {
                ariDecoder.fc[n3].F &= 0xFFFFFF7F;
                ariDecoder.fc[n3].F = (ariDecoder.fc[n3].F & 0x7F) << 8 | byteBuffer.get() & 0xFF;
            }
            ariDecoder.fc[n3].C = n2;
            Decoding.RansDecSymbolInit(ransDecSymbolArray[n3], ariDecoder.fc[n3].C, ariDecoder.fc[n3].F);
            if (ariDecoder.R == null) {
                ariDecoder.R = new byte[4096];
            }
            Arrays.fill(ariDecoder.R, n2, n2 + ariDecoder.fc[n3].F, (byte)n3);
            n2 += ariDecoder.fc[n3].F;
            if (n == 0 && n3 + 1 == (0xFF & byteBuffer.get(byteBuffer.position()))) {
                n3 = byteBuffer.get() & 0xFF;
                n = byteBuffer.get() & 0xFF;
                continue;
            }
            if (n != 0) {
                --n;
                ++n3;
                continue;
            }
            n3 = byteBuffer.get() & 0xFF;
        } while (n3 != 0);
        assert (n2 < 4096);
    }

    static void readStats_o1(ByteBuffer byteBuffer, Decoding.AriDecoder[] ariDecoderArray, Decoding.RansDecSymbol[][] ransDecSymbolArray) {
        int n = 0;
        int n2 = 0xFF & byteBuffer.get();
        do {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0xFF & byteBuffer.get();
            if (ariDecoderArray[n2] == null) {
                ariDecoderArray[n2] = new Decoding.AriDecoder();
            }
            do {
                if (ariDecoderArray[n2].fc[n5] == null) {
                    ariDecoderArray[n2].fc[n5] = new Decoding.FC();
                }
                if ((ariDecoderArray[n2].fc[n5].F = 0xFF & byteBuffer.get()) >= 128) {
                    ariDecoderArray[n2].fc[n5].F &= 0xFFFFFF7F;
                    ariDecoderArray[n2].fc[n5].F = (ariDecoderArray[n2].fc[n5].F & 0x7F) << 8 | 0xFF & byteBuffer.get();
                }
                ariDecoderArray[n2].fc[n5].C = n4;
                if (ariDecoderArray[n2].fc[n5].F == 0) {
                    ariDecoderArray[n2].fc[n5].F = 4096;
                }
                if (ransDecSymbolArray[n2][n5] == null) {
                    ransDecSymbolArray[n2][n5] = new Decoding.RansDecSymbol();
                }
                Decoding.RansDecSymbolInit(ransDecSymbolArray[n2][n5], ariDecoderArray[n2].fc[n5].C, ariDecoderArray[n2].fc[n5].F);
                if (ariDecoderArray[n2].R == null) {
                    ariDecoderArray[n2].R = new byte[4096];
                }
                Arrays.fill(ariDecoderArray[n2].R, n4, n4 + ariDecoderArray[n2].fc[n5].F, (byte)n5);
                assert ((n4 += ariDecoderArray[n2].fc[n5].F) <= 4096);
                if (n3 == 0 && n5 + 1 == (0xFF & byteBuffer.get(byteBuffer.position()))) {
                    n5 = 0xFF & byteBuffer.get();
                    n3 = 0xFF & byteBuffer.get();
                    continue;
                }
                if (n3 != 0) {
                    --n3;
                    ++n5;
                    continue;
                }
                n5 = 0xFF & byteBuffer.get();
            } while (n5 != 0);
            if (n == 0 && n2 + 1 == (0xFF & byteBuffer.get(byteBuffer.position()))) {
                n2 = 0xFF & byteBuffer.get();
                n = 0xFF & byteBuffer.get();
                continue;
            }
            if (n != 0) {
                --n;
                ++n2;
                continue;
            }
            n2 = 0xFF & byteBuffer.get();
        } while (n2 != 0);
    }

    static int[] calcFrequencies_o0(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.remaining();
        int[] nArray = new int[256];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0xFF & byteBuffer.get();
            nArray[n4] = nArray[n4] + 1;
            ++n3;
        }
        long l = 0x80000000000L / (long)n3 + (long)(0x40000000 / n3);
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < 256; ++n) {
            if (n5 >= nArray[n]) continue;
            n5 = nArray[n];
            n6 = n;
        }
        n = 0;
        for (int i = 0; i < 256; ++i) {
            if (nArray[i] == 0) continue;
            nArray[i] = (int)((long)nArray[i] * l >> 31);
            if (nArray[i] == 0) {
                nArray[i] = 1;
            }
            n += nArray[i];
        }
        if (++n < 4096) {
            int n7 = n6;
            nArray[n7] = nArray[n7] + (4096 - n);
        } else {
            int n8 = n6;
            nArray[n8] = nArray[n8] - (n - 4096);
        }
        assert (nArray[n6] > 0);
        return nArray;
    }

    static int[][] calcFrequencies_o1(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.remaining();
        int[][] nArray = new int[256][256];
        int[] nArray2 = new int[256];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int[] nArray3 = nArray[n3];
            int n4 = 0xFF & byteBuffer.get();
            nArray3[n4] = nArray3[n4] + 1;
            int n5 = n3;
            nArray2[n5] = nArray2[n5] + 1;
            n3 = n4;
        }
        int[] nArray4 = nArray[0];
        int n6 = 0xFF & byteBuffer.get(n2 >> 2);
        nArray4[n6] = nArray4[n6] + 1;
        int[] nArray5 = nArray[0];
        int n7 = 0xFF & byteBuffer.get(2 * (n2 >> 2));
        nArray5[n7] = nArray5[n7] + 1;
        int[] nArray6 = nArray[0];
        int n8 = 0xFF & byteBuffer.get(3 * (n2 >> 2));
        nArray6[n8] = nArray6[n8] + 1;
        nArray2[0] = nArray2[0] + 3;
        for (n = 0; n < 256; ++n) {
            if (nArray2[n] == 0) continue;
            double d = 4096.0 / (double)nArray2[n];
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (int i = 0; i < 256; ++i) {
                if (nArray[n][i] == 0) continue;
                if (n10 < nArray[n][i]) {
                    n10 = nArray[n][i];
                    n11 = i;
                }
                int[] nArray7 = nArray[n];
                int n12 = i;
                nArray7[n12] = (int)((double)nArray7[n12] * d);
                if (nArray7[n12] == 0) {
                    nArray[n][i] = 1;
                }
                n9 += nArray[n][i];
            }
            if (++n9 < 4096) {
                int[] nArray8 = nArray[n];
                int n13 = n11;
                nArray8[n13] = nArray8[n13] + (4096 - n9);
                continue;
            }
            int[] nArray9 = nArray[n];
            int n14 = n11;
            nArray9[n14] = nArray9[n14] - (n9 - 4096);
        }
        return nArray;
    }

    static Encoding.RansEncSymbol[] buildSyms_o0(int[] nArray) {
        int n;
        int[] nArray2 = new int[256];
        Encoding.RansEncSymbol[] ransEncSymbolArray = new Encoding.RansEncSymbol[256];
        for (n = 0; n < ransEncSymbolArray.length; ++n) {
            ransEncSymbolArray[n] = new Encoding.RansEncSymbol();
        }
        n = 0;
        for (int i = 0; i < 256; ++i) {
            nArray2[i] = n;
            n += nArray[i];
            if (nArray[i] == 0) continue;
            Encoding.RansEncSymbolInit(ransEncSymbolArray[i], nArray2[i], nArray[i], 12);
        }
        return ransEncSymbolArray;
    }

    static int writeFrequencies_o0(ByteBuffer byteBuffer, int[] nArray) {
        int n = byteBuffer.position();
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (nArray[i] == 0) continue;
            if (n2 != 0) {
                --n2;
            } else {
                byteBuffer.put((byte)i);
                if (n2 == 0 && i != 0 && nArray[i - 1] != 0) {
                    for (n2 = i + 1; n2 < 256 && nArray[n2] != 0; ++n2) {
                    }
                    byteBuffer.put((byte)(n2 -= i + 1));
                }
            }
            if (nArray[i] < 128) {
                byteBuffer.put((byte)nArray[i]);
                continue;
            }
            byteBuffer.put((byte)(0x80 | nArray[i] >> 8));
            byteBuffer.put((byte)(nArray[i] & 0xFF));
        }
        byteBuffer.put((byte)0);
        return byteBuffer.position() - n;
    }

    static Encoding.RansEncSymbol[][] buildSyms_o1(int[][] nArray) {
        int n;
        Encoding.RansEncSymbol[][] ransEncSymbolArray = new Encoding.RansEncSymbol[256][256];
        for (n = 0; n < ransEncSymbolArray.length; ++n) {
            for (int i = 0; i < ransEncSymbolArray[n].length; ++i) {
                ransEncSymbolArray[n][i] = new Encoding.RansEncSymbol();
            }
        }
        for (n = 0; n < 256; ++n) {
            int[] nArray2 = nArray[n];
            int n2 = 0;
            for (int i = 0; i < 256; ++i) {
                if (nArray2[i] == 0) continue;
                Encoding.RansEncSymbolInit(ransEncSymbolArray[n][i], n2, nArray2[i], 12);
                n2 += nArray2[i];
            }
        }
        return ransEncSymbolArray;
    }

    static int writeFrequencies_o1(ByteBuffer byteBuffer, int[][] nArray) {
        int n;
        int n2;
        int n3 = byteBuffer.position();
        int[] nArray2 = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + nArray[n2][n];
            }
        }
        n2 = 0;
        for (n = 0; n < 256; ++n) {
            if (nArray2[n] == 0) continue;
            if (n2 != 0) {
                --n2;
            } else {
                byteBuffer.put((byte)n);
                if (n != 0 && nArray2[n - 1] != 0) {
                    for (n2 = n + 1; n2 < 256 && nArray2[n2] != 0; ++n2) {
                    }
                    byteBuffer.put((byte)(n2 -= n + 1));
                }
            }
            int[] nArray3 = nArray[n];
            int n5 = 0;
            for (int i = 0; i < 256; ++i) {
                if (nArray3[i] == 0) continue;
                if (n5 != 0) {
                    --n5;
                } else {
                    byteBuffer.put((byte)i);
                    if (n5 == 0 && i != 0 && nArray3[i - 1] != 0) {
                        for (n5 = i + 1; n5 < 256 && nArray3[n5] != 0; ++n5) {
                        }
                        byteBuffer.put((byte)(n5 -= i + 1));
                    }
                }
                if (nArray3[i] < 128) {
                    byteBuffer.put((byte)nArray3[i]);
                    continue;
                }
                byteBuffer.put((byte)(0x80 | nArray3[i] >> 8));
                byteBuffer.put((byte)(nArray3[i] & 0xFF));
            }
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)0);
        return byteBuffer.position() - n3;
    }
}

