/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Cram2SamRecordFactory {
    private final SAMFileHeader header;

    public Cram2SamRecordFactory(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
    }

    public SAMRecord create(CramCompressionRecord cramCompressionRecord) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        sAMRecord.setReadName(cramCompressionRecord.readName);
        Cram2SamRecordFactory.copyFlags(cramCompressionRecord, sAMRecord);
        if (cramCompressionRecord.sequenceId == -1) {
            sAMRecord.setAlignmentStart(0);
            sAMRecord.setMappingQuality(0);
            sAMRecord.setReferenceIndex(-1);
        } else {
            sAMRecord.setReferenceIndex(cramCompressionRecord.sequenceId);
            sAMRecord.setAlignmentStart(cramCompressionRecord.alignmentStart);
            sAMRecord.setMappingQuality(cramCompressionRecord.mappingQuality);
        }
        if (cramCompressionRecord.isSegmentUnmapped()) {
            sAMRecord.setCigarString("*");
        } else {
            sAMRecord.setCigar(Cram2SamRecordFactory.getCigar2(cramCompressionRecord.readFeatures, cramCompressionRecord.readLength));
        }
        if (sAMRecord.getReadPairedFlag()) {
            sAMRecord.setMateReferenceIndex(cramCompressionRecord.mateSequenceID);
            sAMRecord.setMateAlignmentStart(cramCompressionRecord.mateAlignmentStart > 0 ? cramCompressionRecord.mateAlignmentStart : 0);
            sAMRecord.setMateNegativeStrandFlag(cramCompressionRecord.isMateNegativeStrand());
            sAMRecord.setMateUnmappedFlag(cramCompressionRecord.isMateUnmapped());
        } else {
            sAMRecord.setMateReferenceIndex(-1);
            sAMRecord.setMateAlignmentStart(0);
        }
        sAMRecord.setInferredInsertSize(cramCompressionRecord.templateSize);
        sAMRecord.setReadBases(cramCompressionRecord.readBases);
        sAMRecord.setBaseQualities(cramCompressionRecord.qualityScores);
        if (cramCompressionRecord.tags != null) {
            for (ReadTag readTag : cramCompressionRecord.tags) {
                sAMRecord.setAttribute(readTag.getKey(), readTag.getValue());
            }
        }
        if (cramCompressionRecord.readGroupID > -1) {
            SAMReadGroupRecord sAMReadGroupRecord = this.header.getReadGroups().get(cramCompressionRecord.readGroupID);
            sAMRecord.setAttribute("RG", (Object)sAMReadGroupRecord.getId());
        }
        return sAMRecord;
    }

    private static void copyFlags(CramCompressionRecord cramCompressionRecord, SAMRecord sAMRecord) {
        sAMRecord.setReadPairedFlag(cramCompressionRecord.isMultiFragment());
        sAMRecord.setProperPairFlag(cramCompressionRecord.isProperPair());
        sAMRecord.setReadUnmappedFlag(cramCompressionRecord.isSegmentUnmapped());
        sAMRecord.setReadNegativeStrandFlag(cramCompressionRecord.isNegativeStrand());
        sAMRecord.setFirstOfPairFlag(cramCompressionRecord.isFirstSegment());
        sAMRecord.setSecondOfPairFlag(cramCompressionRecord.isLastSegment());
        sAMRecord.setNotPrimaryAlignmentFlag(cramCompressionRecord.isSecondaryAlignment());
        sAMRecord.setReadFailsVendorQualityCheckFlag(cramCompressionRecord.isVendorFiltered());
        sAMRecord.setDuplicateReadFlag(cramCompressionRecord.isDuplicate());
        sAMRecord.setSupplementaryAlignmentFlag(cramCompressionRecord.isSupplementary());
    }

    private static Cigar getCigar2(Collection<ReadFeature> collection, int n) {
        CigarElement cigarElement;
        if (collection == null || collection.isEmpty()) {
            CigarElement cigarElement2 = new CigarElement(n, CigarOperator.M);
            return new Cigar(Collections.singletonList(cigarElement2));
        }
        ArrayList<CigarElement> arrayList = new ArrayList<CigarElement>();
        int n2 = 1;
        CigarOperator cigarOperator = CigarOperator.MATCH_OR_MISMATCH;
        int n3 = 0;
        int n4 = 1;
        block10: for (ReadFeature readFeature : collection) {
            int n5;
            CigarOperator cigarOperator2;
            int n6 = readFeature.getPosition() - (n4 + n3);
            if (n6 > 0) {
                if (cigarOperator != CigarOperator.MATCH_OR_MISMATCH) {
                    arrayList.add(new CigarElement(n3, cigarOperator));
                    n4 += n3;
                    n2 += n3;
                    n3 = n6;
                } else {
                    n3 += n6;
                }
                cigarOperator = CigarOperator.MATCH_OR_MISMATCH;
            }
            switch (readFeature.getOperator()) {
                case 73: {
                    cigarOperator2 = CigarOperator.INSERTION;
                    n5 = ((Insertion)readFeature).getSequence().length;
                    break;
                }
                case 83: {
                    cigarOperator2 = CigarOperator.SOFT_CLIP;
                    n5 = ((SoftClip)readFeature).getSequence().length;
                    break;
                }
                case 72: {
                    cigarOperator2 = CigarOperator.HARD_CLIP;
                    n5 = ((HardClip)readFeature).getLength();
                    break;
                }
                case 105: {
                    cigarOperator2 = CigarOperator.INSERTION;
                    n5 = 1;
                    break;
                }
                case 68: {
                    cigarOperator2 = CigarOperator.DELETION;
                    n5 = ((Deletion)readFeature).getLength();
                    break;
                }
                case 78: {
                    cigarOperator2 = CigarOperator.SKIPPED_REGION;
                    n5 = ((RefSkip)readFeature).getLength();
                    break;
                }
                case 80: {
                    cigarOperator2 = CigarOperator.PADDING;
                    n5 = ((Padding)readFeature).getLength();
                    break;
                }
                case 66: 
                case 88: {
                    cigarOperator2 = CigarOperator.MATCH_OR_MISMATCH;
                    n5 = 1;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            if (cigarOperator != cigarOperator2) {
                if (n3 > 0) {
                    arrayList.add(new CigarElement(n3, cigarOperator));
                    n2 += n3;
                }
                cigarOperator = cigarOperator2;
                n3 = n5;
                n4 = readFeature.getPosition();
            } else {
                n3 += n5;
            }
            if (cigarOperator2.consumesReadBases()) continue;
            n4 -= n5;
        }
        if (cigarOperator != null) {
            if (cigarOperator != CigarOperator.M) {
                arrayList.add(new CigarElement(n3, cigarOperator));
                if (n >= n4 + n3) {
                    cigarElement = new CigarElement(n - (n3 + n4) + 1, CigarOperator.M);
                    arrayList.add(cigarElement);
                }
            } else if (n == 0 || n > n4 - 1) {
                cigarElement = n == 0 ? new CigarElement(n3, CigarOperator.M) : new CigarElement(n - n4 + 1, CigarOperator.M);
                arrayList.add(cigarElement);
            }
        }
        if (arrayList.isEmpty()) {
            cigarElement = new CigarElement(n, CigarOperator.M);
            return new Cigar(Collections.singletonList(cigarElement));
        }
        return new Cigar(arrayList);
    }
}

