/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableMemoryStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class CRAIIndex {
    public static final String CRAI_INDEX_SUFFIX = ".crai";

    public static void writeIndex(OutputStream outputStream, List<CRAIEntry> list) throws IOException {
        for (CRAIEntry cRAIEntry : list) {
            outputStream.write(cRAIEntry.toString().getBytes());
            outputStream.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CRAIEntry> readIndex(InputStream inputStream) throws CRAIIndexException {
        LinkedList<CRAIEntry> linkedList = new LinkedList<CRAIEntry>();
        Scanner scanner = new Scanner(inputStream);
        try {
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                CRAIEntry cRAIEntry = CRAIEntry.fromCraiLine(string);
                linkedList.add(cRAIEntry);
            }
        }
        finally {
            scanner.close();
        }
        return linkedList;
    }

    public static List<CRAIEntry> find(List<CRAIEntry> list, int n, int n2, int n3) {
        boolean bl = n2 < 1 || n3 < 1;
        CRAIEntry cRAIEntry = new CRAIEntry();
        cRAIEntry.sequenceId = n;
        cRAIEntry.alignmentStart = n2 < 1 ? 1 : n2;
        cRAIEntry.alignmentSpan = n3 < 1 ? Integer.MAX_VALUE : n3;
        cRAIEntry.containerStartOffset = Long.MAX_VALUE;
        cRAIEntry.sliceOffset = Integer.MAX_VALUE;
        cRAIEntry.sliceSize = Integer.MAX_VALUE;
        ArrayList<CRAIEntry> arrayList = new ArrayList<CRAIEntry>();
        for (CRAIEntry cRAIEntry2 : list) {
            if (cRAIEntry2.sequenceId != n || !bl && !CRAIEntry.intersect(cRAIEntry2, cRAIEntry)) continue;
            arrayList.add(cRAIEntry2);
        }
        Collections.sort(arrayList, CRAIEntry.byStart);
        return arrayList;
    }

    public static CRAIEntry getLeftmost(List<CRAIEntry> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        CRAIEntry cRAIEntry = list.get(0);
        for (CRAIEntry cRAIEntry2 : list) {
            if (cRAIEntry2.alignmentStart >= cRAIEntry.alignmentStart) continue;
            cRAIEntry = cRAIEntry2;
        }
        return cRAIEntry;
    }

    public static int findLastAlignedEntry(List<CRAIEntry> list) {
        if (list.isEmpty()) {
            return -1;
        }
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            CRAIEntry cRAIEntry = list.get(n3);
            if (cRAIEntry.sequenceId >= 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        if (n >= list.size()) {
            return list.size() - 1;
        }
        while (n >= 0 && list.get((int)n).sequenceId == -1) {
            --n;
        }
        return n;
    }

    public static SeekableStream openCraiFileAsBaiStream(File file, SAMSequenceDictionary sAMSequenceDictionary) throws IOException {
        return CRAIIndex.openCraiFileAsBaiStream(new FileInputStream(file), sAMSequenceDictionary);
    }

    public static SeekableStream openCraiFileAsBaiStream(InputStream inputStream, SAMSequenceDictionary sAMSequenceDictionary) throws IOException, CRAIIndexException {
        List<CRAIEntry> list = CRAIIndex.readIndex(new GZIPInputStream(inputStream));
        Collections.sort(list);
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CRAMIndexer cRAMIndexer = new CRAMIndexer(byteArrayOutputStream, sAMFileHeader);
        for (CRAIEntry cRAIEntry : list) {
            Slice slice = new Slice();
            slice.containerOffset = cRAIEntry.containerStartOffset;
            slice.alignmentStart = cRAIEntry.alignmentStart;
            slice.alignmentSpan = cRAIEntry.alignmentSpan;
            slice.sequenceId = cRAIEntry.sequenceId;
            slice.nofRecords = cRAIEntry.sliceSize;
            slice.index = cRAIEntry.sliceIndex;
            slice.offset = cRAIEntry.sliceOffset;
            cRAMIndexer.processAlignment(slice);
        }
        cRAMIndexer.finish();
        return new SeekableMemoryStream(byteArrayOutputStream.toByteArray(), null);
    }

    public static class CRAIIndexException
    extends RuntimeException {
        public CRAIIndexException(String string) {
            super(string);
        }

        public CRAIIndexException(NumberFormatException numberFormatException) {
            super(numberFormatException);
        }
    }
}

