/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SAMRecord
implements Cloneable,
Locatable,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final int UNKNOWN_MAPPING_QUALITY = 255;
    public static final int NO_MAPPING_QUALITY = 0;
    public static final String NO_ALIGNMENT_REFERENCE_NAME = "*";
    public static final int NO_ALIGNMENT_REFERENCE_INDEX = -1;
    public static final String NO_ALIGNMENT_CIGAR = "*";
    public static final int NO_ALIGNMENT_START = 0;
    public static final byte[] NULL_SEQUENCE = new byte[0];
    public static final String NULL_SEQUENCE_STRING = "*";
    public static final byte[] NULL_QUALS = new byte[0];
    public static final String NULL_QUALS_STRING = "*";
    public static final int MAX_INSERT_SIZE = 0x20000000;
    private String mReadName = null;
    private byte[] mReadBases = NULL_SEQUENCE;
    private byte[] mBaseQualities = NULL_QUALS;
    private String mReferenceName = "*";
    private int mAlignmentStart = 0;
    private transient int mAlignmentEnd = 0;
    private int mMappingQuality = 0;
    private String mCigarString = "*";
    private Cigar mCigar = null;
    private List<AlignmentBlock> mAlignmentBlocks = null;
    private int mFlags = 0;
    private String mMateReferenceName = "*";
    private int mMateAlignmentStart = 0;
    private int mInferredInsertSize = 0;
    private SAMBinaryTagAndValue mAttributes = null;
    protected Integer mReferenceIndex = null;
    protected Integer mMateReferenceIndex = null;
    private Integer mIndexingBin = null;
    private ValidationStringency mValidationStringency = ValidationStringency.SILENT;
    private transient SAMFileSource mFileSource;
    private SAMFileHeader mHeader = null;
    private transient Map<Object, Object> transientAttributes;

    public SAMRecord(SAMFileHeader sAMFileHeader) {
        this.mHeader = sAMFileHeader;
    }

    public String getReadName() {
        return this.mReadName;
    }

    public int getReadNameLength() {
        return this.mReadName.length();
    }

    public void setReadName(String string) {
        this.mReadName = string;
    }

    public String getReadString() {
        byte[] byArray = this.getReadBases();
        if (byArray.length == 0) {
            return "*";
        }
        return StringUtil.bytesToString(byArray);
    }

    public void setReadString(String string) {
        if ("*".equals(string)) {
            this.mReadBases = NULL_SEQUENCE;
        } else {
            byte[] byArray = StringUtil.stringToBytes(string);
            SAMUtils.normalizeBases(byArray);
            this.setReadBases(byArray);
        }
    }

    public byte[] getReadBases() {
        return this.mReadBases;
    }

    public void setReadBases(byte[] byArray) {
        this.mReadBases = byArray;
    }

    public int getReadLength() {
        return this.getReadBases().length;
    }

    public String getBaseQualityString() {
        if (Arrays.equals(NULL_QUALS, this.getBaseQualities())) {
            return "*";
        }
        return SAMUtils.phredToFastq(this.getBaseQualities());
    }

    public void setBaseQualityString(String string) {
        if ("*".equals(string)) {
            this.setBaseQualities(NULL_QUALS);
        } else {
            this.setBaseQualities(SAMUtils.fastqToPhred(string));
        }
    }

    public byte[] getBaseQualities() {
        return this.mBaseQualities;
    }

    public void setBaseQualities(byte[] byArray) {
        this.mBaseQualities = byArray;
    }

    public byte[] getOriginalBaseQualities() {
        String string = (String)this.getAttribute("OQ");
        if (string != null && string.length() > 0) {
            return SAMUtils.fastqToPhred(string);
        }
        return null;
    }

    public void setOriginalBaseQualities(byte[] byArray) {
        this.setAttribute("OQ", (Object)SAMUtils.phredToFastq(byArray));
    }

    private static boolean hasReferenceName(Integer n, String string) {
        return n != null && n != -1 || !"*".equals(string);
    }

    private boolean hasReferenceName() {
        return SAMRecord.hasReferenceName(this.mReferenceIndex, this.mReferenceName);
    }

    private boolean hasMateReferenceName() {
        return SAMRecord.hasReferenceName(this.mMateReferenceIndex, this.mMateReferenceName);
    }

    public String getReferenceName() {
        return this.mReferenceName;
    }

    public void setReferenceName(String string) {
        int n;
        if ("*".equals(string)) {
            this.mReferenceName = "*";
            this.mReferenceIndex = -1;
            return;
        }
        if (this.mHeader != null && (n = this.mHeader.getSequenceIndex(string)) != -1) {
            this.setReferenceIndex(n);
            return;
        }
        this.mReferenceName = string.intern();
        this.mReferenceIndex = null;
    }

    public Integer getReferenceIndex() {
        if (this.mReferenceIndex == null) {
            this.mReferenceIndex = this.mReferenceName == null ? Integer.valueOf(-1) : ("*".equals(this.mReferenceName) ? Integer.valueOf(-1) : Integer.valueOf(this.mHeader.getSequenceIndex(this.mReferenceName)));
        }
        return this.mReferenceIndex;
    }

    public void setReferenceIndex(int n) {
        this.mReferenceIndex = n;
        if (this.mReferenceIndex == -1) {
            this.mReferenceName = "*";
        } else {
            try {
                this.mReferenceName = this.mHeader.getSequence(n).getSequenceName();
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("Reference index " + n + " not found in sequence dictionary.", nullPointerException);
            }
        }
    }

    public String getMateReferenceName() {
        return this.mMateReferenceName;
    }

    public void setMateReferenceName(String string) {
        int n;
        if ("*".equals(string)) {
            this.mMateReferenceName = "*";
            this.mMateReferenceIndex = -1;
            return;
        }
        if (this.mHeader != null && (n = this.mHeader.getSequenceIndex(string)) != -1) {
            this.setMateReferenceIndex(n);
            return;
        }
        this.mMateReferenceName = string.intern();
        this.mMateReferenceIndex = null;
    }

    public Integer getMateReferenceIndex() {
        if (this.mMateReferenceIndex == null) {
            this.mMateReferenceIndex = this.mMateReferenceName == null ? Integer.valueOf(-1) : ("*".equals(this.mMateReferenceName) ? Integer.valueOf(-1) : Integer.valueOf(this.mHeader.getSequenceIndex(this.mMateReferenceName)));
        }
        return this.mMateReferenceIndex;
    }

    public void setMateReferenceIndex(int n) {
        this.mMateReferenceIndex = n;
        if (this.mMateReferenceIndex == -1) {
            this.mMateReferenceName = "*";
        } else {
            try {
                this.mMateReferenceName = this.mHeader.getSequence(n).getSequenceName();
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("Reference index " + n + " not found in sequence dictionary.", nullPointerException);
            }
        }
    }

    public int getAlignmentStart() {
        return this.mAlignmentStart;
    }

    public void setAlignmentStart(int n) {
        this.mAlignmentStart = n;
        this.mAlignmentEnd = 0;
        this.setIndexingBin(null);
    }

    public int getAlignmentEnd() {
        if (this.getReadUnmappedFlag()) {
            return 0;
        }
        if (this.mAlignmentEnd == 0) {
            this.mAlignmentEnd = this.mAlignmentStart + this.getCigar().getReferenceLength() - 1;
        }
        return this.mAlignmentEnd;
    }

    public int getUnclippedStart() {
        return SAMUtils.getUnclippedStart(this.getAlignmentStart(), this.getCigar());
    }

    public int getUnclippedEnd() {
        return SAMUtils.getUnclippedEnd(this.getAlignmentEnd(), this.getCigar());
    }

    public int getReferencePositionAtReadPosition(int n) {
        return SAMRecord.getReferencePositionAtReadPosition(this, n);
    }

    public static int getReferencePositionAtReadPosition(SAMRecord sAMRecord, int n) {
        if (n == 0) {
            return 0;
        }
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            if (CoordMath.getEnd(alignmentBlock.getReadStart(), alignmentBlock.getLength()) < n) continue;
            if (n < alignmentBlock.getReadStart()) {
                return 0;
            }
            return alignmentBlock.getReferenceStart() + n - alignmentBlock.getReadStart();
        }
        return 0;
    }

    public int getReadPositionAtReferencePosition(int n) {
        return SAMRecord.getReadPositionAtReferencePosition(this, n, false);
    }

    public int getReadPositionAtReferencePosition(int n, boolean bl) {
        return SAMRecord.getReadPositionAtReferencePosition(this, n, bl);
    }

    public static int getReadPositionAtReferencePosition(SAMRecord sAMRecord, int n, boolean bl) {
        if (n <= 0) {
            return 0;
        }
        int n2 = 0;
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            if (CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength()) >= n) {
                if (n < alignmentBlock.getReferenceStart()) {
                    return bl ? n2 : 0;
                }
                return n - alignmentBlock.getReferenceStart() + alignmentBlock.getReadStart();
            }
            n2 = alignmentBlock.getReadStart() + alignmentBlock.getLength() - 1;
        }
        return 0;
    }

    public int getMateAlignmentStart() {
        return this.mMateAlignmentStart;
    }

    public void setMateAlignmentStart(int n) {
        this.mMateAlignmentStart = n;
    }

    public int getInferredInsertSize() {
        return this.mInferredInsertSize;
    }

    public void setInferredInsertSize(int n) {
        this.mInferredInsertSize = n;
    }

    public int getMappingQuality() {
        return this.mMappingQuality;
    }

    public void setMappingQuality(int n) {
        this.mMappingQuality = n;
    }

    public String getCigarString() {
        if (this.mCigarString == null && this.getCigar() != null) {
            this.mCigarString = TextCigarCodec.encode(this.getCigar());
        }
        return this.mCigarString;
    }

    public void setCigarString(String string) {
        this.mCigarString = string;
        this.mCigar = null;
        this.mAlignmentBlocks = null;
        this.mAlignmentEnd = 0;
        this.setIndexingBin(null);
    }

    public Cigar getCigar() {
        if (this.mCigar == null && this.mCigarString != null) {
            this.mCigar = TextCigarCodec.decode(this.mCigarString);
            if (this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
                SAMUtils.processValidationErrors(this.validateCigar(-1L), -1L, this.getValidationStringency());
            }
        }
        return this.mCigar;
    }

    public int getCigarLength() {
        return this.getCigar().numCigarElements();
    }

    public void setCigar(Cigar cigar) {
        this.initializeCigar(cigar);
        this.setIndexingBin(null);
    }

    protected void initializeCigar(Cigar cigar) {
        this.mCigar = cigar;
        this.mCigarString = null;
        this.mAlignmentBlocks = null;
        this.mAlignmentEnd = 0;
    }

    public SAMReadGroupRecord getReadGroup() {
        String string = (String)this.getAttribute(SAMTagUtil.getSingleton().RG);
        if (string == null) {
            return null;
        }
        return this.getHeader().getReadGroup(string);
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int n) {
        this.mFlags = n;
        this.setIndexingBin(null);
    }

    public boolean getReadPairedFlag() {
        return (this.mFlags & SAMFlag.READ_PAIRED.flag) != 0;
    }

    private void requireReadPaired() {
        if (!this.getReadPairedFlag()) {
            throw new IllegalStateException("Inappropriate call if not paired read");
        }
    }

    public boolean getProperPairFlag() {
        this.requireReadPaired();
        return this.getProperPairFlagUnchecked();
    }

    private boolean getProperPairFlagUnchecked() {
        return (this.mFlags & SAMFlag.PROPER_PAIR.flag) != 0;
    }

    public boolean getReadUnmappedFlag() {
        return (this.mFlags & SAMFlag.READ_UNMAPPED.flag) != 0;
    }

    public boolean getMateUnmappedFlag() {
        this.requireReadPaired();
        return this.getMateUnmappedFlagUnchecked();
    }

    private boolean getMateUnmappedFlagUnchecked() {
        return (this.mFlags & SAMFlag.MATE_UNMAPPED.flag) != 0;
    }

    public boolean getReadNegativeStrandFlag() {
        return (this.mFlags & SAMFlag.READ_REVERSE_STRAND.flag) != 0;
    }

    public boolean getMateNegativeStrandFlag() {
        this.requireReadPaired();
        return this.getMateNegativeStrandFlagUnchecked();
    }

    private boolean getMateNegativeStrandFlagUnchecked() {
        return (this.mFlags & SAMFlag.MATE_REVERSE_STRAND.flag) != 0;
    }

    public boolean getFirstOfPairFlag() {
        this.requireReadPaired();
        return this.getFirstOfPairFlagUnchecked();
    }

    private boolean getFirstOfPairFlagUnchecked() {
        return (this.mFlags & SAMFlag.FIRST_OF_PAIR.flag) != 0;
    }

    public boolean getSecondOfPairFlag() {
        this.requireReadPaired();
        return this.getSecondOfPairFlagUnchecked();
    }

    private boolean getSecondOfPairFlagUnchecked() {
        return (this.mFlags & SAMFlag.SECOND_OF_PAIR.flag) != 0;
    }

    public boolean getNotPrimaryAlignmentFlag() {
        return (this.mFlags & SAMFlag.NOT_PRIMARY_ALIGNMENT.flag) != 0;
    }

    public boolean getSupplementaryAlignmentFlag() {
        return (this.mFlags & SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag) != 0;
    }

    public boolean getReadFailsVendorQualityCheckFlag() {
        return (this.mFlags & SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.flag) != 0;
    }

    public boolean getDuplicateReadFlag() {
        return (this.mFlags & SAMFlag.DUPLICATE_READ.flag) != 0;
    }

    public void setReadPairedFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.READ_PAIRED.flag);
    }

    public void setProperPairFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.PROPER_PAIR.flag);
    }

    public void setReadUmappedFlag(boolean bl) {
        this.setReadUnmappedFlag(bl);
    }

    public void setReadUnmappedFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.READ_UNMAPPED.flag);
        this.setIndexingBin(null);
    }

    public void setMateUnmappedFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.MATE_UNMAPPED.flag);
    }

    public void setReadNegativeStrandFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.READ_REVERSE_STRAND.flag);
    }

    public void setMateNegativeStrandFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.MATE_REVERSE_STRAND.flag);
    }

    public void setFirstOfPairFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.FIRST_OF_PAIR.flag);
    }

    public void setSecondOfPairFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.SECOND_OF_PAIR.flag);
    }

    public void setNotPrimaryAlignmentFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.NOT_PRIMARY_ALIGNMENT.flag);
    }

    public void setSupplementaryAlignmentFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag);
    }

    public void setReadFailsVendorQualityCheckFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.flag);
    }

    public void setDuplicateReadFlag(boolean bl) {
        this.setFlag(bl, SAMFlag.DUPLICATE_READ.flag);
    }

    public boolean isSecondaryOrSupplementary() {
        return this.getNotPrimaryAlignmentFlag() || this.getSupplementaryAlignmentFlag();
    }

    private void setFlag(boolean bl, int n) {
        this.mFlags = bl ? (this.mFlags |= n) : (this.mFlags &= ~n);
    }

    public ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(SAMTagUtil.getSingleton().makeBinaryTag(string));
    }

    public Integer getIntegerAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (!(object instanceof Number)) {
            throw new RuntimeException("Value for tag " + string + " is not Number: " + object.getClass());
        }
        long l = ((Number)object).longValue();
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new RuntimeException("Value for tag " + string + " is not in Integer range: " + l);
        }
        return (int)l;
    }

    public Long getUnsignedIntegerAttribute(String string) throws SAMException {
        return this.getUnsignedIntegerAttribute(SAMTagUtil.getSingleton().makeBinaryTag(string));
    }

    public Long getUnsignedIntegerAttribute(short s) throws SAMException {
        Object object = this.getAttribute(s);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (SAMUtils.isValidUnsignedIntegerAttribute(l)) {
                return l;
            }
            throw new SAMException("Unsigned integer value of tag " + SAMTagUtil.getSingleton().makeStringTag(s) + " is out of bounds for a 32-bit unsigned integer: " + l);
        }
        throw new SAMException("Unexpected attribute value data type " + object.getClass() + " for tag " + SAMTagUtil.getSingleton().makeStringTag(s));
    }

    public Short getShortAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (!(object instanceof Number)) {
            throw new RuntimeException("Value for tag " + string + " is not Number: " + object.getClass());
        }
        long l = ((Number)object).longValue();
        if (l < -32768L || l > 32767L) {
            throw new RuntimeException("Value for tag " + string + " is not in Short range: " + l);
        }
        return (short)l;
    }

    public Byte getByteAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (!(object instanceof Number)) {
            throw new RuntimeException("Value for tag " + string + " is not Number: " + object.getClass());
        }
        long l = ((Number)object).longValue();
        if (l < -128L || l > 127L) {
            throw new RuntimeException("Value for tag " + string + " is not in Short range: " + l);
        }
        return (byte)l;
    }

    public String getStringAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new SAMException("Value for tag " + string + " is not a String: " + object.getClass());
    }

    public Character getCharacterAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        throw new SAMException("Value for tag " + string + " is not a Character: " + object.getClass());
    }

    public Float getFloatAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        throw new SAMException("Value for tag " + string + " is not a Float: " + object.getClass());
    }

    public byte[] getByteArrayAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new SAMException("Value for tag " + string + " is not a byte[]: " + object.getClass());
    }

    public byte[] getUnsignedByteArrayAttribute(String string) {
        byte[] byArray = this.getByteArrayAttribute(string);
        if (byArray != null) {
            this.requireUnsigned(string);
        }
        return byArray;
    }

    public byte[] getSignedByteArrayAttribute(String string) {
        byte[] byArray = this.getByteArrayAttribute(string);
        if (byArray != null) {
            this.requireSigned(string);
        }
        return byArray;
    }

    public short[] getUnsignedShortArrayAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof short[]) {
            this.requireUnsigned(string);
            return (short[])object;
        }
        throw new SAMException("Value for tag " + string + " is not a short[]: " + object.getClass());
    }

    public short[] getSignedShortArrayAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof short[]) {
            this.requireSigned(string);
            return (short[])object;
        }
        throw new SAMException("Value for tag " + string + " is not a short[]: " + object.getClass());
    }

    public int[] getUnsignedIntArrayAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof int[]) {
            this.requireUnsigned(string);
            return (int[])object;
        }
        throw new SAMException("Value for tag " + string + " is not a int[]: " + object.getClass());
    }

    public int[] getSignedIntArrayAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof int[]) {
            this.requireSigned(string);
            return (int[])object;
        }
        throw new SAMException("Value for tag " + string + " is not a int[]: " + object.getClass());
    }

    public float[] getFloatArrayAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object != null && !(object instanceof float[])) {
            throw new SAMException("Value for tag " + string + " is not a float[]: " + object.getClass());
        }
        return (float[])object;
    }

    public boolean isUnsignedArrayAttribute(String string) {
        SAMBinaryTagAndValue sAMBinaryTagAndValue = this.mAttributes.find(SAMTagUtil.getSingleton().makeBinaryTag(string));
        if (sAMBinaryTagAndValue != null) {
            return sAMBinaryTagAndValue.isUnsignedArray();
        }
        throw new SAMException("Tag " + string + " is not present in this SAMRecord");
    }

    private void requireSigned(String string) {
        if (this.isUnsignedArrayAttribute(string)) {
            throw new SAMException("Value for tag " + string + " is not signed");
        }
    }

    private void requireUnsigned(String string) {
        if (!this.isUnsignedArrayAttribute(string)) {
            throw new SAMException("Value for tag " + string + " is not unsigned");
        }
    }

    public Object getAttribute(short s) {
        if (this.mAttributes == null) {
            return null;
        }
        SAMBinaryTagAndValue sAMBinaryTagAndValue = this.mAttributes.find(s);
        if (sAMBinaryTagAndValue != null) {
            return sAMBinaryTagAndValue.value;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (object != null && object.getClass().isArray() && Array.getLength(object) == 0) {
            throw new IllegalArgumentException("Empty value passed for tag " + string);
        }
        this.setAttribute(SAMTagUtil.getSingleton().makeBinaryTag(string), object);
    }

    public void setUnsignedArrayAttribute(String string, Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to setUnsignedArrayAttribute for tag " + string);
        }
        if (Array.getLength(object) == 0) {
            throw new IllegalArgumentException("Empty array passed to setUnsignedArrayAttribute for tag " + string);
        }
        this.setAttribute(SAMTagUtil.getSingleton().makeBinaryTag(string), object, true);
    }

    protected void setAttribute(short s, Object object) {
        this.setAttribute(s, object, false);
    }

    protected static boolean isAllowedAttributeValue(Object object) {
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof String || object instanceof Character || object instanceof Float || object instanceof byte[] || object instanceof short[] || object instanceof int[] || object instanceof float[]) {
            return true;
        }
        if (object instanceof Long) {
            return SAMUtils.isValidUnsignedIntegerAttribute((Long)object) || (Long)object >= Integer.MIN_VALUE && (Long)object <= Integer.MAX_VALUE;
        }
        return false;
    }

    protected void setAttribute(short s, Object object, boolean bl) {
        if (object == null) {
            if (this.mAttributes != null) {
                this.mAttributes = this.mAttributes.remove(s);
            }
            return;
        }
        if (SAMRecord.isAllowedAttributeValue(object)) {
            SAMBinaryTagAndValue sAMBinaryTagAndValue;
            if (!bl) {
                sAMBinaryTagAndValue = new SAMBinaryTagAndValue(s, object);
            } else {
                if (!object.getClass().isArray() || object instanceof float[]) {
                    throw new SAMException("Attribute type " + object.getClass() + " cannot be encoded as an unsigned array. Tag: " + SAMTagUtil.getSingleton().makeStringTag(s));
                }
                sAMBinaryTagAndValue = new SAMBinaryTagAndUnsignedArrayValue(s, object);
            }
            this.mAttributes = this.mAttributes == null ? sAMBinaryTagAndValue : this.mAttributes.insert(sAMBinaryTagAndValue);
        } else {
            throw new SAMException("Attribute type " + object.getClass() + " not supported. Tag: " + SAMTagUtil.getSingleton().makeStringTag(s));
        }
    }

    public void clearAttributes() {
        this.mAttributes = null;
    }

    protected void setAttributes(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        this.mAttributes = sAMBinaryTagAndValue;
    }

    protected SAMBinaryTagAndValue getBinaryAttributes() {
        return this.mAttributes;
    }

    @Override
    public String getContig() {
        if (this.getReadUnmappedFlag()) {
            return null;
        }
        return this.getReferenceName();
    }

    @Override
    public int getStart() {
        return this.getAlignmentStart();
    }

    @Override
    public int getEnd() {
        return this.getAlignmentEnd();
    }

    public List<SAMTagAndValue> getAttributes() {
        ArrayList<SAMTagAndValue> arrayList = new ArrayList<SAMTagAndValue>();
        for (SAMBinaryTagAndValue sAMBinaryTagAndValue = this.getBinaryAttributes(); sAMBinaryTagAndValue != null; sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) {
            arrayList.add(new SAMTagAndValue(SAMTagUtil.getSingleton().makeStringTag(sAMBinaryTagAndValue.tag), sAMBinaryTagAndValue.value));
        }
        return arrayList;
    }

    Integer getIndexingBin() {
        return this.mIndexingBin;
    }

    void setIndexingBin(Integer n) {
        this.mIndexingBin = n;
    }

    int computeIndexingBin() {
        int n = this.getAlignmentStart() - 1;
        int n2 = this.getAlignmentEnd();
        if (n2 <= 0) {
            n2 = n + 1;
        }
        return GenomicIndexUtil.reg2bin(n, n2);
    }

    public SAMFileHeader getHeader() {
        return this.mHeader;
    }

    public void setHeader(SAMFileHeader sAMFileHeader) {
        this.mHeader = sAMFileHeader;
    }

    public byte[] getVariableBinaryRepresentation() {
        return null;
    }

    public int getAttributesBinarySize() {
        return -1;
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addField(stringBuilder, this.getReadName(), null, null);
        this.addField(stringBuilder, this.getFlags(), null, null);
        this.addField(stringBuilder, this.getReferenceName(), null, "*");
        this.addField(stringBuilder, this.getAlignmentStart(), 0, "*");
        this.addField(stringBuilder, this.getMappingQuality(), 0, "0");
        this.addField(stringBuilder, this.getCigarString(), null, "*");
        this.addField(stringBuilder, this.getMateReferenceName(), null, "*");
        this.addField(stringBuilder, this.getMateAlignmentStart(), 0, "*");
        this.addField(stringBuilder, this.getInferredInsertSize(), 0, "*");
        this.addField(stringBuilder, this.getReadString(), null, "*");
        this.addField(stringBuilder, this.getBaseQualityString(), null, "*");
        if (this.mAttributes != null) {
            for (SAMBinaryTagAndValue sAMBinaryTagAndValue = this.getBinaryAttributes(); sAMBinaryTagAndValue != null; sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) {
                this.addField(stringBuilder, this.formatTagValue(sAMBinaryTagAndValue.tag, sAMBinaryTagAndValue.value));
            }
        }
        return stringBuilder.toString();
    }

    private void addField(StringBuilder stringBuilder, Object object, Object object2, String string) {
        if (this.safeEquals(object, object2)) {
            this.addField(stringBuilder, string);
        } else if (object == null) {
            this.addField(stringBuilder, "");
        } else {
            this.addField(stringBuilder, object.toString());
        }
    }

    private void addField(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\t');
        }
        stringBuilder.append(string);
    }

    private String formatTagValue(short s, Object object) {
        String string = SAMTagUtil.getSingleton().makeStringTag(s);
        if (object == null || object instanceof String) {
            return string + ":Z:" + object;
        }
        if (object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte) {
            return string + ":i:" + object;
        }
        if (object instanceof Character) {
            return string + ":A:" + object;
        }
        if (object instanceof Float) {
            return string + ":f:" + object;
        }
        if (object instanceof byte[]) {
            return string + ":H:" + StringUtil.bytesToHexString((byte[])object);
        }
        throw new RuntimeException("Unexpected value type for tag " + string + ": " + object + " of class " + object.getClass().getName());
    }

    private boolean safeEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    protected void eagerDecode() {
        this.getCigar();
        this.getCigarString();
    }

    public List<AlignmentBlock> getAlignmentBlocks() {
        if (this.mAlignmentBlocks == null) {
            this.mAlignmentBlocks = SAMUtils.getAlignmentBlocks(this.getCigar(), this.getAlignmentStart(), "read cigar");
        }
        return this.mAlignmentBlocks;
    }

    public List<SAMValidationError> validateCigar(long l) {
        List<SAMValidationError> list = null;
        if (this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
            list = SAMUtils.validateCigar(this, this.getCigar(), this.getReferenceIndex(), this.getAlignmentBlocks(), l, "Read CIGAR");
        }
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SAMRecord)) {
            return false;
        }
        SAMRecord sAMRecord = (SAMRecord)object;
        if (this.mAlignmentStart != sAMRecord.mAlignmentStart) {
            return false;
        }
        if (this.mFlags != sAMRecord.mFlags) {
            return false;
        }
        if (this.mInferredInsertSize != sAMRecord.mInferredInsertSize) {
            return false;
        }
        if (this.mMappingQuality != sAMRecord.mMappingQuality) {
            return false;
        }
        if (this.mMateAlignmentStart != sAMRecord.mMateAlignmentStart) {
            return false;
        }
        if (this.mIndexingBin != null ? !this.mIndexingBin.equals(sAMRecord.mIndexingBin) : sAMRecord.mIndexingBin != null) {
            return false;
        }
        if (this.mMateReferenceIndex != null ? !this.mMateReferenceIndex.equals(sAMRecord.mMateReferenceIndex) : sAMRecord.mMateReferenceIndex != null) {
            return false;
        }
        if (this.mReferenceIndex != null ? !this.mReferenceIndex.equals(sAMRecord.mReferenceIndex) : sAMRecord.mReferenceIndex != null) {
            return false;
        }
        this.eagerDecode();
        sAMRecord.eagerDecode();
        if (this.mReadName != null ? !this.mReadName.equals(sAMRecord.mReadName) : sAMRecord.mReadName != null) {
            return false;
        }
        if (this.mAttributes != null ? !this.mAttributes.equals(sAMRecord.mAttributes) : sAMRecord.mAttributes != null) {
            return false;
        }
        if (!Arrays.equals(this.mBaseQualities, sAMRecord.mBaseQualities)) {
            return false;
        }
        if (this.mCigar != null ? !this.mCigar.equals(sAMRecord.mCigar) : sAMRecord.mCigar != null) {
            return false;
        }
        if (this.mMateReferenceName != null ? !this.mMateReferenceName.equals(sAMRecord.mMateReferenceName) : sAMRecord.mMateReferenceName != null) {
            return false;
        }
        if (!Arrays.equals(this.mReadBases, sAMRecord.mReadBases)) {
            return false;
        }
        return !(this.mReferenceName != null ? !this.mReferenceName.equals(sAMRecord.mReferenceName) : sAMRecord.mReferenceName != null);
    }

    public int hashCode() {
        this.eagerDecode();
        int n = this.mReadName != null ? this.mReadName.hashCode() : 0;
        n = 31 * n + (this.mReadBases != null ? Arrays.hashCode(this.mReadBases) : 0);
        n = 31 * n + (this.mBaseQualities != null ? Arrays.hashCode(this.mBaseQualities) : 0);
        n = 31 * n + (this.mReferenceName != null ? this.mReferenceName.hashCode() : 0);
        n = 31 * n + this.mAlignmentStart;
        n = 31 * n + this.mMappingQuality;
        n = 31 * n + (this.mCigarString != null ? this.mCigarString.hashCode() : 0);
        n = 31 * n + this.mFlags;
        n = 31 * n + (this.mMateReferenceName != null ? this.mMateReferenceName.hashCode() : 0);
        n = 31 * n + this.mMateAlignmentStart;
        n = 31 * n + this.mInferredInsertSize;
        n = 31 * n + (this.mAttributes != null ? this.mAttributes.hashCode() : 0);
        n = 31 * n + (this.mReferenceIndex != null ? this.mReferenceIndex.hashCode() : 0);
        n = 31 * n + (this.mMateReferenceIndex != null ? this.mMateReferenceIndex.hashCode() : 0);
        n = 31 * n + (this.mIndexingBin != null ? this.mIndexingBin.hashCode() : 0);
        return n;
    }

    public List<SAMValidationError> isValid() {
        return this.isValid(false);
    }

    public List<SAMValidationError> isValid(boolean bl) {
        Object object;
        List<SAMValidationError> list;
        List<SAMValidationError> list2;
        ArrayList<SAMValidationError> arrayList = null;
        if (!this.getReadPairedFlag()) {
            if (this.getProperPairFlagUnchecked()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<SAMValidationError>();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_PROPER_PAIR, "Proper pair flag should not be set for unpaired read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getMateUnmappedFlagUnchecked()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_UNMAPPED, "Mate unmapped flag should not be set for unpaired read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getMateNegativeStrandFlagUnchecked()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_NEG_STRAND, "Mate negative strand flag should not be set for unpaired read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getFirstOfPairFlagUnchecked()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_FIRST_OF_PAIR, "First of pair flag should not be set for unpaired read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getSecondOfPairFlagUnchecked()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_SECOND_OF_PAIR, "Second of pair flag should not be set for unpaired read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getMateReferenceIndex() != -1) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_MATE_REF_INDEX, "MRNM should not be set for unpaired read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
        } else {
            list2 = this.isValidReferenceIndexAndPosition(this.mMateReferenceIndex, this.mMateReferenceName, this.getMateAlignmentStart(), true, bl);
            if (list2 != null) {
                if (bl) {
                    return list2;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(list2);
            }
            if (!this.hasMateReferenceName() && !this.getMateUnmappedFlag()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_UNMAPPED, "Mapped mate should have mate reference name", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (!this.getFirstOfPairFlagUnchecked() && !this.getSecondOfPairFlagUnchecked()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.PAIRED_READ_NOT_MARKED_AS_FIRST_OR_SECOND, "Paired read should be marked as first of pair or second of pair.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
        }
        if (this.getInferredInsertSize() > 0x20000000 || this.getInferredInsertSize() < -536870912) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_INSERT_SIZE, "Insert size out of range", this.getReadName()));
            if (bl) {
                return arrayList;
            }
        }
        if (this.getReadUnmappedFlag()) {
            if (this.getNotPrimaryAlignmentFlag()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_NOT_PRIM_ALIGNMENT, "Not primary alignment flag should not be set for unmapped read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getSupplementaryAlignmentFlag()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_SUPPLEMENTARY_ALIGNMENT, "Supplementary alignment flag should not be set for unmapped read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getMappingQuality() != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_MAPPING_QUALITY, "MAPQ should be 0 for unmapped read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
        } else {
            if (this.getMappingQuality() >= 256) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_MAPPING_QUALITY, "MAPQ should be < 256.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getCigarLength() == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "CIGAR should have > zero elements for mapped read.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (this.getHeader().getSequenceDictionary().size() == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.MISSING_SEQUENCE_DICTIONARY, "Empty sequence dictionary.", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
            if (!this.hasReferenceName()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_READ_UNMAPPED, "Mapped read should have valid reference name", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            }
        }
        if ((list2 = (String)this.getAttribute(SAMTagUtil.getSingleton().RG)) != null && this.getHeader().getReadGroup((String)((Object)list2)) == null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(new SAMValidationError(SAMValidationError.Type.READ_GROUP_NOT_FOUND, "RG ID on SAMRecord not found in header: " + (String)((Object)list2), this.getReadName()));
            if (bl) {
                return arrayList;
            }
        }
        if ((list = this.isValidReferenceIndexAndPosition(this.mReferenceIndex, this.mReferenceName, this.getAlignmentStart(), false)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.addAll(list);
            if (bl) {
                return arrayList;
            }
        }
        if (this.getReadLength() == 0 && !this.getNotPrimaryAlignmentFlag() && (object = this.getAttribute(SAMTagUtil.getSingleton().FZ)) == null) {
            String string = (String)this.getAttribute(SAMTagUtil.getSingleton().CQ);
            String string2 = (String)this.getAttribute(SAMTagUtil.getSingleton().CS);
            if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.EMPTY_READ, "Zero-length read without FZ, CS or CQ tag", this.getReadName()));
                if (bl) {
                    return arrayList;
                }
            } else if (!this.getReadUnmappedFlag()) {
                boolean bl2 = false;
                for (CigarElement cigarElement : this.getCigar().getCigarElements()) {
                    if (cigarElement.getOperator() != CigarOperator.DELETION && cigarElement.getOperator() != CigarOperator.INSERTION) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.EMPTY_READ, "Colorspace read with zero-length bases but no indel", this.getReadName()));
                    if (bl) {
                        return arrayList;
                    }
                }
            }
        }
        if (this.getReadLength() != this.getBaseQualities().length && !Arrays.equals(this.getBaseQualities(), NULL_QUALS)) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_READ_LENGTH_AND_QUALS_LENGTH, "Read length does not match quals length", this.getReadName()));
            if (bl) {
                return arrayList;
            }
        }
        if (this.getAlignmentStart() != 0 && this.getIndexingBin() != null && this.computeIndexingBin() != this.getIndexingBin().intValue()) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_INDEXING_BIN, "bin field of BAM record does not equal value computed based on alignment start and end, and length of sequence to which read is aligned", this.getReadName()));
            if (bl) {
                return arrayList;
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public SAMFileSource getFileSource() {
        return this.mFileSource;
    }

    protected void setFileSource(SAMFileSource sAMFileSource) {
        this.mFileSource = sAMFileSource;
    }

    private List<SAMValidationError> isValidReferenceIndexAndPosition(Integer n, String string, int n2, boolean bl) {
        return this.isValidReferenceIndexAndPosition(n, string, n2, bl, false);
    }

    private List<SAMValidationError> isValidReferenceIndexAndPosition(Integer n, String string, int n2, boolean bl, boolean bl2) {
        boolean bl3 = SAMRecord.hasReferenceName(n, string);
        ArrayList<SAMValidationError> arrayList = null;
        if (!bl3) {
            if (n2 != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<SAMValidationError>();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start should be 0 because reference name = *.", bl), this.getReadName()));
                if (bl2) {
                    return arrayList;
                }
            }
        } else {
            if (n2 == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start should != 0 because reference name != *.", bl), this.getReadName()));
                if (bl2) {
                    return arrayList;
                }
            }
            if (this.getHeader().getSequenceDictionary().size() > 0) {
                SAMSequenceRecord sAMSequenceRecord;
                SAMSequenceRecord sAMSequenceRecord2 = sAMSequenceRecord = n != null ? this.getHeader().getSequence(n) : this.getHeader().getSequence(string);
                if (sAMSequenceRecord == null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_REFERENCE_INDEX, this.buildMessage("Reference sequence not found in sequence dictionary.", bl), this.getReadName()));
                    if (bl2) {
                        return arrayList;
                    }
                } else if (n2 > sAMSequenceRecord.getSequenceLength()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start (" + n2 + ") must be <= reference sequence length (" + sAMSequenceRecord.getSequenceLength() + ") on reference " + sAMSequenceRecord.getSequenceName(), bl), this.getReadName()));
                    if (bl2) {
                        return arrayList;
                    }
                }
            }
        }
        return arrayList;
    }

    private String buildMessage(String string, boolean bl) {
        return bl ? "Mate " + string : string;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMRecord sAMRecord = (SAMRecord)super.clone();
        if (this.mAttributes != null) {
            sAMRecord.mAttributes = this.mAttributes.copy();
        }
        return sAMRecord;
    }

    public SAMRecord deepCopy() {
        SAMRecord sAMRecord = new SAMRecord(this.getHeader());
        sAMRecord.setReadName(this.getReadName());
        sAMRecord.setReadBases(Arrays.copyOf(this.getReadBases(), this.getReadLength()));
        byte[] byArray = this.getBaseQualities();
        sAMRecord.setBaseQualities(Arrays.copyOf(byArray, byArray.length));
        sAMRecord.setReferenceName(this.getReferenceName());
        sAMRecord.setAlignmentStart(this.getAlignmentStart());
        sAMRecord.setMappingQuality(this.getMappingQuality());
        sAMRecord.setCigarString(this.getCigarString());
        sAMRecord.setFileSource(null);
        sAMRecord.setFlags(this.getFlags());
        sAMRecord.setMateReferenceName(this.getMateReferenceName());
        sAMRecord.setMateAlignmentStart(this.getMateAlignmentStart());
        sAMRecord.setInferredInsertSize(this.getInferredInsertSize());
        sAMRecord.setReferenceIndex(this.getReferenceIndex());
        sAMRecord.setMateReferenceIndex(this.getMateReferenceIndex());
        sAMRecord.setValidationStringency(this.getValidationStringency());
        SAMBinaryTagAndValue sAMBinaryTagAndValue = this.getBinaryAttributes();
        if (null != sAMBinaryTagAndValue) {
            sAMRecord.setAttributes(sAMBinaryTagAndValue.deepCopy());
        }
        return sAMRecord;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getReadName());
        if (this.getReadPairedFlag()) {
            if (this.getFirstOfPairFlag()) {
                stringBuilder.append(" 1/2");
            } else {
                stringBuilder.append(" 2/2");
            }
        }
        stringBuilder.append(" ");
        stringBuilder.append(String.valueOf(this.getReadLength()));
        stringBuilder.append("b");
        if (this.getReadUnmappedFlag()) {
            stringBuilder.append(" unmapped read.");
        } else {
            stringBuilder.append(" aligned read.");
        }
        return stringBuilder.toString();
    }

    public String getSAMString() {
        return SAMTextWriter.getSAMString(this);
    }

    public String getPairedReadName() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getReadName());
        if (this.getReadPairedFlag()) {
            if (this.getFirstOfPairFlag()) {
                stringBuilder.append(" 1/2");
            } else {
                stringBuilder.append(" 2/2");
            }
        }
        return stringBuilder.toString();
    }

    public final Set<SAMFlag> getSAMFlags() {
        return SAMFlag.getFlags(this.getFlags());
    }

    public final Object getTransientAttribute(Object object) {
        return this.transientAttributes == null ? null : this.transientAttributes.get(object);
    }

    public final Object setTransientAttribute(Object object, Object object2) {
        if (this.transientAttributes == null) {
            this.transientAttributes = new HashMap<Object, Object>();
        }
        return this.transientAttributes.put(object, object2);
    }

    public final Object removeTransientAttribute(Object object) {
        if (this.transientAttributes != null) {
            return this.transientAttributes.remove(object);
        }
        return null;
    }

    public static class SAMTagAndValue {
        public final String tag;
        public final Object value;

        public SAMTagAndValue(String string, Object object) {
            this.tag = string;
            this.value = object;
        }
    }
}

