/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinList;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.WeakHashMap;

class CachingBAMFileIndex
extends AbstractBAMFileIndex
implements BrowseableBAMIndex {
    private Integer mLastReferenceRetrieved = null;
    private final WeakHashMap<Integer, BAMIndexContent> mQueriesByReference = new WeakHashMap();

    public CachingBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        super(file, sAMSequenceDictionary);
    }

    public CachingBAMFileIndex(SeekableStream seekableStream, SAMSequenceDictionary sAMSequenceDictionary) {
        super(seekableStream, sAMSequenceDictionary);
    }

    public CachingBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        super(file, sAMSequenceDictionary, bl);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int n, int n2, int n3) {
        BAMIndexContent bAMIndexContent = this.getQueryResults(n);
        if (bAMIndexContent == null) {
            return null;
        }
        List<Chunk> list = bAMIndexContent.getChunksOverlapping(n2, n3);
        if (list == null) {
            return null;
        }
        return new BAMFileSpan(list);
    }

    @Override
    public BinList getBinsOverlapping(int n, int n2, int n3) {
        BitSet bitSet = GenomicIndexUtil.regionToBins(n2, n3);
        if (bitSet == null) {
            return null;
        }
        return new BinList(n, bitSet);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        if (bin == null) {
            return null;
        }
        int n = bin.getReferenceSequence();
        BAMIndexContent bAMIndexContent = this.getQueryResults(n);
        if (bAMIndexContent == null) {
            return null;
        }
        int n2 = this.getLevelForBin(bin);
        int n3 = this.getFirstLocusInBin(bin);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bAMIndexContent.containsBin(bin)) {
            arrayList.add(bAMIndexContent.getBins().getBin(bin.getBinNumber()));
        }
        int n4 = n2;
        while (--n4 >= 0) {
            int n5 = CachingBAMFileIndex.getFirstBinInLevel(n4);
            int n6 = this.getMaxAddressibleGenomicLocation() / this.getLevelSize(n4);
            int n7 = n3 / n6 + n5;
            Bin bin2 = bAMIndexContent.getBins().getBin(n7);
            if (bin2 == null || !bAMIndexContent.containsBin(bin2)) continue;
            arrayList.add(bin2);
        }
        List<Chunk> list = new ArrayList<Chunk>();
        for (Bin bin3 : arrayList) {
            for (Chunk chunk : bin3.getChunkList()) {
                list.add(chunk.clone());
            }
        }
        int n8 = this.getFirstLocusInBin(bin);
        list = Chunk.optimizeChunkList(list, bAMIndexContent.getLinearIndex().getMinimumOffset(n8));
        return new BAMFileSpan(list);
    }

    @Override
    protected BAMIndexContent getQueryResults(int n) {
        if (this.mLastReferenceRetrieved != null && this.mLastReferenceRetrieved == n) {
            return this.mQueriesByReference.get(n);
        }
        BAMIndexContent bAMIndexContent = this.mQueriesByReference.get(n);
        if (bAMIndexContent != null) {
            this.mLastReferenceRetrieved = n;
            this.mQueriesByReference.put(n, bAMIndexContent);
            return bAMIndexContent;
        }
        bAMIndexContent = this.query(n, 1, -1);
        if (bAMIndexContent != null) {
            this.mLastReferenceRetrieved = n;
            this.mQueriesByReference.put(n, bAMIndexContent);
            return bAMIndexContent;
        }
        return null;
    }
}

