/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Bin;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BinList
implements Iterable<Bin> {
    private final int referenceSequence;
    private final BitSet bins;

    protected BinList(int n, BitSet bitSet) {
        this.referenceSequence = n;
        this.bins = bitSet;
    }

    @Override
    public Iterator<Bin> iterator() {
        return new BinIterator();
    }

    protected int getReferenceSequence() {
        return this.referenceSequence;
    }

    protected BitSet getBins() {
        return this.bins;
    }

    private class BinIterator
    implements Iterator<Bin> {
        private int nextBin;

        public BinIterator() {
            this.nextBin = BinList.this.bins.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextBin >= 0;
        }

        @Override
        public Bin next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("This BinIterator is currently empty");
            }
            int n = this.nextBin;
            this.nextBin = BinList.this.bins.nextSetBit(this.nextBin + 1);
            return new Bin(BinList.this.referenceSequence, n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from a bin iterator");
        }
    }
}

