/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.control.BlackBox;
import java.util.ArrayList;
import java.util.Vector;

public class OpenLoop
extends BlackBox {
    private ArrayList<BlackBox> openPath = new ArrayList();
    private ArrayList<Object> segments = new ArrayList();
    private int nBoxes = 0;
    private int nSeg = 0;
    private boolean checkPath = false;
    private boolean checkNoMix = true;
    private boolean checkConsolidate = false;
    private boolean[] adcs = null;
    private boolean[] dacs = null;
    private boolean[] zeroHolds = null;

    public OpenLoop() {
        super("OpenLoop");
    }

    public void addBoxToPath(BlackBox box) {
        this.openPath.add(box);
        ++this.nBoxes;
    }

    public void consolidate() {
        if (!this.segments.isEmpty()) {
            this.segments.clear();
            this.nBoxes = 0;
            this.nSeg = 0;
            this.checkNoMix = true;
            this.checkPath = false;
        }
        this.segment();
        BlackBox aa = null;
        aa = this.nSeg == 1 ? (this.nBoxes == 1 ? this.openPath.get(0) : (BlackBox)this.segments.get(3)) : this.combineSegment(0, this.nBoxes);
        this.sNumer = aa.sNumer.copy();
        this.sDenom = aa.sDenom.copy();
        this.sNumerPade = aa.sNumerPade.copy();
        this.sDenomPade = aa.sDenomPade.copy();
        this.sNumerDeg = aa.sNumerDeg;
        this.sDenomDeg = aa.sDenomDeg;
        this.sNumerDegPade = aa.sNumerDegPade;
        this.sDenomDegPade = aa.sDenomDegPade;
        this.sNumerSet = true;
        this.sDenomSet = true;
        this.deadTime = aa.deadTime;
        this.sZeros = Complex.copy(aa.sZeros);
        this.sPoles = Complex.copy(aa.sPoles);
        this.sZerosPade = Complex.copy(aa.sZerosPade);
        this.sPolesPade = Complex.copy(aa.sPolesPade);
        this.padeAdded = true;
        this.sNumerScaleFactor = this.sNumerDeg == 0 ? this.sNumer.coeffCopy(0) : BlackBox.scaleFactor(this.sNumer, this.sZeros);
        this.sDenomScaleFactor = this.sDenomDeg == 0 ? this.sDenom.coeffCopy(0) : BlackBox.scaleFactor(this.sDenom, this.sPoles);
        this.checkConsolidate = true;
    }

    public void segment() {
        this.adcs = new boolean[this.nBoxes];
        int nADCs = 0;
        this.dacs = new boolean[this.nBoxes];
        int nDACs = 0;
        this.zeroHolds = new boolean[this.nBoxes];
        int nZeroHolds = 0;
        String thisName = null;
        for (int i = 0; i < this.nBoxes; ++i) {
            this.adcs[i] = false;
            this.dacs[i] = false;
            this.zeroHolds[i] = false;
            BlackBox aa = this.openPath.get(i);
            thisName = aa.fixedName;
            if (thisName.equals("ADC")) {
                this.adcs[i] = true;
                ++nADCs;
                continue;
            }
            if (thisName.equals("DAC")) {
                this.dacs[i] = true;
                ++nDACs;
                continue;
            }
            if (!thisName.equals("ZeroOrderHold")) continue;
            this.zeroHolds[i] = true;
            ++nZeroHolds;
        }
        if (nADCs == 0 && nDACs == 0) {
            this.nSeg = 1;
            this.checkNoMix = true;
            this.checkPath = true;
            this.segments.add(new Integer(0));
            this.segments.add(new Integer(this.nBoxes - 1));
            this.segments.add("analogue");
            BlackBox bb = this.combineSegment(0, this.nBoxes - 1);
            this.segments.add(bb);
        } else {
            BlackBox bb;
            this.nSeg = 0;
            int adc0 = 0;
            int dac0 = 0;
            boolean adcFirst = false;
            if (nADCs > 0 && nDACs > 0) {
                boolean test0 = true;
                adc0 = 0;
                while (test0) {
                    if (this.adcs[adc0]) {
                        test0 = false;
                        continue;
                    }
                    if (++adc0 < this.nBoxes) continue;
                    test0 = false;
                }
                test0 = true;
                while (test0) {
                    if (this.dacs[dac0]) {
                        test0 = false;
                        continue;
                    }
                    if (++dac0 < this.nBoxes) continue;
                    test0 = false;
                }
                if (adc0 < dac0) {
                    adcFirst = true;
                }
            } else if (nADCs > 0) {
                adcFirst = true;
            }
            boolean adswitch = adcFirst;
            ++this.nSeg;
            int nextStart = 0;
            if (adcFirst) {
                this.segments.add(new Integer(0));
                this.segments.add(new Integer(adc0));
                this.segments.add("digital");
                bb = this.combineSegment(0, adc0);
                this.segments.add(bb);
                nextStart = adc0 + 1;
            } else {
                this.segments.add(new Integer(0));
                this.segments.add(new Integer(dac0));
                this.segments.add("analogue");
                bb = this.combineSegment(0, dac0);
                this.segments.add(bb);
                nextStart = dac0 + 1;
            }
            boolean test1 = true;
            if (nextStart >= this.nBoxes) {
                test1 = false;
            }
            while (test1) {
                if (adswitch) {
                    nextStart = this.nextDigitalSegment(nextStart);
                    adswitch = false;
                } else {
                    nextStart = this.nextAnalogueSegment(nextStart);
                    adswitch = true;
                }
                if (nextStart < this.nBoxes) continue;
                test1 = false;
            }
        }
    }

    private int nextDigitalSegment(int box0) {
        int nextAdc = this.nBoxes;
        boolean endFound = false;
        boolean test = true;
        int ii = box0;
        while (test) {
            if (this.adcs[ii]) {
                nextAdc = ii;
                test = false;
                continue;
            }
            if (++ii < this.nBoxes) continue;
            test = false;
        }
        int nextDac = this.nBoxes;
        test = true;
        ii = box0;
        while (test) {
            if (this.dacs[ii]) {
                nextDac = ii;
                test = false;
                continue;
            }
            if (++ii < this.nBoxes) continue;
            test = false;
            endFound = true;
        }
        if (endFound) {
            nextDac = this.nBoxes - 1;
        }
        if (nextAdc < nextDac) {
            throw new IllegalArgumentException("Two consecutive ADCs with no intervening DAC");
        }
        ++this.nSeg;
        this.segments.add(new Integer(0));
        this.segments.add(new Integer(nextDac));
        this.segments.add("digital");
        BlackBox bb = this.combineSegment(0, nextDac);
        this.segments.add(bb);
        return nextDac + 1;
    }

    private int nextAnalogueSegment(int box0) {
        int nextAdc = this.nBoxes;
        boolean endFound = false;
        boolean test = true;
        int ii = box0;
        while (test) {
            if (this.adcs[ii]) {
                nextAdc = ii;
                test = false;
                continue;
            }
            if (++ii < this.nBoxes) continue;
            test = false;
            endFound = true;
        }
        int nextDac = this.nBoxes;
        test = true;
        ii = box0;
        while (test) {
            if (this.dacs[ii]) {
                nextDac = ii;
                test = false;
                continue;
            }
            if (++ii < this.nBoxes) continue;
            test = false;
        }
        if (endFound) {
            nextAdc = this.nBoxes - 1;
        }
        if (nextDac < nextAdc) {
            throw new IllegalArgumentException("Two consecutive DACs with no intervening ADC");
        }
        ++this.nSeg;
        this.segments.add(new Integer(0));
        this.segments.add(new Integer(nextAdc));
        this.segments.add("digital");
        BlackBox bb = this.combineSegment(0, nextAdc);
        this.segments.add(bb);
        return nextAdc + 1;
    }

    public BlackBox combineSegment(int iLow, int iHigh) {
        int ii;
        int i;
        ArrayList<Complex> zeros = new ArrayList<Complex>();
        ArrayList<Complex> poles = new ArrayList<Complex>();
        ArrayList<Complex> zerosPade = new ArrayList<Complex>();
        ArrayList<Complex> polesPade = new ArrayList<Complex>();
        BlackBox aa = new BlackBox();
        int nBoxSeg = iHigh - iLow + 1;
        BlackBox bb = this.openPath.get(iLow);
        if (!bb.padeAdded) {
            bb.transferPolesZeros();
        }
        aa.sNumerPade = bb.sNumerPade.copy();
        aa.sDenomPade = bb.sDenomPade.copy();
        aa.sNumer = bb.sNumer.copy();
        aa.sDenom = bb.sDenom.copy();
        aa.sNumerDegPade = bb.sNumerDegPade;
        aa.sDenomDegPade = bb.sDenomDegPade;
        aa.sNumerDeg = bb.sNumerDeg;
        aa.sDenomDeg = bb.sDenomDeg;
        if (aa.sNumerDegPade > 0) {
            Complex[] bbsZerosPade = Complex.copy(bb.sZerosPade);
            for (i = 0; i < aa.sNumerDegPade; ++i) {
                zerosPade.add(bbsZerosPade[i]);
            }
        }
        if (aa.sDenomDegPade > 0) {
            Complex[] bbsPolesPade = Complex.copy(bb.sPolesPade);
            for (i = 0; i < aa.sDenomDegPade; ++i) {
                polesPade.add(bbsPolesPade[i]);
            }
        }
        if (aa.sNumerDeg > 0) {
            Complex[] bbsZeros = Complex.copy(bb.sZeros);
            for (i = 0; i < aa.sNumerDeg; ++i) {
                zeros.add(bbsZeros[i]);
            }
        }
        if (aa.sDenomDeg > 0) {
            Complex[] bbsPoles = Complex.copy(bb.sPoles);
            for (i = 0; i < aa.sDenomDeg; ++i) {
                poles.add(bbsPoles[i]);
            }
        }
        aa.deadTime = bb.deadTime;
        aa.sNumerScaleFactor = bb.sNumerScaleFactor.copy();
        aa.sDenomScaleFactor = bb.sDenomScaleFactor.copy();
        for (int i2 = 1; i2 < nBoxSeg; ++i2) {
            int ii2;
            bb = this.openPath.get(i2 + iLow);
            if (!bb.padeAdded) {
                bb.transferPolesZeros();
            }
            if (aa.sNumerPade == null) {
                if (bb.sNumerPade != null) {
                    aa.sNumerPade = bb.sNumerPade.copy();
                }
            } else if (bb.sNumerPade != null) {
                aa.sNumerPade = aa.sNumerPade.times(bb.sNumerPade);
            }
            if (aa.sNumer == null) {
                if (bb.sNumer != null) {
                    aa.sNumer = bb.sNumer.copy();
                }
            } else if (bb.sNumer != null) {
                aa.sNumer = aa.sNumer.times(bb.sNumer);
            }
            if (aa.sDenom == null) {
                if (bb.sDenom != null) {
                    aa.sDenom = bb.sDenom.copy();
                }
            } else if (bb.sDenom != null) {
                aa.sDenom = aa.sDenom.times(bb.sDenom);
            }
            if (aa.sDenomPade == null) {
                if (bb.sDenomPade != null) {
                    aa.sDenomPade = bb.sDenomPade.copy();
                }
            } else if (bb.sDenomPade != null) {
                aa.sDenomPade = aa.sDenomPade.times(bb.sDenomPade);
            }
            aa.sNumerDegPade += bb.sNumerDegPade;
            aa.sDenomDegPade += bb.sDenomDegPade;
            aa.sNumerDeg += bb.sNumerDeg;
            aa.sDenomDeg += bb.sDenomDeg;
            aa.sNumerScaleFactor = bb.sNumerScaleFactor.times(aa.sNumerScaleFactor);
            aa.sDenomScaleFactor = bb.sDenomScaleFactor.times(aa.sDenomScaleFactor);
            aa.deadTime += bb.deadTime;
            if (bb.sNumerDegPade > 0) {
                Complex[] bbsZerosPade = Complex.copy(bb.sZerosPade);
                for (ii2 = 0; ii2 < bb.sNumerDegPade; ++ii2) {
                    zerosPade.add(bbsZerosPade[ii2]);
                }
            }
            if (bb.sDenomDegPade > 0) {
                Complex[] bbsPolesPade = Complex.copy(bb.sPolesPade);
                for (ii2 = 0; ii2 < bb.sDenomDegPade; ++ii2) {
                    polesPade.add(bbsPolesPade[ii2]);
                }
            }
            if (bb.sNumerDeg > 0) {
                Complex[] bbsZeros = Complex.copy(bb.sZeros);
                for (ii2 = 0; ii2 < bb.sNumerDeg; ++ii2) {
                    zeros.add(bbsZeros[ii2]);
                }
            }
            if (bb.sDenomDeg <= 0) continue;
            Complex[] bbsPoles = Complex.copy(bb.sPoles);
            for (ii2 = 0; ii2 < bb.sDenomDeg; ++ii2) {
                poles.add(bbsPoles[ii2]);
            }
        }
        if (aa.sNumerDegPade > 0) {
            aa.sZerosPade = Complex.oneDarray(aa.sNumerDegPade);
            for (ii = 0; ii < aa.sNumerDegPade; ++ii) {
                aa.sZerosPade[ii] = (Complex)zerosPade.get(ii);
            }
        }
        if (aa.sDenomDegPade > 0) {
            aa.sPolesPade = Complex.oneDarray(aa.sDenomDegPade);
            for (ii = 0; ii < aa.sDenomDegPade; ++ii) {
                aa.sPolesPade[ii] = (Complex)polesPade.get(ii);
            }
        }
        if (aa.sNumerDeg > 0) {
            aa.sZeros = Complex.oneDarray(aa.sNumerDeg);
            for (ii = 0; ii < aa.sNumerDeg; ++ii) {
                aa.sZeros[ii] = (Complex)zeros.get(ii);
            }
        }
        if (aa.sDenomDeg > 0) {
            aa.sPoles = Complex.oneDarray(aa.sDenomDeg);
            for (ii = 0; ii < aa.sDenomDeg; ++ii) {
                aa.sPoles[ii] = (Complex)poles.get(ii);
            }
        }
        return aa;
    }

    public int getNumberOfBoxes() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.nBoxes;
    }

    public ArrayList<Object> getSegmentsArrayList() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.segments;
    }

    public Vector<Object> getSegmentsVector() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        ArrayList<Object> seg = this.segments;
        Vector<Object> ret = null;
        if (seg != null) {
            int n = seg.size();
            ret = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                ret.addElement(seg.get(i));
            }
        }
        return ret;
    }

    public int getNumberOfSegments() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.nSeg;
    }

    public String getNamesOfBoxes() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        String names = "";
        for (int i = 0; i < this.nBoxes; ++i) {
            BlackBox bb = this.openPath.get(i);
            names = names + i + ": " + bb.getName() + "   ";
        }
        return names;
    }

    public void removeAllBoxes() {
        if (!this.openPath.isEmpty()) {
            this.openPath.clear();
        }
        if (!this.segments.isEmpty()) {
            this.segments.clear();
        }
        this.nSeg = 0;
        this.checkNoMix = true;
        this.checkPath = false;
        this.nBoxes = 0;
        this.checkConsolidate = false;
        this.adcs = null;
        this.dacs = null;
        this.zeroHolds = null;
    }

    public boolean getCheckNoMix() {
        return this.checkNoMix;
    }

    @Override
    public OpenLoop copy() {
        if (this == null) {
            return null;
        }
        OpenLoop bb = new OpenLoop();
        this.copyBBvariables(bb);
        bb.nBoxes = this.nBoxes;
        bb.nSeg = this.nSeg;
        bb.checkPath = this.checkPath;
        bb.checkNoMix = this.checkNoMix;
        bb.checkConsolidate = this.checkConsolidate;
        if (this.openPath.size() == 0) {
            bb.openPath = new ArrayList();
        } else {
            for (int i = 0; i < this.openPath.size(); ++i) {
                bb.openPath.add(this.openPath.get(i).copy());
            }
        }
        if (this.segments.size() == 0) {
            bb.segments = new ArrayList();
        } else {
            int j = 0;
            for (int i = 0; i < this.nSeg; ++i) {
                Integer holdI1 = (Integer)this.segments.get(j);
                int ii = holdI1;
                bb.segments.add(new Integer(ii));
                Integer holdI2 = (Integer)this.segments.get(++j);
                ii = holdI2;
                bb.segments.add(new Integer(ii));
                String holdS = (String)this.segments.get(++j);
                bb.segments.add(holdS);
                bb.segments.add(((BlackBox)this.segments.get(++j)).copy());
                ++j;
            }
        }
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

