/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.osCmd;

import ca.mcgill.mcb.pcingola.osCmd.LineFilter;
import ca.mcgill.mcb.pcingola.osCmd.Progress;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StreamGobbler
extends Thread {
    public static int HEAD_SIZE = 100;
    public static int BUFFER_SIZE = 102400;
    InputStream is;
    boolean binary = false;
    boolean alertDone = false;
    boolean sendToStderr = false;
    boolean sendToStdout = false;
    boolean saveLinesInMemory = false;
    StringBuffer allLines = new StringBuffer();
    String alert = null;
    Object alertNotify = null;
    StringBuffer head = null;
    Progress progress = null;
    String redirectTo = null;
    BufferedReader lineInputReader = null;
    boolean running = false;
    LineFilter lineFilter;

    StreamGobbler(InputStream is, boolean stderr) {
        this.is = is;
        this.sendToStdout = !stderr;
        this.sendToStderr = stderr;
        this.allLines = new StringBuffer();
        this.head = new StringBuffer();
    }

    private void close() {
        try {
            if (this.lineInputReader != null) {
                this.lineInputReader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAlert() {
        return this.alert;
    }

    public Object getAlertNotify() {
        return this.alertNotify;
    }

    public String getAllLines() {
        return this.allLines.toString();
    }

    public String getHead() {
        return this.head.toString();
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public boolean isAlertDone() {
        return this.alertDone;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void resetBuffer() {
        this.allLines = new StringBuffer();
    }

    @Override
    public void run() {
        if (this.binary) {
            if (this.lineFilter != null) {
                throw new RuntimeException("Cannot apply line filter to binary output.");
            }
            this.runBinGobbler();
        } else {
            this.runLineGobbler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBinGobbler() {
        FileOutputStream redirectWriter = null;
        this.running = true;
        try {
            byte[] buffer = new byte[BUFFER_SIZE];
            int num = 0;
            if (this.redirectTo != null) {
                redirectWriter = new FileOutputStream(this.redirectTo);
            }
            while ((num = this.is.read(buffer)) >= 0) {
                if (redirectWriter != null) {
                    redirectWriter.write(buffer, 0, num);
                }
                if (this.progress == null) continue;
                this.progress.progress();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            this.close();
            try {
                if (redirectWriter != null) {
                    redirectWriter.close();
                }
            }
            catch (IOException ioe) {
                this.running = false;
                throw new RuntimeException(ioe);
            }
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runLineGobbler() {
        BufferedWriter redirectWriter = null;
        this.lineInputReader = new BufferedReader(new InputStreamReader(this.is));
        this.running = true;
        try {
            if (this.redirectTo != null) {
                redirectWriter = new BufferedWriter(new FileWriter(this.redirectTo));
            }
            String line = null;
            int lineNum = 0;
            while ((line = this.lineInputReader.readLine()) != null) {
                if (this.lineFilter == null || (line = this.lineFilter.filter(line)) != null) {
                    if (this.sendToStderr) {
                        System.err.println(line);
                    }
                    if (this.sendToStdout) {
                        System.out.println(line);
                    }
                    if (redirectWriter != null) {
                        redirectWriter.write(line + "\n");
                    }
                    if (this.saveLinesInMemory) {
                        this.allLines.append(line + "\n");
                    }
                    if (lineNum < HEAD_SIZE) {
                        this.head.append(line + "\n");
                    }
                    if (this.progress != null) {
                        this.progress.progress();
                    }
                    if (this.alert != null && line.indexOf(this.alert) >= 0) {
                        this.alertDone = true;
                        if (this.alertNotify != null) {
                            Object object = this.alertNotify;
                            synchronized (object) {
                                this.alertNotify.notify();
                            }
                        }
                    }
                }
                ++lineNum;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.close();
            try {
                if (redirectWriter != null) {
                    redirectWriter.close();
                }
            }
            catch (IOException ioe) {
                this.running = false;
                throw new RuntimeException(ioe);
            }
            this.running = false;
        }
    }

    public void setAlert(String alert) {
        this.alertDone = false;
        this.alert = alert;
    }

    public void setAlertNotify(Object alertNotify) {
        this.alertNotify = alertNotify;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setLineFilter(LineFilter lineFilter) {
        this.lineFilter = lineFilter;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void setQuietMode() {
        this.sendToStderr = false;
        this.sendToStdout = false;
    }

    public void setRedirectTo(String redirectTo) {
        this.redirectTo = redirectTo;
    }

    public void setSaveLinesInMemory(boolean saveLinesInMemory) {
        this.saveLinesInMemory = saveLinesInMemory;
    }
}

