/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MarkerUtil {
    public static Map<Marker, Marker> collapseZeroGap(Markers markersOri) {
        HashMap<Marker, Marker> collapse = new HashMap<Marker, Marker>();
        Markers sorted = new Markers();
        sorted.add(markersOri);
        sorted.sort(false, false);
        Interval markerPrev = null;
        Marker markerToAdd = null;
        int countCollapsed = 0;
        for (Marker m : sorted) {
            if (markerToAdd == null) {
                markerToAdd = m.clone();
            }
            if (markerPrev != null) {
                int start = markerPrev.getEnd() + 1;
                int end = m.getStart() - 1;
                int gapSize = end - start + 1;
                if (gapSize <= 0) {
                    ++countCollapsed;
                    if (markerToAdd.getEnd() < m.getEnd()) {
                        markerToAdd.setEnd(m.getEnd());
                    }
                } else {
                    markerToAdd = m.clone();
                }
            }
            collapse.put(m, markerToAdd);
            markerPrev = m;
        }
        HashSet collapsed = new HashSet();
        collapsed.addAll(collapse.values());
        if (markersOri.size() - countCollapsed != collapsed.size()) {
            throw new RuntimeException("Sanitycheck failed. This should never happen!\n\tmarkers.size: " + markersOri.size() + "\n\tcountCollapsed: " + countCollapsed + "\n\treplaced.size : " + collapsed.size());
        }
        return collapse;
    }

    public static Markers readTxt(String fileName, Genome genome, int positionBase) {
        if (genome == null) {
            genome = new Genome();
        }
        Markers markers = new Markers();
        LineFileIterator lfi = new LineFileIterator(fileName);
        int lineNum = 1;
        for (String line : lfi) {
            Marker interval = new Marker();
            interval.readTxt(line, lineNum, genome, positionBase);
            markers.add(interval);
            ++lineNum;
        }
        return markers;
    }

    public static Map<Marker, Marker> redundant(Collection<? extends Marker> markersOri) {
        HashMap<Marker, Marker> redundant = new HashMap<Marker, Marker>();
        ArrayList<? extends Marker> markers = new ArrayList<Marker>();
        markers.addAll(markersOri);
        int size = markers.size();
        for (int i = 0; i < size; ++i) {
            Marker mi = (Marker)markers.get(i);
            Marker markerLarge = null;
            for (int j = 0; j < size && markerLarge == null; ++j) {
                Marker mj = (Marker)markers.get(j);
                if (i == j || !mj.includes(mi) || mi.includes(mj) && i > j) continue;
                markerLarge = mj;
            }
            if (markerLarge == null) continue;
            redundant.put(mi, markerLarge);
        }
        return redundant;
    }
}

