/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fastq;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqTools;
import ca.mcgill.mcb.pcingola.fastq.FastqTrimmerMedian;
import java.util.Collections;
import java.util.LinkedList;

public class FastqTrimmerAdrian
extends FastqTrimmerMedian {
    public FastqTrimmerAdrian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases, runningMedianLength);
        this.minBases = minBases;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int i;
        int[] qual = FastqTools.qualtityArray(fastq);
        for (i = 0; i < qual.length - this.runningMedianLength; i += 2) {
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int k = 1; k <= this.runningMedianLength; ++k) {
                list.add(qual[i + k]);
            }
            Collections.sort(list);
            int size = list.size();
            int med = 0;
            med = list.size() % 2 == 1 ? (Integer)list.get(size / 2) : ((Integer)list.get(size / 2 - 1) + (Integer)list.get(size / 2)) / 2;
            if (med < this.qualityThreshold) break;
        }
        if ((i -= this.runningMedianLength - 1) > this.minBases) {
            return i;
        }
        return 0;
    }
}

