/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.regex;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.regex.RegexException;

class PatternChecker {
    private SymbolTokenization sToke = null;
    private Tokenizer toke = null;
    private StringBuffer output = null;
    private FiniteAlphabet alfa = null;

    PatternChecker(FiniteAlphabet alfa) {
        this.alfa = alfa;
    }

    String parse(String patternString) throws RegexException, IllegalAlphabetException {
        this.output = new StringBuffer();
        try {
            this.sToke = this.alfa.getTokenization("token");
            if (this.sToke.getTokenType() != SymbolTokenization.CHARACTER) {
                throw new IllegalAlphabetException("This alphabet does not have a character tokenization.");
            }
        }
        catch (BioException be) {
            throw new IllegalAlphabetException(be, "Attempt to get a tokenization for this alphabet failed.");
        }
        this.toke = new Tokenizer(patternString);
        this.parse();
        return this.output.toString();
    }

    void parse() throws RegexException {
        boolean gotContent = false;
        block11: while (this.toke.hasNext()) {
            int tokenType = this.toke.nextTokenType();
            switch (tokenType) {
                case 5: {
                    gotContent = true;
                    this.output.append(this.toke.getToken());
                    this.parse();
                    if (this.toke.nextTokenType() != 6) {
                        throw new RegexException("syntax error in regex: right bracket expected.");
                    }
                    this.output.append(this.toke.getToken());
                    this.parseQuantifier();
                    continue block11;
                }
                case 0: {
                    gotContent = true;
                    try {
                        this.parseSymbol();
                    }
                    catch (IllegalSymbolException ise) {
                        throw new RegexException(ise);
                    }
                    this.parseQuantifier();
                    continue block11;
                }
                case 15: {
                    gotContent = true;
                    this.output.append(this.toke.getToken());
                    this.parseQuantifier();
                    continue block11;
                }
                case 10: {
                    gotContent = true;
                    this.parseVariantSymbols();
                    this.parseQuantifier();
                    continue block11;
                }
                case 9: {
                    if (gotContent) {
                        gotContent = false;
                        this.output.append(this.toke.getToken());
                        continue block11;
                    }
                    throw new RegexException("syntax error in specifying alternate pattern.");
                }
                case -1: {
                    return;
                }
                case 6: {
                    if (gotContent) {
                        return;
                    }
                    throw new RegexException("unexpected right bracket.");
                }
            }
            throw new RegexException("unexpected symbol " + this.toke.getToken());
        }
    }

    void parseSymbol() throws IllegalSymbolException {
        while (this.toke.nextTokenType() == 0) {
            char token = this.toke.getToken();
            Symbol sym = this.sToke.parseToken(Character.toString(token));
            if (sym instanceof AtomicSymbol) {
                this.output.append(token);
                continue;
            }
            TreeSet<Symbol> sortedAmbigs = new TreeSet<Symbol>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof AtomicSymbol && o2 instanceof AtomicSymbol) {
                        try {
                            return PatternChecker.this.sToke.tokenizeSymbol((AtomicSymbol)o1).charAt(0) - PatternChecker.this.sToke.tokenizeSymbol((AtomicSymbol)o2).charAt(0);
                        }
                        catch (IllegalSymbolException ise) {
                            throw new AssertionError((Object)ise);
                        }
                    }
                    throw new ClassCastException();
                }
            });
            Iterator<Symbol> symI = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (symI.hasNext()) {
                Symbol atomicSym = symI.next();
                sortedAmbigs.add(atomicSym);
            }
            this.output.append("[");
            for (Symbol atomicSym : sortedAmbigs) {
                this.output.append(this.sToke.tokenizeSymbol(atomicSym));
            }
            this.output.append("]");
        }
    }

    void parseQuantifier() throws RegexException {
        int tokenType = this.toke.nextTokenType();
        switch (tokenType) {
            case 2: {
                this.getIterations();
                break;
            }
            case 7: {
                this.output.append(this.toke.getToken());
                break;
            }
            case 8: {
                this.output.append(this.toke.getToken());
                break;
            }
            case 12: {
                this.output.append(this.toke.getToken());
                break;
            }
        }
        if (this.toke.nextTokenType() == 12) {
            this.output.append(this.toke.getToken());
        }
    }

    void getIterations() throws RegexException {
        this.output.append(this.toke.getToken());
        int argCount = 0;
        boolean gotContent = false;
        block5: while (this.toke.hasNext()) {
            int tokenType = this.toke.nextTokenType();
            switch (tokenType) {
                case 1: {
                    if (argCount > 1) {
                        throw new RegexException("too many arguments in quantifier");
                    }
                    while (this.toke.nextTokenType() == 1) {
                        gotContent = true;
                        this.output.append(this.toke.getToken());
                    }
                    if (this.toke.nextTokenType() != -1) continue block5;
                    throw new RegexException("syntax error: unexpected EOL");
                }
                case 4: {
                    if (argCount++ != 0) {
                        throw new RegexException("too many arguments in quantifier");
                    }
                    this.output.append(this.toke.getToken());
                    continue block5;
                }
                case 3: {
                    if (argCount++ > 1) {
                        throw new RegexException("too many arguments in quantifier");
                    }
                    if (!gotContent) {
                        throw new RegexException("no arguments were actually specified!");
                    }
                    this.output.append(this.toke.getToken());
                    return;
                }
            }
            throw new RegexException("syntax error: unexpected symbol " + this.toke.getToken());
        }
    }

    void parseVariantSymbols() throws RegexException {
        this.output.append(this.toke.getToken());
        while (this.toke.nextTokenType() == 0) {
            Symbol sym;
            char token = this.toke.getToken();
            try {
                sym = this.sToke.parseToken(Character.toString(token));
            }
            catch (IllegalSymbolException ise) {
                throw new RegexException(ise);
            }
            if (sym instanceof AtomicSymbol) {
                this.output.append(token);
                continue;
            }
            throw new RegexException("all variant symbols must be atomic.");
        }
        if (this.toke.nextTokenType() != 11) {
            throw new RegexException("missing right square bracket while specifying variants. Encountered " + this.toke.getToken() + " instead.");
        }
        this.output.append(this.toke.getToken());
    }

    private static class Tokenizer {
        private String packedTxt;
        private int ptr = 0;
        static final int EOL = -1;
        static final int SYMBOL_TOKEN = 0;
        static final int NUMERIC = 1;
        static final int LEFT_BRACE = 2;
        static final int RIGHT_BRACE = 3;
        static final int COMMA = 4;
        static final int LEFT_BRACKET = 5;
        static final int RIGHT_BRACKET = 6;
        static final int PLUS = 7;
        static final int ASTERISK = 8;
        static final int VERT_BAR = 9;
        static final int LEFT_SQBRACKET = 10;
        static final int RIGHT_SQBRACKET = 11;
        static final int Q_MARK = 12;
        static final int CARET = 13;
        static final int DOLLAR = 14;
        static final int DOT = 15;
        static final int UNKNOWN = 999;

        private Tokenizer(String target) {
            this.packedTxt = this.pack(target);
        }

        private char getToken() throws IndexOutOfBoundsException {
            if (this.hasNext()) {
                return this.packedTxt.charAt(this.ptr++);
            }
            throw new IndexOutOfBoundsException("text length: " + this.packedTxt.length() + " index: " + this.ptr);
        }

        private int nextTokenType() {
            if (!this.hasNext()) {
                return -1;
            }
            char nextCh = this.packedTxt.charAt(this.ptr);
            if (Character.isLetter(nextCh)) {
                return 0;
            }
            if (Character.isDigit(nextCh)) {
                return 1;
            }
            if (nextCh == '.') {
                return 15;
            }
            if (nextCh == '{') {
                return 2;
            }
            if (nextCh == '}') {
                return 3;
            }
            if (nextCh == ',') {
                return 4;
            }
            if (nextCh == '(') {
                return 5;
            }
            if (nextCh == ')') {
                return 6;
            }
            if (nextCh == '+') {
                return 7;
            }
            if (nextCh == '*') {
                return 8;
            }
            if (nextCh == '|') {
                return 9;
            }
            if (nextCh == '[') {
                return 10;
            }
            if (nextCh == ']') {
                return 11;
            }
            if (nextCh == '?') {
                return 12;
            }
            if (nextCh == '^') {
                return 13;
            }
            if (nextCh == '$') {
                return 14;
            }
            return 999;
        }

        private boolean hasNext() {
            return this.ptr < this.packedTxt.length();
        }

        private String pack(String source) {
            StringBuffer packedString = new StringBuffer();
            for (int i = 0; i < source.length(); ++i) {
                char currCh = source.charAt(i);
                if (Character.isWhitespace(currCh)) continue;
                packedString.append(currCh);
            }
            return packedString.toString();
        }
    }
}

