/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixWriter;
import edu.mayo.pipes.history.History;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class BgzipWriter
extends AbstractPipe<History, History> {
    private String mBgzipOutFilePath;
    private BlockCompressedOutputStream mBgzipOutStream;
    private boolean mIsCreateTabix = true;
    private DataType mBgzipDataType = DataType.BIOR_CATALOG;

    public BgzipWriter(String bgzipOutFilePath, boolean isCreateTabix) {
        this.mBgzipOutFilePath = bgzipOutFilePath;
        this.mIsCreateTabix = isCreateTabix;
    }

    public BgzipWriter(String bgzipOutFilePath, boolean isCreateTabix, DataType dataType) {
        this.mBgzipOutFilePath = bgzipOutFilePath;
        this.mIsCreateTabix = isCreateTabix;
        this.mBgzipDataType = dataType;
    }

    protected History processNextStart() throws NoSuchElementException {
        try {
            History nextLine = (History)this.starts.next();
            if (this.mBgzipOutStream == null) {
                this.mBgzipOutStream = new BlockCompressedOutputStream(this.mBgzipOutFilePath, 9);
            }
            this.mBgzipOutStream.write((this.merge(nextLine) + "\n").getBytes());
            return nextLine;
        }
        catch (NoSuchElementException noSuchExc) {
            try {
                this.mBgzipOutStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchElementException("Error closing the bgzip stream: " + e.getMessage());
            }
            try {
                if (this.mIsCreateTabix) {
                    this.createTabixFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchElementException("Error creating the tabix index: " + e.getMessage());
            }
            throw new NoSuchElementException("No more data");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error writing to bgzip file");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error creating tabix file");
        }
    }

    private void createTabixFile() throws Exception {
        File bgzipOutFile = new File(this.mBgzipOutFilePath);
        TabixWriter.Conf dataType = this.getConfFromDataType(this.mBgzipDataType);
        TabixWriter tabixWriter = new TabixWriter(bgzipOutFile, dataType);
        tabixWriter.createIndex(bgzipOutFile);
    }

    private TabixWriter.Conf getConfFromDataType(DataType dataType) {
        if (dataType == null) {
            return TabixWriter.BIOR_CATALOG_CONF;
        }
        if (DataType.VCF.equals((Object)dataType)) {
            return TabixWriter.VCF_CONF;
        }
        if (DataType.BED.equals((Object)dataType)) {
            return TabixWriter.BED_CONF;
        }
        if (DataType.SAM.equals((Object)dataType)) {
            return TabixWriter.SAM_CONF;
        }
        if (DataType.GFF.equals((Object)dataType)) {
            return TabixWriter.GFF_CONF;
        }
        if (DataType.PSL_TABLE.equals((Object)dataType)) {
            return TabixWriter.PSLTBL_CONF;
        }
        return TabixWriter.BIOR_CATALOG_CONF;
    }

    private String merge(History history) {
        StringBuilder strBuilder = new StringBuilder();
        for (String col : history) {
            strBuilder.append(col + "\t");
        }
        String str = strBuilder.toString();
        if (str.endsWith("\t")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static enum DataType {
        BIOR_CATALOG,
        VCF,
        BED,
        GFF,
        SAM,
        PSL_TABLE;

    }
}

