/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util.validation;

import edu.mayo.bior.catalog.GoldenAttribute;
import edu.mayo.cli.InvalidDataException;

public class GoldenValidator {
    public static GoldenAttribute getGoldenAttribute(String goldenJsonKey) throws InvalidDataException {
        if (goldenJsonKey.equals(GoldenAttribute._landmark.name())) {
            return GoldenAttribute._landmark;
        }
        if (goldenJsonKey.equals(GoldenAttribute._minBP.name())) {
            return GoldenAttribute._minBP;
        }
        if (goldenJsonKey.equals(GoldenAttribute._maxBP.name())) {
            return GoldenAttribute._maxBP;
        }
        if (goldenJsonKey.equals(GoldenAttribute._type.name())) {
            return GoldenAttribute._type;
        }
        if (goldenJsonKey.equals(GoldenAttribute._id.name())) {
            return GoldenAttribute._id;
        }
        if (goldenJsonKey.equals(GoldenAttribute._refAllele.name())) {
            return GoldenAttribute._refAllele;
        }
        if (goldenJsonKey.equals(GoldenAttribute._altAlleles.name())) {
            return GoldenAttribute._altAlleles;
        }
        if (goldenJsonKey.equals(GoldenAttribute._strand.name())) {
            return GoldenAttribute._strand;
        }
        return null;
    }

    public static boolean isValidGolden(String inputGoldenKey) {
        for (GoldenAttribute each : GoldenAttribute.values()) {
            if (!each.name().equals(inputGoldenKey)) continue;
            return true;
        }
        return false;
    }

    public static void validateGoldenKey(String goldenJsonKey) throws InvalidDataException {
        if (!(goldenJsonKey.equals(GoldenAttribute._landmark.name()) || goldenJsonKey.equals(GoldenAttribute._minBP.name()) || goldenJsonKey.equals(GoldenAttribute._maxBP.name()) || goldenJsonKey.equals(GoldenAttribute._type.name()) || goldenJsonKey.equals(GoldenAttribute._id.name()) || goldenJsonKey.equals(GoldenAttribute._refAllele.name()) || goldenJsonKey.equals(GoldenAttribute._altAlleles.name()) || goldenJsonKey.equals(GoldenAttribute._strand.name()))) {
            throw new InvalidDataException("Not a valid BioR golden attribute name: " + goldenJsonKey);
        }
    }

    public static void validateDataType(String goldenJsonKey, String dataType) throws InvalidDataException {
        GoldenAttribute goldenKey = GoldenValidator.getGoldenAttribute(goldenJsonKey);
        GoldenValidator.validateDataType(goldenKey, dataType);
    }

    public static void validateDataType(GoldenAttribute goldenJsonKey, String dataType) throws InvalidDataException {
        String dType = dataType.toUpperCase();
        switch (goldenJsonKey) {
            case _landmark: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttribute._landmark.name() + " golden attribute must be of type String.");
            }
            case _minBP: {
                if (dType.equals("INTEGER") || dType.equals("NUMBER")) break;
                throw new InvalidDataException(GoldenAttribute._minBP.name() + " golden attribute must be of type JsonType Number or Integer.");
            }
            case _maxBP: {
                if (dType.equals("INTEGER") || dType.equals("NUMBER")) break;
                throw new InvalidDataException(GoldenAttribute._maxBP.name() + " golden attribute must be of type JsonType Number or Integer.");
            }
            case _altAlleles: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttribute._altAlleles.name() + " golden attribute must be of type String.");
            }
            case _refAllele: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttribute._refAllele.name() + " golden attribute must be of type String.");
            }
            case _id: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttribute._refAllele.name() + " golden attribute must be of type String.");
            }
            case _type: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttribute._refAllele.name() + " golden attribute must be of type String.");
            }
            case _strand: {
                if (dType.equals("STRING")) break;
                throw new InvalidDataException(GoldenAttribute._refAllele.name() + " golden attribute must be of type String.");
            }
        }
    }
}

