/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.catalogvalidator.CatalogEntryGoldenJson;
import edu.mayo.bior.catalogvalidator.CatalogTabixEntry;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.UniqOrderedMessageLogger;
import edu.mayo.bior.catalogvalidator.VerifyCatalogUtils;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.lf5.LogLevel;

public class WholeCatalogValidationThread
extends Thread
implements Runnable {
    private String mCatFileNm = null;
    private List<String> mExpectChrOrder = null;
    private TreeMap<String, String> mBIORIndexMap_ColNameToFilePath = null;
    private boolean mIsPositionalCatalog = false;
    private UniqOrderedMessageLogger uniqLogger = new UniqOrderedMessageLogger();
    private BufferedWriter mlogfileWriter = null;
    public String NL = "\n";
    public final String DBL_QUOTE = "\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.mExpectChrOrder == null || this.mExpectChrOrder.size() <= 0) {
            this.uniqLogger.logMessage("The catalog is positional but no chromosome order file was configured. Cannot run whole-file, order-checking thread to verify catalog order. Exiting order-checking without doing the catalog order checking.", LogLevel.WARNING);
            return;
        }
        if (!this.isPositionalCatalog()) {
            this.uniqLogger.logMessage("The whole-file, order-checking thread was not started with the 'isPositional' flag set to true. Exiting order-checking without doing the catalog order checking.", LogLevel.WARNING);
            return;
        }
        this.uniqLogger.logMessage("Whole-catalog order checking: Starting catalog order & indexing checks. Date: " + new SimpleDateFormat("MM.dd.yyyy 'at' HH:mm:ss z").format(Calendar.getInstance().getTime()), LogLevel.INFO);
        Set<Object> biorIndexEntrySet = new TreeSet();
        TreeMap<String, CatalogTabixEntry> lastRowWithThisBiorIndexValue = new TreeMap<String, CatalogTabixEntry>();
        if (this.getBiorIndexMap() != null) {
            biorIndexEntrySet = this.getBiorIndexMap().entrySet();
            for (String key : this.getBiorIndexMap().keySet()) {
                lastRowWithThisBiorIndexValue.put(key, null);
            }
        }
        ArrayList<String> catalogChrList_Seen = new ArrayList<String>();
        BufferedReader catalogRdr = null;
        TabixReader tabixReader = null;
        CatalogTabixEntry previousRowTabixEntry = null;
        try {
            catalogRdr = FileUtils.getBufferedReader(this.mCatFileNm);
            try {
                tabixReader = new TabixReader(this.mCatFileNm);
            }
            catch (IOException io) {
                throw new IOException("Exception instantiating a Tabix reader for catalog: " + this.mCatFileNm + " Exception: " + io.getMessage());
            }
            String l = null;
            int lineReadCount = 0;
            int linePocessedCount = 0;
            while ((l = catalogRdr.readLine()) != null) {
                CatalogTabixEntry currentRowTabixEntry;
                if (++lineReadCount % 1000000 == 0) {
                    // empty if block
                }
                if ((currentRowTabixEntry = VerifyCatalogUtils.readCatalogRow(l, this.uniqLogger)) == null) {
                    this.uniqLogger.logMessage("Whole-catalog order checking: Could not read in catalog row as valid Tabix Entry: line: " + l, LogLevel.ERROR);
                    continue;
                }
                if (previousRowTabixEntry == null) {
                    catalogChrList_Seen.add(currentRowTabixEntry.getChromosome());
                    previousRowTabixEntry = currentRowTabixEntry;
                    continue;
                }
                for (String string : lastRowWithThisBiorIndexValue.keySet()) {
                    if (!currentRowTabixEntry.getJsonString().contains("\"" + string + "\"" + ":")) continue;
                    lastRowWithThisBiorIndexValue.put(string, currentRowTabixEntry);
                }
                if (this.isPositionalCatalog() && currentRowTabixEntry.isPositional()) {
                    if (previousRowTabixEntry.getChromosome().equals(currentRowTabixEntry.getChromosome())) {
                        CatalogEntryGoldenJson catalogEntryGoldenJson;
                        CatalogEntryGoldenJson currentRowGolden;
                        if (previousRowTabixEntry.getMinPosition() > currentRowTabixEntry.getMinPosition()) {
                            this.uniqLogger.logMessage("Whole-catalog order checking: Previous position [" + previousRowTabixEntry.getMinPosition() + "] within chromosome is greater than current row position [" + currentRowTabixEntry.getMinPosition() + "]. tabix catalog line: " + l, LogLevel.ERROR);
                        }
                        if ((currentRowGolden = VerifyCatalogUtils.getGoldenJsonVariant(VerifyCatalogUtils.getJsonObject(currentRowTabixEntry.getJsonString()))).equals(catalogEntryGoldenJson = VerifyCatalogUtils.getGoldenJsonVariant(VerifyCatalogUtils.getJsonObject(previousRowTabixEntry.getJsonString())))) {
                            this.uniqLogger.logMessage("Whole-catalog order checking: Previous variant [ _landmark:" + catalogEntryGoldenJson.getChr() + " _minBP:" + currentRowGolden.getMinBP() + "] and current variant [ _landmark:" + currentRowGolden.getChr() + " _minBP:" + currentRowGolden.getMinBP() + "] catalog rows are equal, and should not be.", LogLevel.ERROR);
                        }
                    } else {
                        boolean matchFirstEntry_NextChr;
                        if (catalogChrList_Seen.contains(currentRowTabixEntry.getChromosome())) {
                            this.uniqLogger.logMessage("Whole-catalog order checking: Already saw this chr [" + currentRowTabixEntry.getChromosome() + "] in previous block of catalog. Line: " + l, LogLevel.ERROR);
                        } else {
                            catalogChrList_Seen.add(currentRowTabixEntry.getChromosome());
                        }
                        int currentLnChrIdx = this.mExpectChrOrder.indexOf(currentRowTabixEntry.getChromosome());
                        int n = this.mExpectChrOrder.indexOf(previousRowTabixEntry.getChromosome());
                        if (n > currentLnChrIdx) {
                            this.uniqLogger.logMessage("Whole-catalog order checking: Current catalog entry for chromosome [" + currentRowTabixEntry.getChromosome() + "] not in expected chromosome order. Previous chromosome catalog entries were for chromosome [" + this.mExpectChrOrder.get(n) + "], but the current catalog entry is for chromosome [" + this.mExpectChrOrder.get(currentLnChrIdx) + "]. Full Catalog Entry is: " + l, LogLevel.ERROR);
                        } else if (n >= currentLnChrIdx && currentLnChrIdx == n) {
                            throw new RuntimeException("Whole-catalog order checking: ERROR: Unexpected code-path reached: Previous chr index in list [" + n + "] equal to current chr index in list [" + currentLnChrIdx + "]. Should NOT find this condition. Line: " + l);
                        }
                        boolean matchLastEntry_PrevChr = VerifyCatalogUtils.isTabixRetrievalSuccessful(tabixReader, previousRowTabixEntry, TABIX_QUERY_ORDER.LAST_ELEM_IN_RESULT);
                        if (!matchLastEntry_PrevChr) {
                            this.uniqLogger.logMessage("Whole-catalog order checking: Failed to retrieve Tabix entry for last line of previous chromosome. Line: " + previousRowTabixEntry.getCatalogTabixLine(), LogLevel.ERROR);
                        }
                        if (!(matchFirstEntry_NextChr = VerifyCatalogUtils.isTabixRetrievalSuccessful(tabixReader, currentRowTabixEntry, TABIX_QUERY_ORDER.FIRST_ELEM_IN_RESULT))) {
                            this.uniqLogger.logMessage("Whole-catalog order checking: Failed to retrieve Tabix entry for first line of new/next chromosome. Line: " + currentRowTabixEntry.getCatalogTabixLine(), LogLevel.ERROR);
                        }
                        for (Map.Entry entry : biorIndexEntrySet) {
                            this.checkBiorIndexes((String)entry.getKey(), (String)entry.getValue(), previousRowTabixEntry, currentRowTabixEntry, lastRowWithThisBiorIndexValue);
                        }
                    }
                    ++linePocessedCount;
                }
                previousRowTabixEntry = currentRowTabixEntry;
            }
            if (previousRowTabixEntry != null && previousRowTabixEntry.isPositional()) {
                boolean match_PrevChr = VerifyCatalogUtils.isTabixRetrievalSuccessful(tabixReader, previousRowTabixEntry, TABIX_QUERY_ORDER.LAST_ELEM_IN_RESULT);
                if (!match_PrevChr) {
                    this.uniqLogger.logMessage("Whole-catalog order checking: Failed to retrieve Tabix entry for last line of file. Line: " + previousRowTabixEntry.getCatalogTabixLine(), LogLevel.ERROR);
                }
                for (Map.Entry entry : biorIndexEntrySet) {
                    this.checkBiorIndexes((String)entry.getKey(), (String)entry.getValue(), previousRowTabixEntry, null, lastRowWithThisBiorIndexValue);
                }
                ++linePocessedCount;
            }
            this.uniqLogger.logMessage("Whole-catalog order checking: Completed catalog order & indexing checks. Date: " + new SimpleDateFormat("MM.dd.yyyy 'at' HH:mm:ss z").format(Calendar.getInstance().getTime()), LogLevel.INFO);
            this.uniqLogger.logMessage("Whole-catalog order checking: Order in which chromosomes seen within the catalog: " + catalogChrList_Seen, LogLevel.INFO);
            this.uniqLogger.logMessage("Whole-catalog order checking: Number of lines read within the catalog: " + lineReadCount, LogLevel.INFO);
            this.uniqLogger.logMessage("Whole-catalog order checking: Number of lines processed within the catalog: " + linePocessedCount, LogLevel.INFO);
            if (this.mlogfileWriter == null) {
                this.mlogfileWriter = new BufferedWriter(new FileWriter(new File(new File(".").getAbsolutePath(), "wholeCatalogOrderChecking_log.txt")));
            }
            this.getLogger().writeOrderedMessages(this.mlogfileWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception WholeCatalogValidationThread.run(): exception: " + e.getMessage());
        }
    }

    public boolean areErrorsLogged() {
        return this.uniqLogger.areErrorsLogged();
    }

    private void checkBiorIndexes(String biorIndexName, String biorIndexFileName, CatalogTabixEntry previousRowTabixEntry, CatalogTabixEntry currentRowTabixEntry, TreeMap<String, CatalogTabixEntry> lastRowWithThisBiorIndex) {
        try {
            String keystr = "\"" + biorIndexName + "\"" + ":";
            CatalogTabixEntry catEntryToUse = null;
            if (previousRowTabixEntry.getJsonString().contains(keystr)) {
                catEntryToUse = previousRowTabixEntry;
            } else {
                CatalogTabixEntry recordWithKeyLastSeen = lastRowWithThisBiorIndex.get(biorIndexName);
                if (recordWithKeyLastSeen != null) {
                    catEntryToUse = recordWithKeyLastSeen;
                }
            }
            boolean matched_lastIDOnPrevChr = this.isBiorIndexRetrievalSuccessful(new File(this.getCatalogFileName()), new File(biorIndexFileName), biorIndexName, catEntryToUse);
            if (!matched_lastIDOnPrevChr) {
                this.uniqLogger.logMessage("Whole-catalog order checking: Failed to retrieve BIOR Index entry for last line of previous chromosome for key " + biorIndexName + ". Line: " + previousRowTabixEntry.getCatalogTabixLine(), LogLevel.ERROR);
            }
            if (currentRowTabixEntry == null) {
                return;
            }
            catEntryToUse = null;
            if (currentRowTabixEntry.getJsonString().contains(keystr)) {
                catEntryToUse = currentRowTabixEntry;
            } else {
                CatalogTabixEntry recordWithKeyLastSeen = lastRowWithThisBiorIndex.get(biorIndexName);
                if (recordWithKeyLastSeen != null) {
                    catEntryToUse = recordWithKeyLastSeen;
                }
            }
            boolean matched_firstIDOnThisChr = this.isBiorIndexRetrievalSuccessful(new File(this.getCatalogFileName()), new File(biorIndexFileName), biorIndexName, catEntryToUse);
            if (!matched_firstIDOnThisChr) {
                this.uniqLogger.logMessage("Whole-catalog order checking: Failed to retrieve BIOR Index entry for first line of new/next chromosome for key " + biorIndexName + ". Line: " + currentRowTabixEntry.getCatalogTabixLine(), LogLevel.ERROR);
            }
        }
        catch (Exception e) {
            this.uniqLogger.logMessage("Whole-catalog order checking: Exception raised while trying to check BIOR index: " + biorIndexName + " and chromosomes: " + previousRowTabixEntry.getChromosome() + " and " + currentRowTabixEntry.getChromosome(), LogLevel.ERROR);
        }
    }

    private boolean isBiorIndexRetrievalSuccessful(File catalogFile, File biorIndexFile, String indexedColumnName, CatalogTabixEntry sourceTabix) throws Exception {
        JsonParser jp = new JsonParser();
        JsonElement catalogRowJsonElem = jp.parse(sourceTabix.getJsonString());
        JsonObject catalogRowJsonObj = catalogRowJsonElem.getAsJsonObject();
        catalogRowJsonElem = catalogRowJsonObj.get(indexedColumnName);
        Object valueForIndexedKey = VerifyCatalogUtils.getJsonValueForJsonKey(catalogRowJsonObj, indexedColumnName, null);
        if (valueForIndexedKey == null) {
            this.uniqLogger.logMessage("Whole-catalog order checking: WARNING: isBiorIndexRetrievalSuccessful(): value for indexed key [" + indexedColumnName + "] is null for catalog json: " + sourceTabix.getJsonString(), LogLevel.WARNING);
            return false;
        }
        String catalog = catalogFile.getCanonicalPath();
        String index = biorIndexFile.getCanonicalPath();
        Metadata md = new Metadata(catalog, "bior_lookup");
        Pipeline p = new Pipeline(new Pipe[]{new HistoryInPipe(md), new LookupPipe(catalog, index), new HistoryOutPipe()});
        p.setStarts(Arrays.asList(valueForIndexedKey.toString()));
        ArrayList<String> matches = new ArrayList<String>();
        int i = 0;
        while (p.hasNext()) {
            String out = (String)p.next();
            String[] elems = out.split("\t");
            if (!out.startsWith("#") && elems.length == 2) {
                String out_indexedColumnValue = elems[0];
                if (valueForIndexedKey.toString().equals(out_indexedColumnValue)) {
                    String out_jsonOutput = elems[1];
                    if (sourceTabix.getJsonString().equals(out_jsonOutput)) {
                        matches.add(out);
                    }
                }
            }
            ++i;
        }
        if (matches.size() == 0) {
            return false;
        }
        this.uniqLogger.logMessage("Whole-catalog order checking: BIOR Lookup for chromosome [" + sourceTabix.getChromosome() + "] and BIOR index name: [" + indexedColumnName + "] matches are: " + ((Object)matches).toString(), LogLevel.INFO);
        if (matches.size() == 1) {
            return true;
        }
        if (matches.size() > 1) {
            this.uniqLogger.logMessage("Whole-catalog order checking: WARNING: BIOR index lookup on key [" + indexedColumnName + "] value [" + valueForIndexedKey + "] produced more than one row of output. Results are: " + ((Object)matches).toString(), LogLevel.WARNING);
            return true;
        }
        return false;
    }

    protected TreeMap<String, String> getBiorIndexMap() {
        return this.mBIORIndexMap_ColNameToFilePath;
    }

    protected void setBiorIndexMap(TreeMap<String, String> biorIndexMap) {
        this.mBIORIndexMap_ColNameToFilePath = biorIndexMap;
    }

    protected String getCatalogFileName() {
        return this.mCatFileNm;
    }

    protected void setCatalogFileName(String catalogFileName) {
        this.mCatFileNm = catalogFileName;
    }

    protected void setExpectedChrOrderList(List<String> expectedChrOrder) {
        this.mExpectChrOrder = expectedChrOrder;
    }

    protected UniqOrderedMessageLogger getLogger() {
        return this.uniqLogger;
    }

    protected void setLogWriter(BufferedWriter logfileWtr) {
        this.mlogfileWriter = logfileWtr;
    }

    protected boolean isPositionalCatalog() {
        return this.mIsPositionalCatalog;
    }

    protected void setPositionalCatalogIndicator(boolean isPositionalCatalog) {
        this.mIsPositionalCatalog = isPositionalCatalog;
    }

    public static enum TABIX_QUERY_ORDER {
        FIRST_ELEM_IN_RESULT,
        LAST_ELEM_IN_RESULT;

    }
}

