/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import edu.mayo.bior.catalogvalidator.VerifierExecutionException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SeqLookup {
    private static final String FASTA_HEADER_PREFIX = ">";
    private static final String CHR_PREFIX = "chr";
    private Map<String, Integer> chromSizeMap = new HashMap<String, Integer>();
    private Map<String, StringBuilder> mChromStringMap = new HashMap<String, StringBuilder>();
    private String mChromosomeSequenceLoaded = null;

    public SeqLookup(String chrRefSeqToLoad, String fastaFilename, String chromSizeFilename) throws Exception {
        this.readInChromSizeMap(chromSizeFilename);
        if (!this.readFasta(chrRefSeqToLoad, fastaFilename)) {
            throw new IOException("SeqLooking constructor: unable to read in sequence for chr requestiong: " + chrRefSeqToLoad);
        }
        this.mChromosomeSequenceLoaded = chrRefSeqToLoad;
    }

    public SeqLookup(String chrRefSeqToLoad, String fastaFilename, Map<String, Integer> chromSizeMap) throws Exception {
        this.chromSizeMap = chromSizeMap;
        if (!this.readFasta(chrRefSeqToLoad, fastaFilename)) {
            throw new IOException("SeqLooking constructor: unable to read in sequence for chr requestiong: " + chrRefSeqToLoad);
        }
        this.mChromosomeSequenceLoaded = chrRefSeqToLoad;
    }

    public String getChrSequenceLoaded() {
        return this.mChromosomeSequenceLoaded;
    }

    public String lookup(int minBP, int maxBP) throws VerifierExecutionException {
        StringBuilder strForChr = this.mChromStringMap.get(this.mChromosomeSequenceLoaded);
        if (strForChr == null) {
            return null;
        }
        return strForChr.substring(minBP - 1, maxBP);
    }

    private void readInChromSizeMap(String chromSizeFilename) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(chromSizeFilename));
        while ((line = reader.readLine()) != null) {
            if (line.trim() == "") continue;
            String[] fields = line.split("\t");
            if (fields.length != 2) {
                throw new IOException("Bad format for '" + line + "'. Expected 2 fields separated by TAB");
            }
            String chr = fields[0].replace(CHR_PREFIX, "");
            String sizeAsStr = fields[1];
            Integer size = null;
            try {
                size = new Integer(sizeAsStr);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad format for '" + line + "'. Expected second field to be an integer");
            }
            this.chromSizeMap.put(chr, size);
        }
    }

    private boolean readFasta(String chrRefSeqToLoad, String fastaFilename) throws IOException {
        BufferedReader reader = null;
        String chrReading = null;
        StringBuilder chrStr = new StringBuilder();
        try {
            String line;
            reader = new BufferedReader(new FileReader(fastaFilename));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(FASTA_HEADER_PREFIX)) {
                    chrReading = this.parseChromosomeFromFastaHeader(line);
                    if (!chrReading.equals(chrRefSeqToLoad)) continue;
                    System.out.println("Found chromosome FASTA header for our chr " + chrRefSeqToLoad + " header: " + line);
                    Integer length = this.chromSizeMap.get(chrReading);
                    if (length == null) {
                        boolean bl = false;
                        return bl;
                    }
                    chrStr = new StringBuilder(length);
                    this.mChromStringMap.put(chrReading, chrStr);
                    continue;
                }
                if (chrReading == null || !chrReading.equals(chrRefSeqToLoad)) continue;
                chrStr.append(line.trim());
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            throw new IOException("Error reading reference sequence file: " + io.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        StringBuilder strForChr = this.mChromStringMap.get(chrRefSeqToLoad);
        Integer length = this.chromSizeMap.get(chrRefSeqToLoad);
        if (strForChr == null) {
            System.err.println("Unable to get stored sequenced for chromosome: " + chrRefSeqToLoad);
            return false;
        }
        if (length == null) {
            System.err.println("Unable to get stored chr size for chromosome: " + chrRefSeqToLoad);
            return false;
        }
        if (strForChr.length() != length.intValue()) {
            System.err.println("WARNING: Chromosome [" + chrRefSeqToLoad + "]: Length given by file: " + length + " does not match length of string " + "read by fasta file: " + strForChr.length());
            return false;
        }
        System.out.println("Loaded reference sequence for chromosome [" + chrRefSeqToLoad + "]. Reference sequence length: " + length);
        return true;
    }

    private String parseChromosomeFromFastaHeader(String line) throws IOException {
        String[] fields = line.split("\\s+");
        if (!fields[0].startsWith(FASTA_HEADER_PREFIX)) {
            throw new IOException("Bad format for '" + line + "'. Expected it to start with " + FASTA_HEADER_PREFIX);
        }
        return fields[0].replace(FASTA_HEADER_PREFIX, "").replace(CHR_PREFIX, "");
    }
}

