/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.MergeColumnsTsv;
import edu.mayo.bior.buildcatalog.MergeDataSourceProperties;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.pipeline.exception.CatalogMetadataInputException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;

public class MergeMetadataStep
implements BuildCatalogStepInterface {
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private File mCatalogDir;
    private File mPreviousCatalogFile;

    public MergeMetadataStep(BuildInfo buildInfo, StepLogger logger) throws IOException {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = logger;
        this.mCatalogDir = new File(buildInfo.getTargetDirectory());
        this.mPreviousCatalogFile = null;
        if (buildInfo.getPreviousCatalogPath() != null && buildInfo.getPreviousCatalogPath().trim().length() > 0) {
            this.mPreviousCatalogFile = new File(buildInfo.getPreviousCatalogPath());
            this.checkPreviousCatalogValue(this.mPreviousCatalogFile);
        }
    }

    @Override
    public void execute() throws BuildCatalogStepExecuteException {
        try {
            this.mergeColumnsTsv();
            this.mergeDataSourceProperties();
            this.mergeBlacklist(this.mCatalogDir, this.mBuildInfo.getCatalogPrefix(), this.getBlacklistFromCatalog(this.mPreviousCatalogFile));
            this.mergeBlacklistForBiorWeb(this.mCatalogDir, this.mBuildInfo.getCatalogPrefix(), this.getBlacklistBiorwebFromCatalog(this.mPreviousCatalogFile));
        }
        catch (Exception e) {
            throw new BuildCatalogStepExecuteException(e);
        }
    }

    private void mergeDataSourceProperties() throws IOException, ConfigurationException {
        MergeDataSourceProperties mergeProps = new MergeDataSourceProperties(this.mCatalogDir, this.mBuildInfo.getCatalogPrefix(), this.getDataSourcePropertiesFromCatalog(this.mPreviousCatalogFile), this.mStepLogger);
        mergeProps.mergeDatasourceProperties();
    }

    private void mergeColumnsTsv() throws IOException, CatalogMetadataInputException {
        MergeColumnsTsv mergeCols = new MergeColumnsTsv(this.mCatalogDir, this.mBuildInfo.getCatalogPrefix(), this.getColumnsTsvFromCatalog(this.mPreviousCatalogFile), this.mStepLogger);
        mergeCols.mergeColumnsTsv();
    }

    private File getColumnsTsvFromCatalog(File prevCatalogFile) {
        if (prevCatalogFile == null) {
            return null;
        }
        return new File(prevCatalogFile.getParentFile(), prevCatalogFile.getName().replace(".tsv.bgz", ".columns.tsv"));
    }

    private File getDataSourcePropertiesFromCatalog(File prevCatalogFile) {
        if (prevCatalogFile == null) {
            return null;
        }
        return new File(prevCatalogFile.getParentFile(), prevCatalogFile.getName().replace(".tsv.bgz", ".datasource.properties"));
    }

    private File getBlacklistFromCatalog(File prevCatalogFile) {
        if (prevCatalogFile == null) {
            return null;
        }
        return new File(prevCatalogFile.getParentFile(), prevCatalogFile.getName().replace(".tsv.bgz", ".blacklist"));
    }

    private File getBlacklistBiorwebFromCatalog(File prevCatalogFile) {
        if (prevCatalogFile == null) {
            return null;
        }
        return new File(prevCatalogFile.getParentFile(), prevCatalogFile.getName().replace(".tsv.bgz", ".blacklist.biorweb"));
    }

    private void mergeBlacklist(File catalogDir, String catalogPrefix, File prevCtgBlacklistFile) throws IOException {
        File currentBlacklist = new File(catalogDir, catalogPrefix + ".blacklist");
        if (currentBlacklist.exists()) {
            this.mStepLogger.logAndSummary("Current blacklist file exists, so this will remain untouched.");
            return;
        }
        if (prevCtgBlacklistFile != null && prevCtgBlacklistFile.exists()) {
            this.mStepLogger.logAndSummary("Previous catalog blacklist file exists, while the current one does not.  Copying previous blacklist file to current.");
            FileUtils.copyFile((File)prevCtgBlacklistFile, (File)currentBlacklist);
            return;
        }
        File defaultBlacklistFile = new File(this.mCatalogDir.getCanonicalPath() + "/.build", catalogPrefix + ".blacklist");
        if (defaultBlacklistFile.exists()) {
            this.mStepLogger.logAndSummary("The default blacklist file exists, while the current one and previous catalog's blacklist files do not.  Copying default blacklist file to current.");
            FileUtils.copyFile((File)defaultBlacklistFile, (File)currentBlacklist);
            return;
        }
    }

    private void mergeBlacklistForBiorWeb(File catalogDir, String catalogPrefix, File prevCtgBlacklistBiorwebFile) throws IOException {
        File currentBlacklistBiorweb = new File(catalogDir, catalogPrefix + ".blacklist.biorweb");
        if (currentBlacklistBiorweb.exists()) {
            this.mStepLogger.logAndSummary("Current blacklist BioRWeb file exists, so this will remain untouched.");
            return;
        }
        if (prevCtgBlacklistBiorwebFile != null && prevCtgBlacklistBiorwebFile.exists()) {
            this.mStepLogger.logAndSummary("Previous catalog blacklist BioRWeb file exists, while the current one does not.  Copying previous blacklist BioRWeb file to current.");
            FileUtils.copyFile((File)prevCtgBlacklistBiorwebFile, (File)currentBlacklistBiorweb);
            return;
        }
        File defaultBlacklistBioRWebFile = new File(this.mCatalogDir.getCanonicalPath() + "/.build", catalogPrefix + ".blacklist.biorweb");
        if (defaultBlacklistBioRWebFile.exists()) {
            this.mStepLogger.logAndSummary("The default blacklist BioRWeb file exists, while the current one and previous catalog's blacklist BioRWeb files do not.  Copying default blacklist file to current.");
            FileUtils.copyFile((File)defaultBlacklistBioRWebFile, (File)currentBlacklistBiorweb);
            return;
        }
    }

    private void checkPreviousCatalogValue(File previousCatalogFile) throws IOException {
        String prevCatalogFilePath = this.mBuildInfo.getPreviousCatalogPath();
        if (!previousCatalogFile.canRead()) {
            throw new IOException(BuildInfoKey.PREVIOUS_CATALOG_PATH.name() + " property value is not a valid readable catalog file: " + prevCatalogFilePath);
        }
        if (!(this.getDataSourcePropertiesFromCatalog(previousCatalogFile).canRead() || this.getColumnsTsvFromCatalog(previousCatalogFile).canRead() || this.getBlacklistFromCatalog(previousCatalogFile).canRead() || this.getBlacklistBiorwebFromCatalog(previousCatalogFile).canRead())) {
            throw new IOException("The catalog specified in the " + BuildInfoKey.PREVIOUS_CATALOG_PATH.name() + " property value does not have at least one of the associated property files to be merged, or they are not readable. Ensure at least one of these exist and are readable, or remove this value from the build information file.");
        }
    }
}

