/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.pipeline.exception.CatalogMetadataInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class MergeColumnsTsv {
    private File mCatalogDir;
    private String mCatalogShortName;
    private File mPreviousCatalogColumnsTsv;
    private StepLogger mStepLogger;

    public MergeColumnsTsv(File catalogDir, String catalogShortName, File previousCatalogColumnsTsv, StepLogger stepLogger) {
        this.mCatalogDir = catalogDir;
        this.mCatalogShortName = catalogShortName;
        this.mPreviousCatalogColumnsTsv = previousCatalogColumnsTsv;
        this.mStepLogger = stepLogger;
    }

    public void mergeColumnsTsv() throws IOException, CatalogMetadataInputException {
        File currentColumnsFile = new File(this.mCatalogDir, this.mCatalogShortName + ".columns.tsv");
        File defaultColumnsFile = new File(this.mCatalogDir.getCanonicalPath() + "/.build", this.mCatalogShortName + ".columns.tsv.default");
        ColumnMetaDataOperations colMetaOps = new ColumnMetaDataOperations();
        HashMap currentColInfo = colMetaOps.load(currentColumnsFile.getCanonicalPath());
        HashMap defaultColInfo = colMetaOps.load(defaultColumnsFile.getCanonicalPath());
        HashMap prevCtgColInfo = new HashMap();
        if (this.mPreviousCatalogColumnsTsv != null && this.mPreviousCatalogColumnsTsv.exists()) {
            prevCtgColInfo = colMetaOps.load(this.mPreviousCatalogColumnsTsv.getCanonicalPath());
        }
        ArrayList<String> defaultColNames = new ArrayList<String>(defaultColInfo.keySet());
        ArrayList<String> prevCtgColNames = new ArrayList<String>(prevCtgColInfo.keySet());
        MergeColumnsTsv.backupCurrentFile(currentColumnsFile);
        ArrayList<ColumnMetaData> colMetaList = new ArrayList<ColumnMetaData>();
        for (String colKey : currentColInfo.keySet()) {
            colMetaList.add(this.mergeColumn(colKey, currentColInfo, defaultColInfo, prevCtgColInfo));
            if (defaultColInfo.get(colKey) == null) {
                this.mStepLogger.logAndSummary("WARNING: Extra key?  '" + colKey + "' is in the current columns.tsv, but not in columns.tsv.defaults.");
            }
            if (defaultColInfo.get(colKey) == null && this.mPreviousCatalogColumnsTsv != null) {
                this.mStepLogger.logAndSummary("WARNING: Extra key?  '" + colKey + "' is in the current columns.tsv, but not in the previous catalog's columns.tsv.");
            }
            defaultColNames.remove(colKey);
            prevCtgColNames.remove(colKey);
        }
        this.logAnyExtraDefaultColumns(defaultColNames);
        this.logAnyExtraPreviousColumns(prevCtgColNames);
        this.save(currentColumnsFile, colMetaList, colMetaOps);
        this.mStepLogger.logAndSummary("Columns merged and saved to file: " + currentColumnsFile.getCanonicalPath());
    }

    private void logAnyExtraPreviousColumns(List<String> prevCtgColNames) {
        if (prevCtgColNames.size() > 0) {
            String msg = "Warning: These columns were present in the previous catalog's columns.tsv but not in the current columns.tsv:";
            this.mStepLogger.logAndSummary(msg);
            for (String colName : prevCtgColNames) {
                this.mStepLogger.logAndSummary("    " + colName);
            }
        }
    }

    private void logAnyExtraDefaultColumns(List<String> defaultColNames) {
        if (defaultColNames.size() > 0) {
            String msg = "Warning: Some columns were present in the default columns.tsv but not in the current columns.tsv.";
            System.err.println(msg);
            this.mStepLogger.logAndSummary(msg);
            for (String colName : defaultColNames) {
                this.mStepLogger.logAndSummary("    " + colName);
                System.err.println("    " + colName);
            }
        }
    }

    private void save(File currentColumnsFile, List<ColumnMetaData> colMetaList, ColumnMetaDataOperations colMetaOps) throws IOException {
        colMetaOps.save(currentColumnsFile.getCanonicalPath(), colMetaList, true);
        if (MergeColumnsTsv.isCurrentSameAsLastBackup(currentColumnsFile)) {
            this.mStepLogger.logAndSummary("No updates necessary to columns tsv.");
            MergeColumnsTsv.removeLastBackup(currentColumnsFile);
        }
    }

    private ColumnMetaData mergeColumn(String colName, HashMap<String, ColumnMetaData> currentColInfo, HashMap<String, ColumnMetaData> defaultColInfo, HashMap<String, ColumnMetaData> prevCtgColInfo) {
        ColumnMetaData colMeta = new ColumnMetaData(colName);
        ColumnMetaData currentColMeta = currentColInfo.get(colName);
        ColumnMetaData defaultColMeta = defaultColInfo.get(colName);
        ColumnMetaData prevCtgColMeta = prevCtgColInfo.get(colName);
        ColumnMetaData.Type currentType = ColumnMetaData.Type.valueOf((String)this.getValue(colName, ColumnMetaData.Headers.Type, currentColInfo));
        colMeta.setType(currentType);
        this.checkCurrentVsOthers(colName, ColumnMetaData.Headers.Type, currentColMeta, defaultColMeta, prevCtgColMeta);
        String currentCount = this.getValue(ColumnMetaData.Headers.Count, currentColMeta);
        colMeta.setCount(currentCount);
        this.checkCurrentVsOthers(colName, ColumnMetaData.Headers.Count, currentColMeta, defaultColMeta, prevCtgColMeta);
        colMeta.setDescription(this.getBestDescription(currentColMeta, defaultColMeta, prevCtgColMeta));
        colMeta.setHumanReadableName(this.getBestHumanReadableName(currentColMeta, defaultColMeta, prevCtgColMeta));
        return colMeta;
    }

    private String getBestDescription(ColumnMetaData currentColMeta, ColumnMetaData defaultColMeta, ColumnMetaData prevCtgColMeta) {
        String currentDescription = this.getValue(ColumnMetaData.Headers.Description, currentColMeta);
        String defaultDescription = this.getValue(ColumnMetaData.Headers.Description, defaultColMeta);
        String prevCtgDescription = this.getValue(ColumnMetaData.Headers.Description, prevCtgColMeta);
        if (this.isGiven(currentDescription)) {
            return currentDescription;
        }
        if (this.isGiven(prevCtgDescription)) {
            return prevCtgDescription;
        }
        if (this.isGiven(defaultDescription)) {
            return defaultDescription;
        }
        return "";
    }

    private String getBestHumanReadableName(ColumnMetaData currentColMeta, ColumnMetaData defaultColMeta, ColumnMetaData prevCtgColMeta) {
        String currentHumanReadableName = this.getValue(ColumnMetaData.Headers.HumanReadableName, currentColMeta);
        String defaultHumanReadableName = this.getValue(ColumnMetaData.Headers.HumanReadableName, defaultColMeta);
        String prevCtgHumanReadableName = this.getValue(ColumnMetaData.Headers.HumanReadableName, prevCtgColMeta);
        String colName = currentColMeta.getColumnName();
        if (this.isGiven(currentHumanReadableName) && !colName.equals(currentHumanReadableName)) {
            return currentHumanReadableName;
        }
        if (this.isGiven(prevCtgHumanReadableName) && !colName.equals(prevCtgHumanReadableName)) {
            return prevCtgHumanReadableName;
        }
        if (this.isGiven(defaultHumanReadableName) && !colName.equals(defaultHumanReadableName)) {
            return defaultHumanReadableName;
        }
        return colName;
    }

    private void checkCurrentVsOthers(String colName, ColumnMetaData.Headers colHeader, ColumnMetaData current, ColumnMetaData defaults, ColumnMetaData previous) {
        String currentVal = this.getValue(colHeader, current);
        String defaultVal = this.getValue(colHeader, defaults);
        String prevCtgVal = this.getValue(colHeader, previous);
        if (defaultVal != null && !currentVal.equals(defaultVal)) {
            this.mStepLogger.log("WARNING: Column " + colName + ":  The current *" + colHeader + "* is different from the default that was calculated from crawling all data in the catalog.");
            this.mStepLogger.log("    current " + colHeader + ": " + (currentVal == null ? "(none)" : currentVal));
            this.mStepLogger.log("    default " + colHeader + ": " + (defaultVal == null ? "(none)" : defaultVal));
        }
        if (this.mPreviousCatalogColumnsTsv != null && prevCtgVal != null && !currentVal.equals(prevCtgVal)) {
            this.mStepLogger.log("WARNING: Column " + colName + ": The current *" + colHeader + "* is different from the same column in the previous catalog.");
            this.mStepLogger.log("    current  " + colHeader + ": " + (currentVal == null ? "(none)" : currentVal));
            this.mStepLogger.log("    previous " + colHeader + ": " + (prevCtgVal == null ? "(none)" : prevCtgVal));
        }
    }

    private boolean isGiven(String currentVal) {
        return currentVal != null && currentVal.trim().length() > 0 && !currentVal.equals(".");
    }

    private String getValue(String columnName, ColumnMetaData.Headers colHeader, HashMap<String, ColumnMetaData> colNameToMetaMap) {
        if (colNameToMetaMap == null) {
            return null;
        }
        ColumnMetaData colMeta = colNameToMetaMap.get(columnName);
        if (colMeta == null) {
            return null;
        }
        return this.getValue(colHeader, colMeta);
    }

    private String getValue(ColumnMetaData.Headers colHeader, ColumnMetaData colMeta) {
        if (colMeta == null) {
            return null;
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.ColumnName)) {
            return colMeta.getColumnName();
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.Type)) {
            return colMeta.getType().toString();
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.Count)) {
            return colMeta.getCount();
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.Description)) {
            return colMeta.getDescription();
        }
        return colMeta.getHumanReadableName();
    }

    protected static boolean isCurrentSameAsLastBackup(File currentFile) throws IOException {
        File lastBackupFile = MergeColumnsTsv.getLastBackup(currentFile);
        String currentContents = FileUtils.readFileToString((File)currentFile);
        String lastBackupContents = FileUtils.readFileToString((File)lastBackupFile);
        return currentContents.equals(lastBackupContents);
    }

    protected static File getLastBackup(File currentFile) throws IOException {
        File last = null;
        int i = 1;
        while (MergeColumnsTsv.getBackup(currentFile, i).exists()) {
            last = MergeColumnsTsv.getBackup(currentFile, i);
            ++i;
        }
        return last;
    }

    protected static void removeLastBackup(File currentFile) throws IOException {
        File lastBackup = MergeColumnsTsv.getLastBackup(currentFile);
        if (lastBackup != null && lastBackup.exists()) {
            lastBackup.delete();
        }
    }

    protected static void backupCurrentFile(File currentFile) throws IOException {
        File nextBackupFile = MergeColumnsTsv.getNextBackup(currentFile);
        FileUtils.copyFile((File)currentFile, (File)nextBackupFile);
    }

    protected static File getNextBackup(File currentFile) throws IOException {
        File nextBackup;
        int i = 1;
        do {
            nextBackup = MergeColumnsTsv.getBackup(currentFile, i);
            ++i;
        } while (nextBackup.exists());
        return nextBackup;
    }

    protected static File getBackup(File currentFile, int i) throws IOException {
        String extension = (i < 10 ? ".0" : ".") + Integer.toString(i);
        File buildDir = new File(currentFile.getParentFile(), ".build");
        return new File(buildDir, currentFile.getName() + extension);
    }
}

