/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.ontology.AbstractTerm;
import org.biojava.ontology.Ontology;
import org.biojava.utils.ChangeType;

public interface Term
extends Annotatable {
    public static final ChangeType ONTOLOGY = new ChangeType("This term's ontology has been changed", "org.biojava.ontology.Term", "ONTOLOGY");

    public String getName();

    public String getDescription();

    public void setDescription(String var1);

    public Ontology getOntology();

    public Object[] getSynonyms();

    public void addSynonym(Object var1);

    public void removeSynonym(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Impl
    extends AbstractTerm
    implements Term,
    Serializable {
        private static final long serialVersionUID = 6561668917514377417L;
        private final String name;
        private final Ontology ontology;
        private Annotation annotation;
        private Set<Object> synonyms;

        public Impl(Ontology ontology, String name) {
            this(ontology, name, null, null);
        }

        public Impl(Ontology ontology, String name, String description) {
            this(ontology, name, description, null);
        }

        public Impl(Ontology ontology, String name, String description, Object[] synonyms) {
            if (name == null) {
                throw new NullPointerException("Name must not be null");
            }
            if (ontology == null) {
                throw new NullPointerException("Ontology must not be null");
            }
            this.name = name;
            this.description = description;
            this.ontology = ontology;
            this.synonyms = new TreeSet<Object>();
            if (synonyms != null) {
                this.synonyms.addAll(Arrays.asList(synonyms));
            }
        }

        @Override
        public void addSynonym(Object synonym) {
            this.synonyms.add(synonym);
        }

        @Override
        public void removeSynonym(Object synonym) {
            this.synonyms.remove(synonym);
        }

        @Override
        public Object[] getSynonyms() {
            return this.synonyms.toArray();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }

        public void setSynonyms(Set<Object> synonyms) {
            this.synonyms = synonyms;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Ontology getOntology() {
            return this.ontology;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Annotation getAnnotation() {
            if (this.annotation == null) {
                this.annotation = new SmallAnnotation();
            }
            return this.annotation;
        }

        public int hashCode() {
            int value = 17;
            if (this.getName() != null) {
                value *= 31 * this.getName().hashCode();
            }
            return 17 * value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Term)) {
                return false;
            }
            Term that = (Term)obj;
            return this.getOntology() == that.getOntology() && this.getName() == that.getName();
        }
    }
}

