/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.Sequence;

public class SimpleFeatureRealizer
implements FeatureRealizer,
Serializable {
    private List templateToImpl = new ArrayList();
    private FeatureRealizer fallBack;

    public SimpleFeatureRealizer() {
        this.fallBack = null;
    }

    public SimpleFeatureRealizer(FeatureRealizer fallBack) {
        this.fallBack = fallBack;
    }

    public void addImplementation(Class template, Class impl) throws BioException {
        TemplateImpl ti = new TemplateImpl(template, impl);
        this.templateToImpl.add(0, ti);
    }

    public Feature realizeFeature(Sequence seq, FeatureHolder parent, Feature.Template temp) throws BioException {
        for (TemplateImpl ti : this.templateToImpl) {
            if (!ti.accept(temp)) continue;
            return ti.realize(seq, parent, temp);
        }
        if (this.fallBack != null) {
            return this.fallBack.realizeFeature(seq, parent, temp);
        }
        throw new BioException("Couldn't find realized implementation for template of class " + temp.getClass().getName());
    }

    private static class TemplateImpl {
        private Class template;
        private Constructor cons;

        private TemplateImpl(Class template, Class impl) throws BioException {
            Class[] signature = new Class[]{Sequence.class, FeatureHolder.class, template};
            this.template = template;
            try {
                this.cons = impl.getConstructor(signature);
            }
            catch (NoSuchMethodException ex) {
                throw new BioException("Class " + impl.getName() + " does not have suitable constructor", ex);
            }
        }

        public boolean accept(Feature.Template temp) {
            return this.template.isInstance(temp);
        }

        public Feature realize(Sequence seq, FeatureHolder parent, Feature.Template temp) throws BioException {
            Object[] consArgs = new Object[]{seq, parent, temp};
            try {
                return (Feature)this.cons.newInstance(consArgs);
            }
            catch (Exception ex) {
                Throwable t = ex;
                if (ex instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)ex).getTargetException();
                }
                throw new BioException("Couldn't realize feature", t);
            }
        }
    }
}

