/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SubstitutionMatrix {
    private Map<Symbol, Integer> rowSymbols;
    private Map<Symbol, Integer> colSymbols;
    private short[][] matrix;
    private short min;
    private short max;
    private FiniteAlphabet alphabet;
    private String description;
    private String name;
    private static final String newLine = System.getProperty("line.separator");

    public SubstitutionMatrix(FiniteAlphabet alpha, File matrixFile) throws BioException, NumberFormatException, IOException {
        this.alphabet = alpha;
        this.description = "";
        this.name = matrixFile.getName();
        this.rowSymbols = new HashMap<Symbol, Integer>();
        this.colSymbols = new HashMap<Symbol, Integer>();
        this.matrix = this.parseMatrix(matrixFile);
    }

    public SubstitutionMatrix(FiniteAlphabet alpha, String matrixString, String name) throws BioException, NumberFormatException, IOException {
        this.alphabet = alpha;
        this.description = "";
        this.name = name;
        this.rowSymbols = new HashMap<Symbol, Integer>();
        this.colSymbols = new HashMap<Symbol, Integer>();
        this.matrix = this.parseMatrix(matrixString);
    }

    public SubstitutionMatrix(FiniteAlphabet alpha, short match, short replace) {
        int i = 0;
        int j = 0;
        this.alphabet = alpha;
        this.description = "Identity matrix. All replaces and all matches are treated equally.";
        this.name = "IDENTITY_" + match + "_" + replace;
        this.rowSymbols = new HashMap<Symbol, Integer>();
        this.colSymbols = new HashMap<Symbol, Integer>();
        this.matrix = new short[alpha.size()][alpha.size()];
        Symbol[] sym = new Symbol[alpha.size()];
        Iterator iter = alpha.iterator();
        i = 0;
        while (iter.hasNext()) {
            sym[i] = (Symbol)iter.next();
            this.rowSymbols.put(sym[i], new Integer(i));
            this.colSymbols.put(sym[i], new Integer(i));
            ++i;
        }
        for (i = 0; i < this.alphabet.size(); ++i) {
            for (j = 0; j < this.alphabet.size(); ++j) {
                this.matrix[i][j] = sym[i].getMatches().contains(sym[j]) ? match : replace;
            }
        }
    }

    public SubstitutionMatrix(File file) throws NumberFormatException, NoSuchElementException, BioException, IOException {
        this(SubstitutionMatrix.guessAlphabet(file), file);
    }

    public static SubstitutionMatrix getSubstitutionMatrix(BufferedReader reader) throws NumberFormatException, BioException, IOException {
        StringBuffer stringMatrix = new StringBuffer("");
        while (reader.ready()) {
            stringMatrix.append(reader.readLine());
            stringMatrix.append(newLine);
        }
        reader.close();
        String mat = stringMatrix.toString();
        FiniteAlphabet alpha = SubstitutionMatrix.guessAlphabet(new BufferedReader(new StringReader(mat)));
        SubstitutionMatrix matrix = new SubstitutionMatrix(alpha, mat, "unknown");
        return matrix;
    }

    private static FiniteAlphabet guessAlphabet(File file) throws IOException, NoSuchElementException, BioException {
        String fileName = file.getName().toLowerCase();
        if (fileName.contains("pam") || fileName.contains("blosum")) {
            return (FiniteAlphabet)AlphabetManager.alphabetForName((String)"PROTEIN-TERM");
        }
        return SubstitutionMatrix.guessAlphabet(new BufferedReader(new FileReader(file)));
    }

    private static FiniteAlphabet guessAlphabet(BufferedReader reader) throws IOException, BioException {
        String line;
        FiniteAlphabet alphabet = null;
        while (reader.ready() && (line = reader.readLine()) != null) {
            String trim = line.trim();
            if (trim.length() == 0 || trim.charAt(0) == '#' || line.charAt(0) != ' ' && line.charAt(0) != '\t') continue;
            String[] alphabets = new String[]{"DNA", "RNA", "PROTEIN", "PROTEIN-TERM"};
            for (int i = 0; i < alphabets.length; ++i) {
                alphabet = (FiniteAlphabet)AlphabetManager.alphabetForName((String)alphabets[i]);
                SymbolTokenization symtok = alphabet.getTokenization("token");
                StringTokenizer st = new StringTokenizer(trim);
                boolean noError = true;
                int j = 0;
                while (st.hasMoreElements()) {
                    try {
                        symtok.parseToken(st.nextElement().toString());
                    }
                    catch (IllegalSymbolException exc) {
                        noError = false;
                        break;
                    }
                    ++j;
                }
                if (!noError) continue;
                return alphabet;
            }
        }
        throw new BioException("Unknow alphabet used in this substitution matrix");
    }

    private short[][] parseMatrix(Object matrixObj) throws BioException, NumberFormatException, IOException {
        StringTokenizer st;
        String trim;
        String line;
        Reader reader;
        int j = 0;
        int rows = 0;
        int cols = 0;
        SymbolTokenization symtok = this.alphabet.getTokenization("token");
        this.min = Short.MAX_VALUE;
        this.max = Short.MIN_VALUE;
        if (matrixObj instanceof File) {
            reader = new FileReader((File)matrixObj);
        } else if (matrixObj instanceof String) {
            reader = new StringReader(matrixObj.toString());
        } else {
            return null;
        }
        BufferedReader br = new BufferedReader(reader);
        while (br.ready() && (line = br.readLine()) != null) {
            trim = line.trim();
            if (trim.length() == 0) continue;
            if (trim.charAt(0) == '#') {
                this.description = this.description + line.substring(1);
                continue;
            }
            if (line.startsWith(newLine)) continue;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                st = new StringTokenizer(trim);
                j = 0;
                while (st.hasMoreElements()) {
                    this.colSymbols.put(symtok.parseToken(st.nextElement().toString()), j);
                    ++j;
                }
                cols = j;
                continue;
            }
            st = new StringTokenizer(trim);
            if (!st.hasMoreElements()) continue;
            this.rowSymbols.put(symtok.parseToken(st.nextElement().toString()), rows++);
        }
        br.close();
        short[][] matrix = new short[rows][cols];
        rows = 0;
        if (matrixObj instanceof File) {
            reader = new FileReader((File)matrixObj);
        } else if (matrixObj instanceof String) {
            reader = new StringReader(matrixObj.toString());
        } else {
            return null;
        }
        br = new BufferedReader(reader);
        while (br.ready() && (line = br.readLine()) != null) {
            trim = line.trim();
            if (trim.length() == 0 || trim.charAt(0) == '#' || line.charAt(0) == ' ' || line.charAt(0) == '\t' || line.startsWith(newLine)) continue;
            st = new StringTokenizer(trim);
            if (st.hasMoreElements()) {
                st.nextElement();
            }
            j = 0;
            while (st.hasMoreElements()) {
                matrix[rows][j] = (short)Math.round(Double.parseDouble(st.nextElement().toString()));
                if (matrix[rows][j] > this.max) {
                    this.max = matrix[rows][j];
                }
                if (matrix[rows][j] < this.min) {
                    this.min = matrix[rows][j];
                }
                ++j;
            }
            ++rows;
        }
        br.close();
        return matrix;
    }

    public short getValueAt(Symbol row, Symbol col) throws BioException {
        if (!this.rowSymbols.containsKey(row) || !this.colSymbols.containsKey(col)) {
            System.err.printf("SubstitutionMatrix: No entry for the symbols %s and %s\n", row.getName(), col.getName());
            return 0;
        }
        return this.matrix[this.rowSymbols.get(row)][this.colSymbols.get(col)];
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public FiniteAlphabet getAlphabet() {
        return this.alphabet;
    }

    public String stringnifyMatrix() {
        int i = 0;
        StringBuffer matrixString = new StringBuffer();
        Symbol[] colSyms = new Symbol[this.colSymbols.keySet().size()];
        try {
            SymbolTokenization symtok = this.alphabet.getTokenization("default");
            matrixString.append("  ");
            Iterator<Symbol> colKeys = this.colSymbols.keySet().iterator();
            while (colKeys.hasNext()) {
                colSyms[i] = colKeys.next();
                matrixString.append(symtok.tokenizeSymbol(colSyms[i++]).toUpperCase());
                matrixString.append(' ');
            }
            matrixString.append(newLine);
            for (Symbol rowSym : this.rowSymbols.keySet()) {
                matrixString.append(symtok.tokenizeSymbol(rowSym).toUpperCase());
                matrixString.append(' ');
                for (i = 0; i < colSyms.length; ++i) {
                    matrixString.append(this.getValueAt(rowSym, colSyms[i]));
                    matrixString.append(' ');
                }
                matrixString.append(newLine);
            }
        }
        catch (BioException exc) {
            exc.printStackTrace();
        }
        return matrixString.toString();
    }

    public String stringnifyDescription() {
        StringBuffer desc = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append("# ");
        StringTokenizer st = new StringTokenizer(this.description, " ");
        while (st.hasMoreElements()) {
            line.append(st.nextElement().toString());
            line.append(' ');
            if (line.length() >= 60) {
                desc.append(line);
                desc.append(newLine);
                if (!st.hasMoreElements()) continue;
                line = new StringBuffer();
                line.append("# ");
                continue;
            }
            if (st.hasMoreElements()) continue;
            desc.append(line);
            desc.append(newLine);
        }
        return desc.toString();
    }

    public String toString() {
        StringBuffer desc = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append("# ");
        StringTokenizer st = new StringTokenizer(this.description);
        while (st.hasMoreElements()) {
            line.append(st.nextElement().toString());
            line.append(' ');
            if (line.length() >= 60) {
                desc.append(line);
                desc.append(newLine);
                if (!st.hasMoreElements()) continue;
                line = new StringBuffer();
                line.append("# ");
                continue;
            }
            if (st.hasMoreElements()) continue;
            desc.append(line);
            desc.append(newLine);
        }
        desc.append(this.stringnifyMatrix());
        return desc.toString();
    }

    public void printMatrix() {
        Iterator<Symbol> rowKeys = this.rowSymbols.keySet().iterator();
        while (rowKeys.hasNext()) {
            Iterator<Symbol> colKeys = this.colSymbols.keySet().iterator();
            Symbol rowSym = rowKeys.next();
            System.out.print(rowSym.getName() + "\t");
            while (colKeys.hasNext()) {
                Symbol colSym = colKeys.next();
                int x = this.rowSymbols.get(rowSym);
                int y = this.colSymbols.get(colSym);
                System.out.print(colSym.getName() + " " + " " + x + " " + y + " " + this.matrix[x][y] + "\t");
            }
            System.out.println(newLine);
        }
        System.out.println(this.toString());
    }

    public SubstitutionMatrix normalizeMatrix() throws BioException, NumberFormatException, IOException {
        int j;
        int i;
        short min = this.getMin();
        short newMax = Short.MIN_VALUE;
        short[][] mat = new short[this.matrix.length][this.matrix[this.matrix.length - 1].length];
        String name = this.getName() + "_normalized";
        String matString = this.stringnifyDescription() + "  ";
        FiniteAlphabet alphabet = this.getAlphabet();
        Map<Symbol, Integer> rowMap = this.rowSymbols;
        Map<Symbol, Integer> colMap = this.colSymbols;
        SymbolTokenization symtok = alphabet.getTokenization("default");
        for (i = 0; i < this.matrix.length; ++i) {
            for (j = 0; j < this.matrix[this.matrix.length - 1].length; ++j) {
                mat[i][j] = (short)(this.matrix[i][j] - min);
                if (mat[i][j] <= newMax) continue;
                newMax = mat[i][j];
            }
        }
        for (i = 0; i < mat.length; ++i) {
            for (j = 0; j < mat[mat.length - 1].length; ++j) {
                mat[i][j] = (short)(mat[i][j] * 10 / newMax);
            }
        }
        Object[] rows = this.rowSymbols.keySet().toArray();
        Object[] cols = this.colSymbols.keySet().toArray();
        for (i = 0; i < cols.length; ++i) {
            matString = matString + symtok.tokenizeSymbol((Symbol)cols[i]) + " ";
        }
        for (i = 0; i < rows.length; ++i) {
            matString = matString + newLine + symtok.tokenizeSymbol((Symbol)rows[i]) + " ";
            for (j = 0; j < cols.length; ++j) {
                matString = matString + mat[rowMap.get((Symbol)rows[i])][colMap.get((Symbol)cols[j])] + " ";
            }
        }
        matString = matString + newLine;
        return new SubstitutionMatrix(alphabet, matString, name);
    }
}

