/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.alignment.AlignmentAlgorithm;
import org.biojava.bio.alignment.AlignmentPair;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class NeedlemanWunsch
extends AlignmentAlgorithm {
    protected int[][] CostMatrix;
    private short delete;
    private short gapExt;
    private short insert;
    private short match;
    private short replace;
    protected SubstitutionMatrix subMatrix;

    protected static int min(int x, int y, int z) {
        if (x < y && x < z) {
            return x;
        }
        if (y < z) {
            return y;
        }
        return z;
    }

    public static String printCostMatrix(int[][] CostMatrix, char[] queryChar, char[] targetChar) {
        int line;
        int col;
        StringBuilder output = new StringBuilder();
        output.append('\t');
        String ls = System.getProperty("line.separator");
        for (col = 0; col <= targetChar.length; ++col) {
            if (col == 0) {
                output.append('[');
                output.append(col);
                output.append("]\t");
                continue;
            }
            output.append('[');
            output.append(targetChar[col - 1]);
            output.append("]\t");
        }
        for (line = 0; line <= queryChar.length; ++line) {
            if (line == 0) {
                output.append(ls);
                output.append('[');
                output.append(line);
                output.append("]\t");
            } else {
                output.append(ls);
                output.append('[');
                output.append(queryChar[line - 1]);
                output.append("]\t");
            }
            for (col = 0; col <= targetChar.length; ++col) {
                output.append(CostMatrix[line][col]);
                output.append('\t');
            }
        }
        output.append(ls);
        output.append("delta[Edit] = ");
        output.append(CostMatrix[line - 1][col - 1]);
        output.append(ls);
        return output.toString();
    }

    public NeedlemanWunsch(short match, short replace, short insert, short delete, short gapExtend, SubstitutionMatrix subMat) {
        this.subMatrix = subMat;
        this.insert = insert;
        this.delete = delete;
        this.gapExt = gapExtend;
        this.match = match;
        this.replace = replace;
    }

    public short getDelete() {
        return this.delete;
    }

    public int getEditDistance() {
        return this.CostMatrix[this.CostMatrix.length - 1][this.CostMatrix[this.CostMatrix.length - 1].length - 1];
    }

    public short getGapExt() {
        return this.gapExt;
    }

    public short getInsert() {
        return this.insert;
    }

    public short getMatch() {
        return this.match;
    }

    public short getReplace() {
        return this.replace;
    }

    private int matchReplace(Sequence query, Sequence subject, int i, int j) {
        try {
            return this.subMatrix.getValueAt(query.symbolAt(i), subject.symbolAt(j));
        }
        catch (Exception exc) {
            if (query.symbolAt(i).getMatches().contains(subject.symbolAt(j)) || subject.symbolAt(j).getMatches().contains(query.symbolAt(i))) {
                return -this.match;
            }
            return -this.replace;
        }
    }

    public AlignmentPair pairwiseAlignment(SymbolList query, SymbolList subject) throws BioException {
        Object squery = null;
        Object ssubject = null;
        squery = query instanceof Sequence ? (Sequence)query : new SimpleSequence(query, "", "query", (Annotation)new SimpleAnnotation());
        ssubject = subject instanceof Sequence ? (Sequence)subject : new SimpleSequence(subject, "", "subject", (Annotation)new SimpleAnnotation());
        SymbolTokenization st = null;
        st = this.subMatrix.getAlphabet().getTokenization("default");
        if (squery.getAlphabet().equals(ssubject.getAlphabet()) && squery.getAlphabet().equals(this.subMatrix.getAlphabet())) {
            StringBuffer[] align = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
            long time = System.currentTimeMillis();
            this.CostMatrix = new int[squery.length() + 1][ssubject.length() + 1];
            StringBuffer path = new StringBuffer();
            this.CostMatrix[0][0] = 0;
            if (this.gapExt != this.delete || this.gapExt != this.insert) {
                int j;
                int i;
                int[][] E = new int[squery.length() + 1][ssubject.length() + 1];
                int[][] F = new int[squery.length() + 1][ssubject.length() + 1];
                F[0][0] = Integer.MAX_VALUE;
                E[0][0] = Integer.MAX_VALUE;
                for (i = 1; i <= squery.length(); ++i) {
                    E[i][0] = Integer.MAX_VALUE;
                    int n = this.delete + i * this.gapExt;
                    F[i][0] = n;
                    this.CostMatrix[i][0] = n;
                }
                for (j = 1; j <= ssubject.length(); ++j) {
                    F[0][j] = Integer.MAX_VALUE;
                    int n = this.insert + j * this.gapExt;
                    E[0][j] = n;
                    this.CostMatrix[0][j] = n;
                }
                for (i = 1; i <= squery.length(); ++i) {
                    for (j = 1; j <= ssubject.length(); ++j) {
                        E[i][j] = Math.min(E[i][j - 1], this.CostMatrix[i][j - 1] + this.insert) + this.gapExt;
                        F[i][j] = Math.min(F[i - 1][j], this.CostMatrix[i - 1][j] + this.delete) + this.gapExt;
                        this.CostMatrix[i][j] = NeedlemanWunsch.min(E[i][j], F[i][j], this.CostMatrix[i - 1][j - 1] - this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j));
                    }
                }
                boolean[] gap_extend = new boolean[]{false, false};
                j = this.CostMatrix[this.CostMatrix.length - 1].length - 1;
                i = this.CostMatrix.length - 1;
                while (i > 0) {
                    do {
                        if (i == 0) {
                            align[0].insert(0, '-');
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            path.insert(0, ' ');
                            continue;
                        }
                        if (j == 0) {
                            align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                            align[1].insert(0, '-');
                            path.insert(0, ' ');
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i - 1][j - 1] - this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j) && !gap_extend[0] && !gap_extend[1]) {
                            if (squery.symbolAt(i) == ssubject.symbolAt(j)) {
                                path.insert(0, '|');
                            } else {
                                path.insert(0, ' ');
                            }
                            align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            continue;
                        }
                        if (this.CostMatrix[i][j] == E[i][j] || gap_extend[0]) {
                            gap_extend[0] = E[i][j] != this.CostMatrix[i][j - 1] + this.insert + this.gapExt;
                            align[0].insert(0, '-');
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            path.insert(0, ' ');
                            continue;
                        }
                        gap_extend[1] = F[i][j] != this.CostMatrix[i - 1][j] + this.delete + this.gapExt;
                        align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                        align[1].insert(0, '-');
                        path.insert(0, ' ');
                    } while (j > 0);
                }
            } else {
                int j;
                int i;
                for (i = 1; i <= squery.length(); ++i) {
                    this.CostMatrix[i][0] = this.CostMatrix[i - 1][0] + this.delete;
                }
                for (j = 1; j <= ssubject.length(); ++j) {
                    this.CostMatrix[0][j] = this.CostMatrix[0][j - 1] + this.insert;
                }
                for (i = 1; i <= squery.length(); ++i) {
                    for (j = 1; j <= ssubject.length(); ++j) {
                        this.CostMatrix[i][j] = NeedlemanWunsch.min(this.CostMatrix[i - 1][j] + this.delete, this.CostMatrix[i][j - 1] + this.insert, this.CostMatrix[i - 1][j - 1] - this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j));
                    }
                }
                j = this.CostMatrix[this.CostMatrix.length - 1].length - 1;
                i = this.CostMatrix.length - 1;
                while (i > 0) {
                    do {
                        if (i == 0) {
                            align[0].insert(0, '-');
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            path.insert(0, ' ');
                            continue;
                        }
                        if (j == 0) {
                            align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                            align[1].insert(0, '-');
                            path.insert(0, ' ');
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i - 1][j - 1] - this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j)) {
                            if (squery.symbolAt(i) == ssubject.symbolAt(j)) {
                                path.insert(0, '|');
                            } else {
                                path.insert(0, ' ');
                            }
                            align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i][j - 1] + this.insert) {
                            align[0].insert(0, '-');
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            path.insert(0, ' ');
                            continue;
                        }
                        align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                        align[1].insert(0, '-');
                        path.insert(0, ' ');
                    } while (j > 0);
                }
            }
            squery = new SimpleGappedSequence((Sequence)new SimpleSequence((SymbolList)new SimpleSymbolList(squery.getAlphabet().getTokenization("token"), align[0].toString()), squery.getURN(), squery.getName(), squery.getAnnotation()));
            ssubject = new SimpleGappedSequence((Sequence)new SimpleSequence((SymbolList)new SimpleSymbolList(ssubject.getAlphabet().getTokenization("token"), align[1].toString()), ssubject.getURN(), ssubject.getName(), ssubject.getAnnotation()));
            AlignmentPair pairalign = new AlignmentPair((Sequence)squery, (Sequence)ssubject, 1, squery.length(), 1, ssubject.length(), this.subMatrix);
            pairalign.setComputationTime(System.currentTimeMillis() - time);
            pairalign.setScore(-1 * this.getEditDistance());
            return pairalign;
        }
        throw new BioException("Alphabet missmatch occured: sequences with different alphabet cannot be aligned.");
    }

    public void setDelete(short del) {
        this.delete = del;
    }

    public void setGapExt(short ge) {
        this.gapExt = ge;
    }

    public void setInsert(short ins) {
        this.insert = ins;
    }

    public void setMatch(short ma) {
        this.match = ma;
    }

    public void setReplace(short rep) {
        this.replace = rep;
    }

    public void setSubstitutionMatrix(SubstitutionMatrix matrix) {
        this.subMatrix = matrix;
    }
}

