/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.zip;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.zip.IntelDeflater;
import java.lang.reflect.Constructor;
import java.util.zip.Deflater;

public class DeflaterFactory {
    private static Constructor<IntelDeflater> intelDeflaterConstructor;

    public static Deflater makeDeflater(int n, boolean bl) {
        if (intelDeflaterConstructor != null) {
            try {
                return intelDeflaterConstructor.newInstance(n, bl);
            }
            catch (Exception exception) {
                throw new SAMException("Exception constructing IntelDeflater", exception);
            }
        }
        return new Deflater(n, bl);
    }

    public static boolean usingIntelDeflater() {
        return intelDeflaterConstructor != null;
    }

    static {
        try {
            if (Defaults.TRY_USE_INTEL_DEFLATER) {
                Class<?> clazz = Class.forName("htsjdk.samtools.util.zip.IntelDeflater");
                intelDeflaterConstructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            intelDeflaterConstructor = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            intelDeflaterConstructor = null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            intelDeflaterConstructor = null;
        }
    }
}

