/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalCoordinateComparator;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringLineReader;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class IntervalList
implements Iterable<Interval> {
    public static final String INTERVAL_LIST_FILE_EXTENSION = ".interval_list";
    private final SAMFileHeader header;
    private final List<Interval> intervals = new ArrayList<Interval>();
    private static final Log log = Log.getInstance(IntervalList.class);

    public IntervalList(SAMFileHeader sAMFileHeader) {
        if (sAMFileHeader == null) {
            throw new IllegalArgumentException("SAMFileHeader must be supplied.");
        }
        this.header = sAMFileHeader;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    @Override
    public Iterator<Interval> iterator() {
        return this.intervals.iterator();
    }

    public void add(Interval interval) {
        if (this.header.getSequence(interval.getContig()) == null) {
            throw new IllegalArgumentException(String.format("Cannot add interval %s, contig not in header", interval.toString()));
        }
        this.intervals.add(interval);
    }

    public void addall(Collection<Interval> collection) {
        for (Interval interval : collection) {
            this.add(interval);
        }
    }

    @Deprecated
    public void sort() {
        Collections.sort(this.intervals, new IntervalCoordinateComparator(this.header));
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
    }

    public IntervalList padded(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Padding values must be >= 0.");
        }
        IntervalList intervalList = new IntervalList(this.getHeader().clone());
        SAMSequenceDictionary sAMSequenceDictionary = intervalList.getHeader().getSequenceDictionary();
        for (Interval interval : this) {
            SAMSequenceRecord sAMSequenceRecord = sAMSequenceDictionary.getSequence(interval.getContig());
            int n3 = Math.max(1, interval.getStart() - n);
            int n4 = Math.min(sAMSequenceRecord.getSequenceLength(), interval.getEnd() + n2);
            intervalList.add(new Interval(interval.getContig(), n3, n4, interval.isNegativeStrand(), interval.getName()));
        }
        return intervalList;
    }

    public IntervalList padded(int n) {
        return this.padded(n, n);
    }

    public IntervalList sorted() {
        IntervalList intervalList = IntervalList.copyOf(this);
        Collections.sort(intervalList.intervals, new IntervalCoordinateComparator(intervalList.header));
        intervalList.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        return intervalList;
    }

    public IntervalList uniqued() {
        return this.uniqued(true);
    }

    public IntervalList uniqued(boolean bl) {
        List<Interval> list = IntervalList.getUniqueIntervals(this.sorted(), bl);
        IntervalList intervalList = new IntervalList(this.header.clone());
        intervalList.intervals.addAll(list);
        return intervalList;
    }

    @Deprecated
    public void unique() {
        this.unique(true);
    }

    @Deprecated
    public void unique(boolean bl) {
        this.sort();
        List<Interval> list = this.getUniqueIntervals(bl);
        this.intervals.clear();
        this.intervals.addAll(list);
    }

    public List<Interval> getIntervals() {
        return Collections.unmodifiableList(this.intervals);
    }

    @Deprecated
    public List<Interval> getUniqueIntervals() {
        return this.getUniqueIntervals(true);
    }

    public static List<Interval> getUniqueIntervals(IntervalList intervalList, boolean bl) {
        return IntervalList.getUniqueIntervals(intervalList, bl, false);
    }

    public static List<Interval> getUniqueIntervals(IntervalList intervalList, boolean bl, boolean bl2) {
        List<Interval> list = intervalList.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate ? intervalList.sorted().intervals : intervalList.intervals;
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        TreeSet<Interval> treeSet = new TreeSet<Interval>();
        Interval interval = null;
        for (Interval interval2 : list) {
            if (interval == null) {
                treeSet.add(interval2);
                interval = interval2;
                continue;
            }
            if (interval.intersects(interval2) || interval.abuts(interval2)) {
                if (bl2 && interval.isNegativeStrand() != interval2.isNegativeStrand()) {
                    throw new SAMException("Strands were not equal for: " + interval.toString() + " and " + interval2.toString());
                }
                treeSet.add(interval2);
                interval = new Interval(interval.getContig(), interval.getStart(), Math.max(interval.getEnd(), interval2.getEnd()), interval.isNegativeStrand(), null);
                continue;
            }
            arrayList.add(IntervalList.merge(treeSet, bl));
            treeSet.clear();
            interval = interval2;
            treeSet.add(interval);
        }
        if (treeSet.size() > 0) {
            arrayList.add(IntervalList.merge(treeSet, bl));
        }
        return arrayList;
    }

    @Deprecated
    public List<Interval> getUniqueIntervals(boolean bl) {
        if (this.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            this.sort();
        }
        return IntervalList.getUniqueIntervals(this, bl);
    }

    public static List<Interval> breakIntervalsAtBandMultiples(List<Interval> list, int n) {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (Interval interval : list) {
            if (interval.getEnd() >= interval.getStart()) {
                int n2;
                int n3 = interval.getStart() / n;
                if (n3 == (n2 = interval.getEnd() / n)) {
                    arrayList.add(interval);
                    continue;
                }
                arrayList.addAll(IntervalList.breakIntervalAtBandMultiples(interval, n));
                continue;
            }
            arrayList.add(interval);
        }
        return arrayList;
    }

    private static List<Interval> breakIntervalAtBandMultiples(Interval interval, int n) {
        int n2;
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        int n3 = interval.getStart();
        int n4 = n2 = n3 / n;
        int n5 = interval.getEnd() / n;
        while (n4 <= n5) {
            int n6 = (n4 + 1) * n - 1;
            if (n6 > interval.getEnd()) {
                n6 = interval.getEnd();
            }
            arrayList.add(new Interval(interval.getContig(), n3, n6, interval.isNegativeStrand(), interval.getName() + "." + (n4 - n2 + 1)));
            n3 = ++n4 * n;
        }
        return arrayList;
    }

    static Interval merge(SortedSet<Interval> sortedSet, boolean bl) {
        String string = sortedSet.first().getContig();
        int n = sortedSet.first().getStart();
        int n2 = sortedSet.last().getEnd();
        boolean bl2 = sortedSet.first().isNegativeStrand();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Interval interval : sortedSet) {
            if (interval.getName() != null) {
                linkedHashSet.add(interval.getName());
            }
            n = Math.min(n, interval.getStart());
            n2 = Math.max(n2, interval.getEnd());
        }
        String string2 = bl ? (linkedHashSet.isEmpty() ? null : StringUtil.join("|", linkedHashSet)) : (String)linkedHashSet.iterator().next();
        return new Interval(string, n, n2, bl2, string2);
    }

    public long getBaseCount() {
        return Interval.countBases(this.intervals);
    }

    public long getUniqueBaseCount() {
        return this.uniqued().getBaseCount();
    }

    public int size() {
        return this.intervals.size();
    }

    public static IntervalList copyOf(IntervalList intervalList) {
        IntervalList intervalList2 = new IntervalList(intervalList.header.clone());
        intervalList2.intervals.addAll(intervalList.intervals);
        return intervalList2;
    }

    public static IntervalList fromFile(File file) {
        BufferedReader bufferedReader = IOUtil.openFileForBufferedReading(file);
        IntervalList intervalList = IntervalList.fromReader(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new SAMException(String.format("Failed to close file %s after reading", file));
        }
        return intervalList;
    }

    public static IntervalList fromName(SAMFileHeader sAMFileHeader, String string) {
        IntervalList intervalList = new IntervalList(sAMFileHeader);
        intervalList.add(new Interval(string, 1, sAMFileHeader.getSequence(string).getSequenceLength()));
        return intervalList;
    }

    public static IntervalList fromFiles(Collection<File> collection) {
        ArrayList<IntervalList> arrayList = new ArrayList<IntervalList>();
        for (File file : collection) {
            arrayList.add(IntervalList.fromFile(file));
        }
        return IntervalList.union(arrayList);
    }

    public static IntervalList fromReader(BufferedReader bufferedReader) {
        Object object;
        try {
            StringBuilder stringBuilder = new StringBuilder(4096);
            String string = null;
            while ((string = bufferedReader.readLine()) != null && string.startsWith("@")) {
                stringBuilder.append(string).append('\n');
            }
            if (stringBuilder.length() == 0) {
                throw new IllegalStateException("Interval list file must contain header. ");
            }
            StringLineReader stringLineReader = new StringLineReader(stringBuilder.toString());
            SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
            IntervalList intervalList = new IntervalList(sAMTextHeaderCodec.decode(stringLineReader, "BufferedReader"));
            SAMSequenceDictionary sAMSequenceDictionary = intervalList.getHeader().getSequenceDictionary();
            if (string == null) {
                IntervalList intervalList2 = intervalList;
                return intervalList2;
            }
            FormatUtil formatUtil = new FormatUtil();
            do {
                boolean bl;
                if (string.trim().length() == 0) continue;
                object = string.split("\t");
                if (((String[])object).length != 5) {
                    throw new SAMException("Invalid interval record contains " + ((String[])object).length + " fields: " + string);
                }
                String string2 = object[0];
                int n = formatUtil.parseInt(object[1]);
                int n2 = formatUtil.parseInt(object[2]);
                if (object[3].equals("-")) {
                    bl = true;
                } else if (object[3].equals("+")) {
                    bl = false;
                } else {
                    throw new IllegalArgumentException("Invalid strand field: " + object[3]);
                }
                String string3 = object[4];
                Interval interval = new Interval(string2, n, n2, bl, string3);
                if (sAMSequenceDictionary.getSequence(string2) == null) {
                    log.warn("Ignoring interval for unknown reference: " + interval);
                    continue;
                }
                intervalList.intervals.add(interval);
            } while ((string = bufferedReader.readLine()) != null);
            object = intervalList;
        }
        catch (IOException iOException) {
            throw new SAMException("Error parsing interval list.", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public void write(File file) {
        try {
            BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting(file);
            FormatUtil formatUtil = new FormatUtil();
            if (this.header != null) {
                SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
                sAMTextHeaderCodec.encode(bufferedWriter, this.header);
            }
            for (Interval interval : this) {
                bufferedWriter.write(interval.getContig());
                bufferedWriter.write(9);
                bufferedWriter.write(formatUtil.format(interval.getStart()));
                bufferedWriter.write(9);
                bufferedWriter.write(formatUtil.format(interval.getEnd()));
                bufferedWriter.write(9);
                bufferedWriter.write(interval.isPositiveStrand() ? 43 : 45);
                bufferedWriter.write(9);
                if (interval.getName() != null) {
                    bufferedWriter.write(interval.getName());
                } else {
                    bufferedWriter.write(".");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new SAMException("Error writing out interval list to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public static IntervalList intersection(IntervalList intervalList, IntervalList intervalList2) {
        SequenceUtil.assertSequenceDictionariesEqual(intervalList.getHeader().getSequenceDictionary(), intervalList2.getHeader().getSequenceDictionary());
        IntervalList intervalList3 = new IntervalList(intervalList.getHeader().clone());
        OverlapDetector<Interval> overlapDetector = new OverlapDetector<Interval>(0, 0);
        overlapDetector.addAll(intervalList.getIntervals(), intervalList.getIntervals());
        for (Interval interval : intervalList2.getIntervals()) {
            Collection collection = overlapDetector.getOverlaps(interval);
            for (Interval interval2 : collection) {
                Interval interval3 = interval.intersect(interval2);
                intervalList3.add(interval3);
            }
        }
        return intervalList3.uniqued();
    }

    public static IntervalList intersection(Collection<IntervalList> collection) {
        IntervalList intervalList = null;
        for (IntervalList intervalList2 : collection) {
            if (intervalList == null) {
                intervalList = intervalList2;
                continue;
            }
            intervalList = IntervalList.intersection(intervalList, intervalList2);
        }
        return intervalList;
    }

    public static IntervalList concatenate(Collection<IntervalList> collection) {
        if (collection.isEmpty()) {
            throw new SAMException("Cannot concatenate an empty list of IntervalLists.");
        }
        SAMFileHeader sAMFileHeader = collection.iterator().next().getHeader().clone();
        sAMFileHeader.setSortOrder(SAMFileHeader.SortOrder.unsorted);
        IntervalList intervalList = new IntervalList(sAMFileHeader);
        for (IntervalList intervalList2 : collection) {
            SequenceUtil.assertSequenceDictionariesEqual(intervalList.getHeader().getSequenceDictionary(), intervalList2.getHeader().getSequenceDictionary());
            intervalList.addall(intervalList2.intervals);
        }
        return intervalList;
    }

    public static IntervalList union(Collection<IntervalList> collection) {
        IntervalList intervalList = IntervalList.concatenate(collection);
        return intervalList.uniqued();
    }

    public static IntervalList union(IntervalList intervalList, IntervalList intervalList2) {
        List<IntervalList> list = CollectionUtil.makeList(intervalList, intervalList2);
        return IntervalList.union(list);
    }

    public static IntervalList invert(IntervalList intervalList) {
        IntervalList intervalList2 = new IntervalList(intervalList.header.clone());
        ListMap<Integer, Interval> listMap = new ListMap<Integer, Interval>();
        for (Interval object : intervalList.uniqued().getIntervals()) {
            listMap.add(intervalList.getHeader().getSequenceIndex(object.getContig()), object);
        }
        int n = 0;
        for (SAMSequenceRecord sAMSequenceRecord : intervalList.getHeader().getSequenceDictionary().getSequences()) {
            Integer n2 = sAMSequenceRecord.getSequenceIndex();
            String string = sAMSequenceRecord.getSequenceName();
            int n3 = sAMSequenceRecord.getSequenceLength();
            Integer n4 = 0;
            if (listMap.containsKey(n2)) {
                for (Interval interval : (List)listMap.get(n2)) {
                    if (interval.getStart() > n4 + 1) {
                        intervalList2.add(new Interval(string, n4 + 1, interval.getStart() - 1, false, "interval-" + ++n));
                    }
                    n4 = interval.getEnd();
                }
            }
            if (n3 <= n4) continue;
            intervalList2.add(new Interval(string, n4 + 1, n3, false, "interval-" + ++n));
        }
        return intervalList2;
    }

    public static IntervalList subtract(Collection<IntervalList> collection, Collection<IntervalList> collection2) {
        return IntervalList.intersection(IntervalList.union(collection), IntervalList.invert(IntervalList.union(collection2)));
    }

    public static IntervalList subtract(IntervalList intervalList, IntervalList intervalList2) {
        return IntervalList.subtract(Collections.singletonList(intervalList), Collections.singletonList(intervalList2));
    }

    public static IntervalList difference(Collection<IntervalList> collection, Collection<IntervalList> collection2) {
        return IntervalList.union(IntervalList.subtract(collection, collection2), IntervalList.subtract(collection2, collection));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntervalList intervalList = (IntervalList)object;
        return this.header.equals(intervalList.header) && this.intervals.equals(intervalList.intervals);
    }

    public int hashCode() {
        int n = this.header.hashCode();
        n = 31 * n + this.intervals.hashCode();
        return n;
    }
}

