/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.ResourceLimitedMap;
import htsjdk.samtools.util.ResourceLimitedMapFunctor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileAppendStreamLRUCache
extends ResourceLimitedMap<File, OutputStream> {
    public FileAppendStreamLRUCache(int n) {
        super(n, new Functor());
    }

    private static class Functor
    implements ResourceLimitedMapFunctor<File, OutputStream> {
        private Functor() {
        }

        @Override
        public OutputStream makeValue(File file) {
            try {
                return IOUtil.maybeBufferOutputStream(new FileOutputStream(file, true));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.gc();
                System.runFinalization();
                try {
                    return IOUtil.maybeBufferOutputStream(new FileOutputStream(file, true));
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    throw new SAMException(file + "not found", fileNotFoundException2);
                }
            }
        }

        @Override
        public void finalizeValue(File file, OutputStream outputStream) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new SAMException("Exception closing FileOutputStream for " + file, iOException);
            }
        }
    }
}

