/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public class OverclippedReadFilter
implements SamRecordFilter {
    private final int unclippedBasesThreshold;
    private final boolean filterSingleEndClips;

    public OverclippedReadFilter(int n, boolean bl) {
        if (n < 0) {
            throw new SAMException("unclippedBasesThreshold must be non-negative");
        }
        this.unclippedBasesThreshold = n;
        this.filterSingleEndClips = bl;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord) {
        int n = 0;
        int n2 = 0;
        int n3 = this.filterSingleEndClips ? 1 : 2;
        CigarOperator cigarOperator = null;
        for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() == CigarOperator.S) {
                if (cigarOperator != CigarOperator.S) {
                    ++n2;
                }
            } else if (cigarElement.getOperator().consumesReadBases()) {
                n += cigarElement.getLength();
            }
            cigarOperator = cigarElement.getOperator();
        }
        return n < this.unclippedBasesThreshold && n2 >= n3;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return this.filterOut(sAMRecord) || this.filterOut(sAMRecord2);
    }
}

