/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;

public class Slice {
    public static final int UNMAPPED_OR_NO_REFERENCE = -1;
    public static final int MULTI_REFERENCE = -2;
    private static final Log log = Log.getInstance(Slice.class);
    public int sequenceId = -1;
    public int alignmentStart = -1;
    public int alignmentSpan = -1;
    public int nofRecords = -1;
    public long globalRecordCounter = -1L;
    public int nofBlocks = -1;
    public int[] contentIDs;
    public int embeddedRefBlockContentID = -1;
    public byte[] refMD5 = new byte[16];
    public Block headerBlock;
    public Block coreBlock;
    public Block embeddedRefBlock;
    public Map<Integer, Block> external;
    public int offset = -1;
    public long containerOffset = -1L;
    public int size = -1;
    public int index = -1;
    public long bases;
    public SAMBinaryTagAndValue sliceTags;

    private void alignmentBordersSanityCheck(byte[] byArray) {
        if (this.alignmentStart > 0 && this.sequenceId >= 0 && byArray == null) {
            throw new NullPointerException("Mapped slice reference is null.");
        }
        if (this.alignmentStart > byArray.length) {
            log.error(String.format("Slice mapped outside of reference: seqID=%d, start=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.globalRecordCounter));
            throw new RuntimeException("Slice mapped outside of the reference.");
        }
        if (this.alignmentStart - 1 + this.alignmentSpan > byArray.length) {
            log.warn(String.format("Slice partially mapped outside of reference: seqID=%d, start=%d, span=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.globalRecordCounter));
        }
    }

    public boolean validateRefMD5(byte[] byArray) {
        this.alignmentBordersSanityCheck(byArray);
        if (!Slice.validateRefMD5(byArray, this.alignmentStart, this.alignmentSpan, this.refMD5)) {
            String string = Slice.getBrief(this.alignmentStart, this.alignmentSpan, byArray, 10);
            if (Slice.validateRefMD5(byArray, this.alignmentStart, this.alignmentSpan - 1, this.refMD5)) {
                log.warn(String.format("Reference MD5 matches partially for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, string));
                return true;
            }
            log.error(String.format("Reference MD5 mismatch for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, string));
            return false;
        }
        return true;
    }

    private static boolean validateRefMD5(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = Math.min(n2, byArray.length - n + 1);
        String string = SequenceUtil.calculateMD5String(byArray, n - 1, n3);
        return string.equals(String.format("%032x", new BigInteger(1, byArray2)));
    }

    private static String getBrief(int n, int n2, byte[] byArray, int n3) {
        if (n2 >= byArray.length) {
            return new String(byArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n - 1;
        int n5 = n + n2 - 1;
        if ((n5 = Math.min(n5, byArray.length)) - n4 <= 2 * n3) {
            stringBuilder.append(new String(Arrays.copyOfRange(byArray, n4, n5)));
        } else {
            stringBuilder.append(new String(Arrays.copyOfRange(byArray, n4, n4 + n3)));
            stringBuilder.append("...");
            stringBuilder.append(new String(Arrays.copyOfRange(byArray, n5 - n3, n5)));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("slice: seqID %d, start %d, span %d, records %d.", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.nofRecords);
    }

    public void setRefMD5(byte[] byArray) {
        this.alignmentBordersSanityCheck(byArray);
        if (this.sequenceId < 0 && this.alignmentStart < 1) {
            this.refMD5 = new byte[16];
            Arrays.fill(this.refMD5, (byte)0);
            log.debug("Empty slice ref md5 is set.");
        } else {
            int n = Math.min(this.alignmentSpan, byArray.length - this.alignmentStart + 1);
            if (this.alignmentStart + n > byArray.length + 1) {
                throw new RuntimeException("Invalid alignment boundaries.");
            }
            this.refMD5 = SequenceUtil.calculateMD5(byArray, this.alignmentStart - 1, n);
            if (log.isEnabled(Log.LogLevel.DEBUG)) {
                StringBuilder stringBuilder = new StringBuilder();
                if (byArray.length <= 20) {
                    stringBuilder.append(new String(byArray));
                } else {
                    stringBuilder.append(new String(Arrays.copyOfRange(byArray, this.alignmentStart - 1, this.alignmentStart + 10)));
                    stringBuilder.append("...");
                    stringBuilder.append(new String(Arrays.copyOfRange(byArray, this.alignmentStart - 1 + n - 10, this.alignmentStart + n)));
                }
                log.debug(String.format("Slice md5: %s for %d:%d-%d, %s", String.format("%032x", new BigInteger(1, this.refMD5)), this.sequenceId, this.alignmentStart, this.alignmentStart + n - 1, stringBuilder.toString()));
            }
        }
    }

    public Object getAttribute(short s) {
        if (this.sliceTags == null) {
            return null;
        }
        SAMBinaryTagAndValue sAMBinaryTagAndValue = this.sliceTags.find(s);
        if (sAMBinaryTagAndValue != null) {
            return sAMBinaryTagAndValue.value;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (object != null && object.getClass().isArray() && Array.getLength(object) == 0) {
            throw new IllegalArgumentException("Empty value passed for tag " + string);
        }
        this.setAttribute(SAMTagUtil.getSingleton().makeBinaryTag(string), object);
    }

    public void setUnsignedArrayAttribute(String string, Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to setUnsignedArrayAttribute for tag " + string);
        }
        if (Array.getLength(object) == 0) {
            throw new IllegalArgumentException("Empty array passed to setUnsignedArrayAttribute for tag " + string);
        }
        this.setAttribute(SAMTagUtil.getSingleton().makeBinaryTag(string), object, true);
    }

    void setAttribute(short s, Object object) {
        this.setAttribute(s, object, false);
    }

    void setAttribute(short s, Object object, boolean bl) {
        if (!(object == null || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof String || object instanceof Character || object instanceof Float || object instanceof byte[] || object instanceof short[] || object instanceof int[] || object instanceof float[])) {
            throw new SAMException("Attribute type " + object.getClass() + " not supported. Tag: " + SAMTagUtil.getSingleton().makeStringTag(s));
        }
        if (object == null) {
            if (this.sliceTags != null) {
                this.sliceTags = this.sliceTags.remove(s);
            }
        } else {
            SAMBinaryTagAndValue sAMBinaryTagAndValue;
            if (!bl) {
                sAMBinaryTagAndValue = new SAMBinaryTagAndValue(s, object);
            } else {
                if (!object.getClass().isArray() || object instanceof float[]) {
                    throw new SAMException("Attribute type " + object.getClass() + " cannot be encoded as an unsigned array. Tag: " + SAMTagUtil.getSingleton().makeStringTag(s));
                }
                sAMBinaryTagAndValue = new SAMBinaryTagAndUnsignedArrayValue(s, object);
            }
            this.sliceTags = this.sliceTags == null ? sAMBinaryTagAndValue : this.sliceTags.insert(sAMBinaryTagAndValue);
        }
    }
}

