/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ITF8 {
    public static int readUnsignedITF8(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0x40) == 0) {
            return (n & 0x7F) << 8 | inputStream.read();
        }
        if ((n & 0x20) == 0) {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            return (n & 0x3F) << 16 | n2 << 8 | n3;
        }
        if ((n & 0x10) == 0) {
            return (n & 0x1F) << 24 | inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
        }
        return (n & 0xF) << 28 | inputStream.read() << 20 | inputStream.read() << 12 | inputStream.read() << 4 | 0xF & inputStream.read();
    }

    public static int writeUnsignedITF8(int n, OutputStream outputStream) throws IOException {
        if (n >>> 7 == 0) {
            outputStream.write(n);
            return 8;
        }
        if (n >>> 14 == 0) {
            outputStream.write(n >> 8 | 0x80);
            outputStream.write(n & 0xFF);
            return 16;
        }
        if (n >>> 21 == 0) {
            outputStream.write(n >> 16 | 0xC0);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            return 24;
        }
        if (n >>> 28 == 0) {
            outputStream.write(n >> 24 | 0xE0);
            outputStream.write(n >> 16 & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
            return 32;
        }
        outputStream.write(n >> 28 | 0xF0);
        outputStream.write(n >> 20 & 0xFF);
        outputStream.write(n >> 12 & 0xFF);
        outputStream.write(n >> 4 & 0xFF);
        outputStream.write(n & 0xFF);
        return 40;
    }

    public static int readUnsignedITF8(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = ITF8.readUnsignedITF8(byteBuffer);
        byteBuffer.clear();
        return n;
    }

    public static byte[] writeUnsignedITF8(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(n, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        byteBuffer.clear();
        return byArray;
    }

    public static int readUnsignedITF8(ByteBuffer byteBuffer) {
        int n = 0xFF & byteBuffer.get();
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0x40) == 0) {
            return (n & 0x7F) << 8 | 0xFF & byteBuffer.get();
        }
        if ((n & 0x20) == 0) {
            int n2 = 0xFF & byteBuffer.get();
            int n3 = 0xFF & byteBuffer.get();
            return (n & 0x3F) << 16 | n2 << 8 | n3;
        }
        if ((n & 0x10) == 0) {
            return (n & 0x1F) << 24 | (0xFF & byteBuffer.get()) << 16 | (0xFF & byteBuffer.get()) << 8 | 0xFF & byteBuffer.get();
        }
        return (n & 0xF) << 28 | (0xFF & byteBuffer.get()) << 20 | (0xFF & byteBuffer.get()) << 12 | (0xFF & byteBuffer.get()) << 4 | 0xF & byteBuffer.get();
    }

    public static void writeUnsignedITF8(int n, ByteBuffer byteBuffer) {
        if (n >>> 7 == 0) {
            byteBuffer.put((byte)n);
            return;
        }
        if (n >>> 14 == 0) {
            byteBuffer.put((byte)(n >> 8 | 0x80));
            byteBuffer.put((byte)(n & 0xFF));
            return;
        }
        if (n >>> 21 == 0) {
            byteBuffer.put((byte)(n >> 16 | 0xC0));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n & 0xFF));
            return;
        }
        if (n >>> 28 == 0) {
            byteBuffer.put((byte)(n >> 24 | 0xE0));
            byteBuffer.put((byte)(n >> 16 & 0xFF));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n & 0xFF));
            return;
        }
        byteBuffer.put((byte)(n >> 28 | 0xF0));
        byteBuffer.put((byte)(n >> 20 & 0xFF));
        byteBuffer.put((byte)(n >> 12 & 0xFF));
        byteBuffer.put((byte)(n >> 4 & 0xFF));
        byteBuffer.put((byte)(n & 0xFF));
    }
}

