/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CramNormalizer {
    private final SAMFileHeader header;
    private int readCounter = 0;
    private static Log log = Log.getInstance(CramNormalizer.class);
    private ReferenceSource referenceSource;

    private CramNormalizer(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
    }

    public CramNormalizer(SAMFileHeader sAMFileHeader, ReferenceSource referenceSource) {
        this.header = sAMFileHeader;
        this.referenceSource = referenceSource;
    }

    public void normalize(ArrayList<CramCompressionRecord> arrayList, byte[] byArray, int n, SubstitutionMatrix substitutionMatrix) {
        Object object;
        int n2 = this.readCounter;
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            cramCompressionRecord.index = ++this.readCounter;
            if (cramCompressionRecord.sequenceId == -1) {
                cramCompressionRecord.sequenceName = "*";
                cramCompressionRecord.alignmentStart = 0;
                continue;
            }
            cramCompressionRecord.sequenceName = this.header.getSequence(cramCompressionRecord.sequenceId).getSequenceName();
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            if (!cramCompressionRecord.isMultiFragment() || cramCompressionRecord.isDetached()) {
                cramCompressionRecord.recordsToNextFragment = -1;
                cramCompressionRecord.next = null;
                cramCompressionRecord.previous = null;
                continue;
            }
            if (!cramCompressionRecord.isHasMateDownStream()) continue;
            object = arrayList.get(cramCompressionRecord.index + cramCompressionRecord.recordsToNextFragment - n2);
            cramCompressionRecord.next = object;
            ((CramCompressionRecord)object).previous = cramCompressionRecord;
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            if (cramCompressionRecord.previous != null || cramCompressionRecord.next == null) continue;
            CramNormalizer.restoreMateInfo(cramCompressionRecord);
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            String string;
            if (cramCompressionRecord.readName != null) continue;
            cramCompressionRecord.readName = string = "" + cramCompressionRecord.index;
            if (cramCompressionRecord.next != null) {
                cramCompressionRecord.next.readName = string;
            }
            if (cramCompressionRecord.previous == null) continue;
            cramCompressionRecord.previous.readName = string;
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            if (cramCompressionRecord.isSegmentUnmapped()) continue;
            object = byArray;
            if ((byArray == null || byArray.length == 0) && this.referenceSource != null) {
                object = this.referenceSource.getReferenceBases(this.header.getSequence(cramCompressionRecord.sequenceId), true);
            }
            if (cramCompressionRecord.isUnknownBases()) {
                cramCompressionRecord.readBases = SAMRecord.NULL_SEQUENCE;
                continue;
            }
            cramCompressionRecord.readBases = CramNormalizer.restoreReadBases(cramCompressionRecord, (byte[])object, n, substitutionMatrix);
        }
        CramNormalizer.restoreQualityScores((byte)30, arrayList);
    }

    private static void restoreMateInfo(CramCompressionRecord cramCompressionRecord) {
        int n;
        if (cramCompressionRecord.next == null) {
            return;
        }
        CramCompressionRecord cramCompressionRecord2 = cramCompressionRecord;
        while (cramCompressionRecord2.next != null) {
            CramNormalizer.setNextMate(cramCompressionRecord2, cramCompressionRecord2.next);
            cramCompressionRecord2 = cramCompressionRecord2.next;
        }
        CramCompressionRecord cramCompressionRecord3 = cramCompressionRecord2;
        CramNormalizer.setNextMate(cramCompressionRecord3, cramCompressionRecord);
        cramCompressionRecord.templateSize = n = CramNormalizer.computeInsertSize(cramCompressionRecord, cramCompressionRecord3);
        cramCompressionRecord3.templateSize = -n;
    }

    private static void setNextMate(CramCompressionRecord cramCompressionRecord, CramCompressionRecord cramCompressionRecord2) {
        cramCompressionRecord.mateAlignmentStart = cramCompressionRecord2.alignmentStart;
        cramCompressionRecord.setMateUnmapped(cramCompressionRecord2.isSegmentUnmapped());
        cramCompressionRecord.setMateNegativeStrand(cramCompressionRecord2.isNegativeStrand());
        cramCompressionRecord.mateSequenceID = cramCompressionRecord2.sequenceId;
        if (cramCompressionRecord.mateSequenceID == -1) {
            cramCompressionRecord.mateAlignmentStart = 0;
        }
    }

    public static void restoreQualityScores(byte by, List<CramCompressionRecord> list) {
        for (CramCompressionRecord cramCompressionRecord : list) {
            CramNormalizer.restoreQualityScores(by, cramCompressionRecord);
        }
    }

    private static byte[] restoreQualityScores(byte by, CramCompressionRecord cramCompressionRecord) {
        if (!cramCompressionRecord.isForcePreserveQualityScores()) {
            boolean bl = true;
            byte[] byArray = new byte[cramCompressionRecord.readLength];
            Arrays.fill(byArray, by);
            if (cramCompressionRecord.readFeatures != null) {
                for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
                    switch (readFeature.getOperator()) {
                        case 81: {
                            int n = readFeature.getPosition();
                            byArray[n - 1] = ((BaseQualityScore)readFeature).getQualityScore();
                            bl = false;
                            break;
                        }
                        case 66: {
                            int n = readFeature.getPosition();
                            byArray[n - 1] = ((ReadBase)readFeature).getQualityScore();
                            bl = false;
                            break;
                        }
                    }
                }
            }
            cramCompressionRecord.qualityScores = bl ? SAMRecord.NULL_QUALS : byArray;
        } else {
            byte[] byArray = cramCompressionRecord.qualityScores;
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != -1) continue;
                byArray[i] = by;
                ++n;
            }
            if (n == byArray.length) {
                cramCompressionRecord.qualityScores = SAMRecord.NULL_QUALS;
            }
        }
        return cramCompressionRecord.qualityScores;
    }

    private static byte[] restoreReadBases(CramCompressionRecord cramCompressionRecord, byte[] byArray, int n, SubstitutionMatrix substitutionMatrix) {
        if (cramCompressionRecord.isUnknownBases() || cramCompressionRecord.readLength == 0) {
            return SAMRecord.NULL_SEQUENCE;
        }
        int n2 = cramCompressionRecord.readLength;
        byte[] byArray2 = new byte[n2];
        int n3 = 1;
        int n4 = cramCompressionRecord.alignmentStart - 1;
        int n5 = 0;
        if (cramCompressionRecord.readFeatures == null || cramCompressionRecord.readFeatures.isEmpty()) {
            if (byArray.length + n < n4 + byArray2.length) {
                Arrays.fill(byArray2, (byte)78);
                System.arraycopy(byArray, n4 - n, byArray2, 0, Math.min(byArray2.length, byArray.length + n - n4));
            } else {
                System.arraycopy(byArray, n4 - n, byArray2, 0, byArray2.length);
            }
            return byArray2;
        }
        List<ReadFeature> list = cramCompressionRecord.readFeatures;
        block11: for (ReadFeature readFeature : list) {
            while (n3 < readFeature.getPosition()) {
                int n6 = n4 + n5++ - n;
                byArray2[n3 - 1] = CramNormalizer.getByteOrDefault(byArray, n6, (byte)78);
                ++n3;
            }
            switch (readFeature.getOperator()) {
                case 88: {
                    Substitution substitution = (Substitution)readFeature;
                    byte by = CramNormalizer.getByteOrDefault(byArray, n4 + n5 - n, (byte)78);
                    by = Utils.normalizeBase(by);
                    byte by2 = substitutionMatrix.base(by, substitution.getCode());
                    substitution.setBase(by2);
                    substitution.setReferenceBase(by);
                    byArray2[n3++ - 1] = by2;
                    ++n5;
                    break;
                }
                case 73: {
                    Insertion insertion = (Insertion)readFeature;
                    for (int i = 0; i < insertion.getSequence().length; ++i) {
                        byArray2[n3++ - 1] = insertion.getSequence()[i];
                    }
                    continue block11;
                }
                case 83: {
                    SoftClip softClip = (SoftClip)readFeature;
                    for (int i = 0; i < softClip.getSequence().length; ++i) {
                        byArray2[n3++ - 1] = softClip.getSequence()[i];
                    }
                    continue block11;
                }
                case 68: {
                    Deletion deletion = (Deletion)readFeature;
                    n5 += deletion.getLength();
                    break;
                }
                case 105: {
                    InsertBase insertBase = (InsertBase)readFeature;
                    byArray2[n3++ - 1] = insertBase.getBase();
                    break;
                }
                case 78: {
                    n5 += ((RefSkip)readFeature).getLength();
                }
            }
        }
        while (n3 <= n2 && n4 + n5 - n < byArray.length) {
            byArray2[n3 - 1] = byArray[n4 + n5 - n];
            ++n3;
            ++n5;
        }
        for (ReadFeature readFeature : list) {
            switch (readFeature.getOperator()) {
                case 66: {
                    ReadBase readBase = (ReadBase)readFeature;
                    byArray2[readFeature.getPosition() - 1] = readBase.getBase();
                    break;
                }
            }
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = Utils.normalizeBase(byArray2[i]);
        }
        return byArray2;
    }

    private static byte getByteOrDefault(byte[] byArray, int n, byte by) {
        if (n >= byArray.length) {
            return by;
        }
        return byArray[n];
    }

    public static int computeInsertSize(CramCompressionRecord cramCompressionRecord, CramCompressionRecord cramCompressionRecord2) {
        if (cramCompressionRecord.isSegmentUnmapped() || cramCompressionRecord2.isSegmentUnmapped()) {
            return 0;
        }
        if (cramCompressionRecord.sequenceId != cramCompressionRecord2.sequenceId) {
            return 0;
        }
        int n = cramCompressionRecord.isNegativeStrand() ? cramCompressionRecord.getAlignmentEnd() : cramCompressionRecord.alignmentStart;
        int n2 = cramCompressionRecord2.isNegativeStrand() ? cramCompressionRecord2.getAlignmentEnd() : cramCompressionRecord2.alignmentStart;
        int n3 = n2 >= n ? 1 : -1;
        return n2 - n + n3;
    }
}

