/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;

class TextualBAMIndexWriter
implements BAMIndexWriter {
    protected final int nRef;
    protected final File output;
    private final PrintWriter pw;
    private int count = 0;

    public TextualBAMIndexWriter(int n, File file) {
        this.output = file;
        this.nRef = n;
        try {
            this.pw = new PrintWriter(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SAMException("Can't find output file " + file, fileNotFoundException);
        }
        this.writeHeader();
    }

    private void writeHeader() {
        this.pw.println("n_ref=" + this.nRef);
    }

    @Override
    public void writeReference(BAMIndexContent bAMIndexContent) {
        Object object2;
        int n;
        int n2 = bAMIndexContent.getReferenceSequence();
        if (bAMIndexContent == null) {
            this.writeNullContent(n2);
            ++this.count;
            return;
        }
        if (n2 != this.count) {
            throw new SAMException("Reference on content is " + n2 + " but expecting reference " + this.count);
        }
        ++this.count;
        BinningIndexContent.BinList binList = bAMIndexContent.getBins();
        int n3 = n = binList == null ? 0 : bAMIndexContent.getNumberOfNonNullBins();
        if (n == 0) {
            this.writeNullContent(n2);
            return;
        }
        BAMIndexMetaData bAMIndexMetaData = bAMIndexContent.getMetaData();
        this.pw.println("Reference " + n2 + " has n_bin= " + Integer.toString(n + (bAMIndexMetaData != null ? 1 : 0)));
        for (Object object2 : binList) {
            if (((Bin)object2).getBinNumber() == 37450) break;
            if (((Bin)object2).getChunkList() == null) {
                this.pw.println("  Ref " + n2 + " bin " + ((Bin)object2).getBinNumber() + " has no binArray");
                continue;
            }
            List<Chunk> list = ((Bin)object2).getChunkList();
            if (list == null) {
                this.pw.println("  Ref " + n2 + " bin " + ((Bin)object2).getBinNumber() + " has no chunkList");
                continue;
            }
            this.pw.print("  Ref " + n2 + " bin " + ((Bin)object2).getBinNumber() + " has n_chunk= " + list.size());
            if (list.size() == 0) {
                this.pw.println();
            }
            for (Chunk chunk : list) {
                this.pw.println("     Chunk: " + chunk.toString() + " start: " + Long.toString(chunk.getChunkStart(), 16) + " end: " + Long.toString(chunk.getChunkEnd(), 16));
            }
        }
        this.writeChunkMetaData(n2, bAMIndexMetaData);
        LinearIndex linearIndex = bAMIndexContent.getLinearIndex();
        if (linearIndex == null || linearIndex.getIndexEntries() == null) {
            this.pw.println("Reference " + n2 + " has n_intv= 0");
            return;
        }
        object2 = linearIndex.getIndexEntries();
        int n4 = linearIndex.getIndexStart();
        int n5 = ((Object)object2).length + n4;
        this.pw.println("Reference " + n2 + " has n_intv= " + n5);
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (object2[i] == 0L) continue;
            this.pw.println("  Ref " + n2 + " ioffset for " + (i + n4) + " is " + Long.toString((long)object2[i]));
        }
        this.pw.flush();
    }

    private void writeChunkMetaData(int n, BAMIndexMetaData bAMIndexMetaData) {
        int n2 = bAMIndexMetaData == null ? 0 : 2;
        this.pw.print("  Ref " + n + " bin 37450 has n_chunk= " + n2);
        if (n2 == 0) {
            this.pw.println();
        } else {
            this.pw.println("     Chunk:  start: " + Long.toString(bAMIndexMetaData.getFirstOffset(), 16) + " end: " + Long.toString(bAMIndexMetaData.getLastOffset(), 16));
            this.pw.println("     Chunk:  start: " + Long.toString(bAMIndexMetaData.getAlignedRecordCount(), 16) + " end: " + Long.toString(bAMIndexMetaData.getUnalignedRecordCount(), 16));
        }
    }

    private void writeNullContent(int n) {
        this.pw.println("Reference " + n + " has n_bin=0");
        this.pw.println("Reference " + n + " has n_intv=0");
    }

    @Override
    public void writeNoCoordinateRecordCount(Long l) {
        this.pw.println("No Coordinate Count=" + l);
    }

    @Override
    public void close() {
        this.pw.close();
    }
}

