/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextReader;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamStreams;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

@Deprecated
public class SAMFileReader
implements SamReader,
SamReader.Indexing {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean mIsBinary = false;
    private BAMIndex mIndex = null;
    private SAMRecordFactory samRecordFactory = new DefaultSAMRecordFactory();
    private SamReader.ReaderImplementation mReader = null;
    private File samFile = null;

    public static ValidationStringency getDefaultValidationStringency() {
        return defaultValidationStringency;
    }

    public static void setDefaultValidationStringency(ValidationStringency validationStringency) {
        defaultValidationStringency = validationStringency;
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        SAMSequenceDictionary sAMSequenceDictionary = sAMFileReader.getFileHeader().getSequenceDictionary();
        CloserUtil.close(file);
        return sAMSequenceDictionary;
    }

    public SAMFileReader(InputStream inputStream) {
        this(inputStream, false);
    }

    public SAMFileReader(File file) {
        this(file, null, false);
    }

    public SAMFileReader(File file, File file2) {
        this(file, file2, false);
    }

    public SAMFileReader(InputStream inputStream, boolean bl) {
        this.init(inputStream, null, null, bl, defaultValidationStringency);
    }

    public SAMFileReader(File file, boolean bl) {
        this(file, null, bl);
    }

    public SAMFileReader(File file, File file2, boolean bl) {
        this.init(null, file, file2, bl, defaultValidationStringency);
    }

    public SAMFileReader(URL uRL, File file, boolean bl) {
        this.init((SeekableStream)new SeekableBufferedStream(new SeekableHTTPStream(uRL)), file, bl, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream seekableStream, File file, boolean bl) {
        this.init(seekableStream, file, bl, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream seekableStream, SeekableStream seekableStream2, boolean bl) {
        this.init(seekableStream, seekableStream2, bl, defaultValidationStringency);
    }

    @Override
    public void close() {
        if (this.mReader != null) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mIndex = null;
    }

    public void enableFileSource(boolean bl) {
        this.mReader.enableFileSource(this, bl);
    }

    public void enableIndexCaching(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mReader.enableIndexCaching(bl);
    }

    public void enableIndexMemoryMapping(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mReader.enableIndexMemoryMapping(bl);
    }

    public void enableCrcChecking(boolean bl) {
        this.mReader.enableCrcChecking(bl);
    }

    public void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
        this.samRecordFactory = sAMRecordFactory;
        this.mReader.setSAMRecordFactory(sAMRecordFactory);
    }

    public boolean isBinary() {
        return this.mIsBinary;
    }

    @Override
    public boolean hasIndex() {
        return this.mReader.hasIndex();
    }

    @Override
    public SamReader.Indexing indexing() {
        return this;
    }

    @Override
    public BAMIndex getIndex() {
        return this.mReader.getIndex();
    }

    @Override
    public boolean hasBrowseableIndex() {
        return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        BAMIndex bAMIndex = this.getIndex();
        if (!(bAMIndex instanceof BrowseableBAMIndex)) {
            throw new SAMException("Cannot return index: index created by BAM is not browseable.");
        }
        return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(bAMIndex);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.mReader.getFileHeader();
    }

    @Override
    public SamReader.Type type() {
        return this.mReader.type();
    }

    @Override
    public String getResourceDescription() {
        return this.toString();
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mReader.setValidationStringency(validationStringency);
    }

    @Override
    public SAMRecordIterator iterator() {
        return new SamReader.AssertingIterator(this.mReader.getIterator());
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan sAMFileSpan) {
        return new SamReader.AssertingIterator(this.mReader.getIterator(sAMFileSpan));
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return this.mReader.getFilePointerSpanningReads();
    }

    @Override
    public SAMRecordIterator query(String string, int n, int n2, boolean bl) {
        CloseableIterator<SAMRecord> closeableIterator;
        int n3 = this.getFileHeader().getSequenceIndex(string);
        if (n3 == -1) {
            closeableIterator = new EmptySamIterator();
        } else {
            QueryInterval[] queryIntervalArray = new QueryInterval[]{new QueryInterval(n3, n, n2)};
            closeableIterator = this.mReader.query(queryIntervalArray, bl);
        }
        return new SamReader.AssertingIterator(closeableIterator);
    }

    @Override
    public SAMRecordIterator queryOverlapping(String string, int n, int n2) {
        return this.query(string, n, n2, false);
    }

    @Override
    public SAMRecordIterator queryContained(String string, int n, int n2) {
        return this.query(string, n, n2, true);
    }

    @Override
    public SAMRecordIterator query(QueryInterval[] queryIntervalArray, boolean bl) {
        return new SamReader.AssertingIterator(this.mReader.query(queryIntervalArray, bl));
    }

    @Override
    public SAMRecordIterator queryOverlapping(QueryInterval[] queryIntervalArray) {
        return this.query(queryIntervalArray, false);
    }

    @Override
    public SAMRecordIterator queryContained(QueryInterval[] queryIntervalArray) {
        return this.query(queryIntervalArray, true);
    }

    @Override
    public SAMRecordIterator queryUnmapped() {
        return new SamReader.AssertingIterator(this.mReader.queryUnmapped());
    }

    @Override
    public SAMRecordIterator queryAlignmentStart(String string, int n) {
        return new SamReader.AssertingIterator(this.mReader.queryAlignmentStart(string, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAMRecord queryMate(SAMRecord sAMRecord) {
        if (!sAMRecord.getReadPairedFlag()) {
            throw new IllegalArgumentException("queryMate called for unpaired read.");
        }
        if (sAMRecord.getFirstOfPairFlag() == sAMRecord.getSecondOfPairFlag()) {
            throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
        }
        boolean bl = sAMRecord.getFirstOfPairFlag();
        SAMRecordIterator sAMRecordIterator = sAMRecord.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(sAMRecord.getMateReferenceName(), sAMRecord.getMateAlignmentStart());
        try {
            SAMRecord sAMRecord2;
            SAMRecord sAMRecord3 = null;
            while (sAMRecordIterator.hasNext()) {
                sAMRecord2 = (SAMRecord)sAMRecordIterator.next();
                if (!sAMRecord2.getReadPairedFlag()) {
                    if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) continue;
                    throw new SAMFormatException("Paired and unpaired reads with same name: " + sAMRecord.getReadName());
                }
                if ((!bl ? sAMRecord2.getSecondOfPairFlag() : sAMRecord2.getFirstOfPairFlag()) || !sAMRecord.getReadName().equals(sAMRecord2.getReadName())) continue;
                if (sAMRecord3 != null) {
                    throw new SAMFormatException("Multiple SAMRecord with read name " + sAMRecord.getReadName() + " for " + (bl ? "second" : "first") + " end.");
                }
                sAMRecord3 = sAMRecord2;
            }
            sAMRecord2 = sAMRecord3;
            return sAMRecord2;
        }
        finally {
            sAMRecordIterator.close();
        }
    }

    private void init(SeekableStream seekableStream, File file, boolean bl, ValidationStringency validationStringency) {
        try {
            if (!this.streamLooksLikeBam(seekableStream)) {
                throw new SAMFormatException("Unrecognized file format: " + seekableStream);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(seekableStream, file, bl, validationStringency, this.samRecordFactory);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private void init(SeekableStream seekableStream, SeekableStream seekableStream2, boolean bl, ValidationStringency validationStringency) {
        try {
            if (!this.streamLooksLikeBam(seekableStream)) {
                throw new SAMFormatException("Unrecognized file format: " + seekableStream);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(seekableStream, seekableStream2, bl, validationStringency, this.samRecordFactory);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private boolean streamLooksLikeBam(SeekableStream seekableStream) {
        String string = seekableStream.getSource();
        if (string == null) {
            return true;
        }
        return (string = string.toLowerCase()).endsWith(".bam") || string.contains(".bam?") || string.contains(".bam&") || string.contains(".bam%26");
    }

    private void init(InputStream inputStream, File file, File file2, boolean bl, ValidationStringency validationStringency) {
        if (inputStream != null && file != null) {
            throw new IllegalArgumentException("stream and file are mutually exclusive");
        }
        this.samFile = file;
        try {
            int n = Math.max(Defaults.BUFFER_SIZE, 65536);
            BufferedInputStream bufferedInputStream = file != null ? new BufferedInputStream(new FileInputStream(file), n) : IOUtil.toBufferedStream(inputStream);
            if (this.isBAMFile(bufferedInputStream)) {
                this.mIsBinary = true;
                if (file == null || !file.isFile()) {
                    this.mReader = new BAMFileReader(bufferedInputStream, file2, bl, validationStringency, this.samRecordFactory);
                } else {
                    bufferedInputStream.close();
                    this.mReader = new BAMFileReader(file, file2, bl, validationStringency, this.samRecordFactory);
                }
            } else if (BlockCompressedInputStream.isValidFile(bufferedInputStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new BlockCompressedInputStream(bufferedInputStream), validationStringency, this.samRecordFactory);
            } else if (this.isGzippedSAMFile(bufferedInputStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedInputStream), validationStringency, this.samRecordFactory);
            } else if (SamStreams.isCRAMFile(bufferedInputStream)) {
                if (file == null || !file.isFile()) {
                    file = null;
                } else {
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                }
                this.mReader = new CRAMFileReader(file, bufferedInputStream);
            } else if (this.isSAMFile(bufferedInputStream)) {
                if (file2 != null) {
                    bufferedInputStream.close();
                    throw new RuntimeException("Cannot use index file with textual SAM file");
                }
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedInputStream, file, validationStringency, this.samRecordFactory);
            } else {
                bufferedInputStream.close();
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(validationStringency);
            this.mReader.setSAMRecordFactory(this.samRecordFactory);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private boolean isBAMFile(InputStream inputStream) throws IOException {
        if (!BlockCompressedInputStream.isValidFile(inputStream)) {
            return false;
        }
        inputStream.mark(65536);
        byte[] byArray = new byte[65536];
        SAMFileReader.readBytes(inputStream, byArray, 0, 65536);
        inputStream.reset();
        byte[] byArray2 = new byte[4];
        int n = SAMFileReader.readBytes(new BlockCompressedInputStream(new ByteArrayInputStream(byArray)), byArray2, 0, 4);
        return n == BAMFileConstants.BAM_MAGIC.length && Arrays.equals(BAMFileConstants.BAM_MAGIC, byArray2);
    }

    private static int readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGzippedSAMFile(BufferedInputStream bufferedInputStream) {
        if (!bufferedInputStream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        bufferedInputStream.mark(8000);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
            int n = gZIPInputStream.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bufferedInputStream.reset();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }

    private boolean isSAMFile(InputStream inputStream) {
        return true;
    }

    public String toString() {
        if (this.samFile == null) {
            return this.getClass().getSimpleName() + "{initialized with stream}";
        }
        return this.getClass().getSimpleName() + "{" + this.samFile.getAbsolutePath() + "}";
    }

    public QueryInterval makeQueryInterval(String string, int n, int n2) {
        int n3 = this.getFileHeader().getSequenceIndex(string);
        if (n3 < 0) {
            throw new IllegalArgumentException(String.format("Sequence '%s' not found in sequence dictionary", string));
        }
        if (n < 1) {
            throw new IllegalArgumentException("Start position must be >= 1");
        }
        return new QueryInterval(n3, n, n2);
    }

    public QueryInterval makeQueryInterval(String string, int n) {
        return this.makeQueryInterval(string, n, 0);
    }

    private static class EmptySamIterator
    implements CloseableIterator<SAMRecord> {
        private EmptySamIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new NoSuchElementException("next called on empty iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        @Override
        public void close() {
        }
    }
}

