/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;

public abstract class DownsamplingIterator
implements CloseableIterator<SAMRecord> {
    private long recordsSeen;
    private long recordsAccepted;
    private double targetProportion;

    public DownsamplingIterator(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("targetProportion must be >= 0");
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("targetProportion must be <= 1");
        }
        this.targetProportion = d;
    }

    @Override
    public void close() {
    }

    public long getSeenCount() {
        return this.recordsSeen;
    }

    public long getAcceptedCount() {
        return this.recordsAccepted;
    }

    public long getDiscardedCount() {
        return this.recordsSeen - this.recordsAccepted;
    }

    public double getDiscardedFraction() {
        return (double)this.getDiscardedCount() / (double)this.getSeenCount();
    }

    public double getAcceptedFraction() {
        return (double)this.getAcceptedCount() / (double)this.getSeenCount();
    }

    public void resetStatistics() {
        this.recordsSeen = 0L;
        this.recordsAccepted = 0L;
    }

    public double getTargetProportion() {
        return this.targetProportion;
    }

    protected final void recordDiscardedRecord() {
        ++this.recordsSeen;
    }

    protected final void recordAcceptedRecord() {
        ++this.recordsSeen;
        ++this.recordsAccepted;
    }

    protected final void recordDiscardRecords(long l) {
        this.recordsSeen += l;
    }

    protected final void recordAcceptedRecords(long l) {
        this.recordsSeen += l;
        this.recordsAccepted += l;
    }

    public boolean isHigherAccuracy() {
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported in DownsamplingIterators");
    }
}

