/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.io.File;

public class Defaults {
    public static final boolean CREATE_INDEX = Defaults.getBooleanProperty("create_index", false);
    public static final boolean CREATE_MD5 = Defaults.getBooleanProperty("create_md5", false);
    public static final boolean USE_ASYNC_IO = Defaults.getBooleanProperty("use_async_io", false);
    public static final int COMPRESSION_LEVEL = Defaults.getIntProperty("compression_level", 5);
    public static final int BUFFER_SIZE = Defaults.getIntProperty("buffer_size", 131072);
    public static final int NON_ZERO_BUFFER_SIZE;
    public static final boolean TRY_USE_INTEL_DEFLATER;
    public static final String INTEL_DEFLATER_SHARED_LIBRARY_PATH;
    public static final File REFERENCE_FASTA;
    public static final String CUSTOM_READER_FACTORY;
    public static final boolean USE_CRAM_REF_DOWNLOAD;
    public static final String EBI_REFERENCE_SEVICE_URL_MASK;

    private static String getStringProperty(String string, String string2) {
        return System.getProperty("samjdk." + string, string2);
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = Defaults.getStringProperty(string, new Boolean(bl).toString());
        return Boolean.parseBoolean(string2);
    }

    private static int getIntProperty(String string, int n) {
        String string2 = Defaults.getStringProperty(string, new Integer(n).toString());
        return Integer.parseInt(string2);
    }

    private static File getFileProperty(String string, String string2) {
        String string3 = Defaults.getStringProperty(string, string2);
        return null == string3 ? null : new File(string3);
    }

    static {
        TRY_USE_INTEL_DEFLATER = Defaults.getBooleanProperty("try_use_intel_deflater", true);
        INTEL_DEFLATER_SHARED_LIBRARY_PATH = Defaults.getStringProperty("intel_deflater_so_path", null);
        NON_ZERO_BUFFER_SIZE = BUFFER_SIZE == 0 ? 131072 : BUFFER_SIZE;
        REFERENCE_FASTA = Defaults.getFileProperty("reference_fasta", null);
        USE_CRAM_REF_DOWNLOAD = Defaults.getBooleanProperty("use_cram_ref_download", false);
        EBI_REFERENCE_SEVICE_URL_MASK = "http://www.ebi.ac.uk/ena/cram/md5/%s";
        CUSTOM_READER_FACTORY = Defaults.getStringProperty("custom_reader", "");
    }
}

