/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.exec;

import edu.mayo.exec.BaseCommand;
import edu.mayo.exec.StreamGobbler;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Command
extends BaseCommand {
    private static final Logger sLogger = Logger.getLogger(Command.class);
    private String mStdout = null;
    private String mStderr = null;
    private Integer mExit = null;

    public Command(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv) {
        super(cmdarray, customEnv, useParentEnv);
    }

    public void execute() throws IOException, InterruptedException {
        this.execute(Collections.<String>emptyList());
    }

    public void execute(List<String> inputLines) throws IOException, InterruptedException {
        Process p = this.launchProcess();
        StreamGobbler stdoutGobbler = new StreamGobbler(p.getInputStream());
        Thread stdoutThread = new Thread((Runnable)stdoutGobbler, "STDOUT");
        stdoutThread.start();
        sLogger.debug((Object)String.format("Started %s gobbler", stdoutThread.getName()));
        StreamGobbler stderrGobbler = new StreamGobbler(p.getErrorStream());
        Thread stderrThread = new Thread((Runnable)stderrGobbler, "STDERR");
        stderrThread.start();
        sLogger.debug((Object)String.format("Started %s gobbler", stderrThread.getName()));
        PrintWriter stdinWriter = new PrintWriter(new OutputStreamWriter(p.getOutputStream()));
        for (String line : inputLines) {
            stdinWriter.println(line);
            if (!sLogger.isDebugEnabled()) continue;
            sLogger.debug((Object)String.format("Sent line to STDIN: %s", line));
        }
        stdinWriter.flush();
        stdinWriter.close();
        sLogger.debug((Object)"Sent signal end-of-transmission to STDIN");
        int exit = p.waitFor();
        sLogger.debug((Object)String.format("Process exited with exit code %s", exit));
        this.mExit = new Integer(exit);
        stdoutThread.join();
        stderrThread.join();
        this.mStdout = stdoutGobbler.getContent();
        this.mStderr = stderrGobbler.getContent();
    }

    public Integer getExitCode() {
        return this.mExit;
    }

    public String getStdout() {
        return this.mStdout;
    }

    public String getStderr() {
        return this.mStderr;
    }
}

