/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.LineReader;
import java.util.regex.Pattern;

public class StringLineReader
implements LineReader {
    private static final Pattern CRLF = Pattern.compile("\r\n");
    private final String theString;
    private int curPos = 0;
    private int lineNumber = 0;

    public StringLineReader(String string) {
        this.theString = CRLF.matcher(string).replaceAll("\n").replace('\r', '\n');
    }

    @Override
    public String readLine() {
        return this.readLine(false);
    }

    private String readLine(boolean bl) {
        if (this.curPos == this.theString.length()) {
            return null;
        }
        int n = this.theString.indexOf(10, this.curPos);
        if (n == -1) {
            int n2 = this.curPos;
            this.curPos = this.theString.length();
            ++this.lineNumber;
            return this.theString.substring(n2);
        }
        int n3 = this.curPos;
        int n4 = n + (bl ? 1 : 0);
        this.curPos = n + 1;
        ++this.lineNumber;
        return this.theString.substring(n3, n4);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int peek() {
        if (this.curPos == this.theString.length()) {
            return -1;
        }
        return this.theString.charAt(this.curPos);
    }

    @Override
    public void close() {
        this.curPos = this.theString.length();
    }
}

