/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class Writer {
    private Charset charset = Charset.forName("UTF8");
    private boolean captureReadNames = false;
    @DataSeries(key=EncodingKey.BF_BitFlags, type=DataSeriesType.INT)
    public DataWriter<Integer> bitFlagsC;
    @DataSeries(key=EncodingKey.CF_CompressionBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> compBitFlagsC;
    @DataSeries(key=EncodingKey.RL_ReadLength, type=DataSeriesType.INT)
    public DataWriter<Integer> readLengthC;
    @DataSeries(key=EncodingKey.AP_AlignmentPositionOffset, type=DataSeriesType.INT)
    public DataWriter<Integer> alStartC;
    @DataSeries(key=EncodingKey.RG_ReadGroup, type=DataSeriesType.INT)
    public DataWriter<Integer> readGroupC;
    @DataSeries(key=EncodingKey.RN_ReadName, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> readNameC;
    @DataSeries(key=EncodingKey.NF_RecordsToNextFragment, type=DataSeriesType.INT)
    public DataWriter<Integer> distanceC;
    @DataSeriesMap(name="TAG")
    public Map<Integer, DataWriter<byte[]>> tagValueCodecs;
    @DataSeries(key=EncodingKey.FN_NumberOfReadFeatures, type=DataSeriesType.INT)
    public DataWriter<Integer> numberOfReadFeaturesCodec;
    @DataSeries(key=EncodingKey.FP_FeaturePosition, type=DataSeriesType.INT)
    public DataWriter<Integer> featurePositionCodec;
    @DataSeries(key=EncodingKey.FC_FeatureCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> featuresCodeCodec;
    @DataSeries(key=EncodingKey.BA_Base, type=DataSeriesType.BYTE)
    public DataWriter<Byte> baseCodec;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE)
    public DataWriter<Byte> qualityScoreCodec;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> qualityScoreArrayCodec;
    @DataSeries(key=EncodingKey.BS_BaseSubstitutionCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> baseSubstitutionCodeCodec;
    @DataSeries(key=EncodingKey.IN_Insertion, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> insertionCodec;
    @DataSeries(key=EncodingKey.SC_SoftClip, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> softClipCodec;
    @DataSeries(key=EncodingKey.HC_HardClip, type=DataSeriesType.INT)
    public DataWriter<Integer> hardClipCodec;
    @DataSeries(key=EncodingKey.PD_padding, type=DataSeriesType.INT)
    public DataWriter<Integer> paddingCodec;
    @DataSeries(key=EncodingKey.DL_DeletionLength, type=DataSeriesType.INT)
    public DataWriter<Integer> deletionLengthCodec;
    @DataSeries(key=EncodingKey.MQ_MappingQualityScore, type=DataSeriesType.INT)
    public DataWriter<Integer> mappingQualityScoreCodec;
    @DataSeries(key=EncodingKey.MF_MateBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> mateBitFlagsCodec;
    @DataSeries(key=EncodingKey.NS_NextFragmentReferenceSequenceID, type=DataSeriesType.INT)
    public DataWriter<Integer> nextFragmentReferenceSequenceIDCodec;
    @DataSeries(key=EncodingKey.NP_NextFragmentAlignmentStart, type=DataSeriesType.INT)
    public DataWriter<Integer> nextFragmentAlignmentStart;
    @DataSeries(key=EncodingKey.TS_InsetSize, type=DataSeriesType.INT)
    public DataWriter<Integer> templateSize;
    @DataSeries(key=EncodingKey.TL_TagIdList, type=DataSeriesType.INT)
    public DataWriter<Integer> tagIdListCodec;
    @DataSeries(key=EncodingKey.RI_RefId, type=DataSeriesType.INT)
    public DataWriter<Integer> refIdCodec;
    @DataSeries(key=EncodingKey.RS_RefSkip, type=DataSeriesType.INT)
    public DataWriter<Integer> refSkipCodec;
    public int refId;
    public SubstitutionMatrix substitutionMatrix;
    public boolean AP_delta = true;
    public static int detachedCount = 0;

    public void write(CramCompressionRecord cramCompressionRecord) throws IOException {
        int n;
        this.bitFlagsC.writeData(cramCompressionRecord.flags);
        this.compBitFlagsC.writeData(cramCompressionRecord.getCompressionFlags());
        if (this.refId == -2) {
            this.refIdCodec.writeData(cramCompressionRecord.sequenceId);
        }
        this.readLengthC.writeData(cramCompressionRecord.readLength);
        if (this.AP_delta) {
            this.alStartC.writeData(cramCompressionRecord.alignmentDelta);
        } else {
            this.alStartC.writeData(cramCompressionRecord.alignmentStart);
        }
        this.readGroupC.writeData(cramCompressionRecord.readGroupID);
        if (this.isCaptureReadNames()) {
            this.readNameC.writeData(cramCompressionRecord.readName.getBytes(this.charset));
        }
        if (cramCompressionRecord.isDetached()) {
            this.mateBitFlagsCodec.writeData(cramCompressionRecord.getMateFlags());
            if (!this.isCaptureReadNames()) {
                this.readNameC.writeData(cramCompressionRecord.readName.getBytes(this.charset));
            }
            this.nextFragmentReferenceSequenceIDCodec.writeData(cramCompressionRecord.mateSequenceID);
            this.nextFragmentAlignmentStart.writeData(cramCompressionRecord.mateAlignmentStart);
            this.templateSize.writeData(cramCompressionRecord.templateSize);
            ++detachedCount;
        } else if (cramCompressionRecord.isHasMateDownStream()) {
            this.distanceC.writeData(cramCompressionRecord.recordsToNextFragment);
        }
        this.tagIdListCodec.writeData(cramCompressionRecord.tagIdsIndex.value);
        if (cramCompressionRecord.tags != null) {
            for (n = 0; n < cramCompressionRecord.tags.length; ++n) {
                DataWriter<byte[]> dataWriter = this.tagValueCodecs.get(cramCompressionRecord.tags[n].keyType3BytesAsInt);
                dataWriter.writeData(cramCompressionRecord.tags[n].getValueAsByteArray());
            }
        }
        if (!cramCompressionRecord.isSegmentUnmapped()) {
            this.numberOfReadFeaturesCodec.writeData(cramCompressionRecord.readFeatures.size());
            n = 0;
            block16: for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
                this.featuresCodeCodec.writeData(readFeature.getOperator());
                switch (readFeature.getOperator()) {
                    case 88: {
                        break;
                    }
                }
                this.featurePositionCodec.writeData(readFeature.getPosition() - n);
                n = readFeature.getPosition();
                switch (readFeature.getOperator()) {
                    case 66: {
                        ReadBase readBase = (ReadBase)readFeature;
                        this.baseCodec.writeData(readBase.getBase());
                        this.qualityScoreCodec.writeData(readBase.getQualityScore());
                        continue block16;
                    }
                    case 88: {
                        Substitution substitution = (Substitution)readFeature;
                        if (substitution.getCode() < 0) {
                            this.baseSubstitutionCodeCodec.writeData(this.substitutionMatrix.code(substitution.getReferenceBase(), substitution.getBase()));
                            continue block16;
                        }
                        this.baseSubstitutionCodeCodec.writeData(substitution.getCode());
                        continue block16;
                    }
                    case 73: {
                        Insertion insertion = (Insertion)readFeature;
                        this.insertionCodec.writeData(insertion.getSequence());
                        continue block16;
                    }
                    case 83: {
                        SoftClip softClip = (SoftClip)readFeature;
                        this.softClipCodec.writeData(softClip.getSequence());
                        continue block16;
                    }
                    case 72: {
                        HardClip hardClip = (HardClip)readFeature;
                        this.hardClipCodec.writeData(hardClip.getLength());
                        continue block16;
                    }
                    case 80: {
                        Padding padding = (Padding)readFeature;
                        this.paddingCodec.writeData(padding.getLength());
                        continue block16;
                    }
                    case 68: {
                        Deletion deletion = (Deletion)readFeature;
                        this.deletionLengthCodec.writeData(deletion.getLength());
                        continue block16;
                    }
                    case 78: {
                        RefSkip refSkip = (RefSkip)readFeature;
                        this.refSkipCodec.writeData(refSkip.getLength());
                        continue block16;
                    }
                    case 105: {
                        InsertBase insertBase = (InsertBase)readFeature;
                        this.baseCodec.writeData(insertBase.getBase());
                        continue block16;
                    }
                    case 81: {
                        BaseQualityScore baseQualityScore = (BaseQualityScore)readFeature;
                        this.qualityScoreCodec.writeData(baseQualityScore.getQualityScore());
                        continue block16;
                    }
                }
                throw new RuntimeException("Unknown read feature operator: " + (char)readFeature.getOperator());
            }
            this.mappingQualityScoreCodec.writeData(cramCompressionRecord.mappingQuality);
            if (cramCompressionRecord.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(cramCompressionRecord.qualityScores);
            }
        } else {
            if (!cramCompressionRecord.isUnknownBases()) {
                for (byte by : cramCompressionRecord.readBases) {
                    this.baseCodec.writeData(by);
                }
            }
            if (cramCompressionRecord.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(cramCompressionRecord.qualityScores);
            }
        }
    }

    public boolean isCaptureReadNames() {
        return this.captureReadNames;
    }

    public void setCaptureReadNames(boolean bl) {
        this.captureReadNames = bl;
    }
}

