/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.SubexponentialIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SubexponentialIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.SUBEXPONENTIAL;
    private int offset;
    private int k;

    public SubexponentialIntegerEncoding() {
    }

    public SubexponentialIntegerEncoding(int n, int n2) {
        this.offset = n;
        this.k = n2;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int n, int n2) {
        SubexponentialIntegerEncoding subexponentialIntegerEncoding = new SubexponentialIntegerEncoding();
        subexponentialIntegerEncoding.offset = n;
        subexponentialIntegerEncoding.k = n2;
        return new EncodingParams(ENCODING_ID, subexponentialIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, byteBuffer);
        ITF8.writeUnsignedITF8(this.k, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.offset = ITF8.readUnsignedITF8(byteBuffer);
        this.k = ITF8.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new SubexponentialIntegerCodec(this.offset, this.k);
    }
}

