/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TestUtil {
    public static File getTempDirectory(String string, String string2) {
        File file;
        try {
            file = File.createTempFile(string, string2);
        }
        catch (IOException iOException) {
            throw new SAMException("Failed to create temporary file.", iOException);
        }
        if (!file.delete()) {
            throw new SAMException("Failed to delete file: " + file);
        }
        if (!file.mkdir()) {
            throw new SAMException("Failed to make directory: " + file);
        }
        file.deleteOnExit();
        return file;
    }

    public static File getTempDirecory(String string, String string2) {
        return TestUtil.getTempDirectory(string, string2);
    }

    public static void recursiveDelete(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                TestUtil.recursiveDelete(file2);
            }
            file2.delete();
        }
    }

    public static <T extends Serializable> T serializeAndDeserialize(T t) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(t);
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        Serializable serializable = (Serializable)objectInputStream.readObject();
        objectOutputStream.close();
        objectInputStream.close();
        return (T)serializable;
    }
}

