/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class AsciiWriter
extends Writer {
    private final OutputStream os;
    private final byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
    private int numBytes;

    public AsciiWriter(OutputStream outputStream) {
        this.os = outputStream;
        this.numBytes = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.os.write(this.buffer, 0, this.numBytes);
        this.numBytes = 0;
        this.os.flush();
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = Math.min(n2, this.buffer.length - this.numBytes);
            StringUtil.charsToBytes(cArray, n, n3, this.buffer, this.numBytes);
            this.numBytes += n3;
            n += n3;
            n2 -= n3;
            if (this.numBytes != this.buffer.length) continue;
            this.os.write(this.buffer, 0, this.numBytes);
            this.numBytes = 0;
        }
    }
}

